/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.junit.Assert;

public class PsiTestUtil {
    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull Project project2, @NotNull Module module2, String rootPath, @NotNull Collection<? super File> filesToDelete) throws Exception {
        return PsiTestUtil.createTestProjectStructure(project2, module2, rootPath, filesToDelete, true);
    }

    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull Project project2, @NotNull Module module2, @NotNull Collection<? super File> filesToDelete) throws IOException {
        return PsiTestUtil.createTestProjectStructure(project2, module2, null, filesToDelete, true);
    }

    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull Project project2, @Nullable Module module2, String rootPath, @NotNull Collection<? super File> filesToDelete, boolean addProjectRoots) throws IOException {
        VirtualFile vDir = PsiTestUtil.createTestProjectStructure("unitTest", module2, rootPath, filesToDelete, addProjectRoots);
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        return vDir;
    }

    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull String tempName, @Nullable Module module2, String rootPath, @NotNull Collection<? super File> filesToDelete, boolean addProjectRoots) throws IOException {
        File dir = FileUtil.createTempDirectory((String)tempName, null, (boolean)false);
        filesToDelete.add(dir);
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
        assert (vDir != null && vDir.isDirectory()) : dir;
        PlatformTestCase.synchronizeTempDirVfs(vDir);
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> WriteAction.run(() -> {
            if (rootPath != null) {
                VirtualFile vDir1 = LocalFileSystem.getInstance().findFileByPath(rootPath.replace(File.separatorChar, '/'));
                if (vDir1 == null) {
                    throw new Exception(rootPath + " not found");
                }
                VfsUtil.copyDirectory(null, (VirtualFile)vDir1, (VirtualFile)vDir, null);
            }
            if (addProjectRoots) {
                PsiTestUtil.addSourceContentToRoots(module2, vDir);
            }
        })));
        return vDir;
    }

    public static void removeAllRoots(@NotNull Module module2, Sdk jdk) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            model.clear();
            model.setSdk(jdk);
        });
    }

    @NotNull
    public static SourceFolder addSourceContentToRoots(@NotNull Module module2, @NotNull VirtualFile vDir) {
        return PsiTestUtil.addSourceContentToRoots(module2, vDir, false);
    }

    @NotNull
    public static SourceFolder addSourceContentToRoots(@NotNull Module module2, @NotNull VirtualFile vDir, boolean testSource) {
        Ref result = Ref.create();
        ModuleRootModificationUtil.updateModel((Module)module2, model -> result.set((Object)model.addContentEntry(vDir).addSourceFolder(vDir, testSource)));
        return (SourceFolder)result.get();
    }

    @NotNull
    public static SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir) {
        return PsiTestUtil.addSourceRoot(module2, vDir, false);
    }

    @NotNull
    public static SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir, boolean isTestSource) {
        return PsiTestUtil.addSourceRoot(module2, vDir, isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
    }

    @NotNull
    public static <P extends JpsElement> SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType) {
        return PsiTestUtil.addSourceRoot(module2, vDir, rootType, (JpsElement)rootType.createDefaultProperties());
    }

    @NotNull
    public static <P extends JpsElement> SourceFolder addSourceRoot(@NotNull Module module2, @NotNull VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType, @NotNull P properties) {
        Ref result = Ref.create();
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntry((ModuleRootModel)model, vDir);
            if (entry == null) {
                entry = model.addContentEntry(vDir);
            }
            result.set((Object)entry.addSourceFolder(vDir, rootType, properties));
        });
        return (SourceFolder)result.get();
    }

    @Nullable
    private static ContentEntry findContentEntry(@NotNull ModuleRootModel rootModel, @NotNull VirtualFile file) {
        return (ContentEntry)ContainerUtil.find((Object[])rootModel.getContentEntries(), object -> {
            VirtualFile entryRoot = object.getFile();
            return entryRoot != null && VfsUtilCore.isAncestor((VirtualFile)entryRoot, (VirtualFile)file, (boolean)false);
        });
    }

    public static ContentEntry addContentRoot(@NotNull Module module2, @NotNull VirtualFile vDir) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> model.addContentEntry(vDir));
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module2).getContentEntries()) {
            if (!Comparing.equal((Object)entry.getFile(), (Object)vDir)) continue;
            Assert.assertFalse((boolean)((ContentEntryImpl)entry).isDisposed());
            return entry;
        }
        return null;
    }

    public static void addExcludedRoot(@NotNull Module module2, @NotNull VirtualFile dir) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ApplicationManager.getApplication().runReadAction(() -> PsiTestUtil.findContentEntryWithAssertion(model, dir).addExcludeFolder(dir)));
    }

    @NotNull
    private static ContentEntry findContentEntryWithAssertion(@NotNull ModifiableRootModel model, @NotNull VirtualFile dir) {
        ContentEntry entry = PsiTestUtil.findContentEntry((ModuleRootModel)model, dir);
        if (entry == null) {
            throw new RuntimeException(dir + " is not under content roots: " + Arrays.toString(model.getContentRoots()));
        }
        return entry;
    }

    public static void removeContentEntry(@NotNull Module module2, @NotNull VirtualFile contentRoot) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> model.removeContentEntry(PsiTestUtil.findContentEntryWithAssertion(model, contentRoot)));
    }

    public static void removeSourceRoot(@NotNull Module module2, @NotNull VirtualFile root) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model, root);
            for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                if (!root.equals(sourceFolder.getFile())) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
        });
    }

    public static void removeExcludedRoot(@NotNull Module module2, @NotNull VirtualFile root) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model, root);
            entry.removeExcludeFolder(root.getUrl());
        });
    }

    public static void checkErrorElements(@NotNull PsiElement element) {
        StringBuilder err = null;
        int s = 0;
        String text = element.getText();
        for (PsiErrorElement error : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)element)).filter(PsiErrorElement.class)) {
            TextRange r;
            if (err == null) {
                err = new StringBuilder();
            }
            if ((r = error.getTextRange()).getStartOffset() < s) continue;
            err.append(text, s, r.getStartOffset()).append("<error desc=\"");
            err.append(error.getErrorDescription()).append("\">");
            err.append(error.getText()).append("</error>");
            s = r.getEndOffset();
        }
        if (err == null) {
            return;
        }
        err.append(text, s, text.length());
        UsefulTestCase.assertSameLines(text, err.toString());
    }

    public static void checkFileStructure(@NotNull PsiFile file) {
        PsiTestUtil.compareFromAllRoots(file, (Function<? super PsiFile, String>)((Function)f -> DebugUtil.psiTreeToString((PsiElement)f, (boolean)false)));
    }

    private static void compareFromAllRoots(@NotNull PsiFile file, @NotNull Function<? super PsiFile, String> fun) {
        PsiFile dummyFile = PsiTestUtil.createDummyCopy(file);
        String psiTree = StringUtil.join((Collection)file.getViewProvider().getAllFiles(), fun, (String)"\n");
        String reparsedTree = StringUtil.join((Collection)dummyFile.getViewProvider().getAllFiles(), fun, (String)"\n");
        PsiTestUtil.assertPsiTextTreeConsistency(psiTree, reparsedTree);
    }

    private static void assertPsiTextTreeConsistency(@NotNull String psiTree, @NotNull String reparsedTree) {
        if (!psiTree.equals(reparsedTree)) {
            String[] psiLines = StringUtil.splitByLinesDontTrim((String)psiTree);
            String[] reparsedLines = StringUtil.splitByLinesDontTrim((String)reparsedTree);
            int i = 0;
            while (true) {
                if (i >= psiLines.length || i >= reparsedLines.length || !psiLines[i].equals(reparsedLines[i])) break;
                ++i;
            }
            int n = Math.min(i, psiLines.length - 1);
            psiLines[n] = psiLines[n] + "   // in PSI structure";
            int n2 = Math.min(i, reparsedLines.length - 1);
            reparsedLines[n2] = reparsedLines[n2] + "   // re-created from text";
            psiTree = StringUtil.join((String[])psiLines, (String)"\n");
            reparsedTree = StringUtil.join((String[])reparsedLines, (String)"\n");
            Assert.assertEquals((Object)reparsedTree, (Object)psiTree);
        }
    }

    @NotNull
    private static PsiFile createDummyCopy(@NotNull PsiFile file) {
        LightVirtualFile copy = new LightVirtualFile(file.getName(), (CharSequence)file.getText());
        copy.setOriginalFile(file.getViewProvider().getVirtualFile());
        PsiFile dummyCopy = Objects.requireNonNull(file.getManager().findFile((VirtualFile)copy));
        if (dummyCopy instanceof PsiFileImpl) {
            ((PsiFileImpl)dummyCopy).setOriginalFile(file);
        }
        return dummyCopy;
    }

    public static void checkPsiMatchesTextIgnoringNonCode(@NotNull PsiFile file) {
        PsiTestUtil.compareFromAllRoots(file, (Function<? super PsiFile, String>)((Function)f -> DebugUtil.psiToStringIgnoringNonCode((PsiElement)f)));
    }

    @Deprecated
    public static void disablePsiTextConsistencyChecks(@NotNull Disposable parentDisposable) {
        Registry.get((String)"ide.check.structural.psi.text.consistency.in.tests").setValue(false, parentDisposable);
    }

    @NotNull
    public static LibraryBuilder newLibrary(String name2) {
        return new LibraryBuilder(name2);
    }

    public static void addLibrary(@NotNull Module module2, @NotNull String libPath) {
        File file = new File(libPath);
        String libName = file.getName();
        PsiTestUtil.addLibrary(module2, libName, file.getParent(), libName);
    }

    public static void addLibrary(@NotNull Module module2, String libName, @NotNull String libPath, String ... jarArr) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> PsiTestUtil.addLibrary(model, libName, libPath, jarArr));
    }

    public static void addLibrary(@NotNull Disposable parent, @NotNull Module module2, String libName, @NotNull String libPath, String ... jarArr) {
        Ref ref = new Ref();
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ref.set((Object)PsiTestUtil.addLibrary(model, libName, libPath, jarArr)));
        Disposer.register((Disposable)parent, () -> {
            Library library = (Library)ref.get();
            ModuleRootModificationUtil.updateModel((Module)module2, model -> {
                LibraryOrderEntry entry = model.findLibraryOrderEntry(library);
                if (entry != null) {
                    model.removeOrderEntry((OrderEntry)entry);
                }
            });
            WriteCommandAction.runWriteCommandAction(null, () -> {
                LibraryTable table = ProjectLibraryTable.getInstance((Project)module2.getProject());
                LibraryTable.ModifiableModel model = table.getModifiableModel();
                model.removeLibrary(library);
                model.commit();
            });
        });
    }

    public static void addProjectLibrary(@NotNull Module module2, String libName, @NotNull List<String> classesRootPaths) {
        List<VirtualFile> roots = PsiTestUtil.getLibraryRoots(classesRootPaths);
        PsiTestUtil.addProjectLibrary(module2, libName, roots, Collections.emptyList());
    }

    @NotNull
    private static List<VirtualFile> getLibraryRoots(@NotNull List<String> classesRootPaths) {
        return ContainerUtil.map(classesRootPaths, path -> VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot((File)new File((String)path))));
    }

    public static void addProjectLibrary(@NotNull ModifiableRootModel model, String libName, @NotNull List<String> classesRootPaths) {
        List<VirtualFile> roots = PsiTestUtil.getLibraryRoots(classesRootPaths);
        PsiTestUtil.addProjectLibrary(model, libName, roots, Collections.emptyList(), Collections.emptyList());
    }

    public static void addProjectLibrary(@NotNull Module module2, String libName, VirtualFile ... classesRoots) {
        PsiTestUtil.addProjectLibrary(module2, libName, Arrays.asList(classesRoots), Collections.emptyList());
    }

    @NotNull
    public static Library addProjectLibrary(@NotNull Module module2, String libName, @NotNull List<? extends VirtualFile> classesRoots, @NotNull List<? extends VirtualFile> sourceRoots) {
        Ref result = Ref.create();
        ModuleRootModificationUtil.updateModel((Module)module2, model -> result.set((Object)PsiTestUtil.addProjectLibrary(model, libName, classesRoots, sourceRoots, Collections.emptyList())));
        return (Library)result.get();
    }

    @NotNull
    private static Library addProjectLibrary(@NotNull ModifiableRootModel model, String libName, @NotNull List<? extends VirtualFile> classesRoots, @NotNull List<? extends VirtualFile> sourceRoots, @NotNull List<? extends VirtualFile> javaDocs) {
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)model.getProject());
        return (Library)WriteAction.computeAndWait(() -> {
            Library library = libraryTable.createLibrary(libName);
            Library.ModifiableModel libraryModel = library.getModifiableModel();
            try {
                for (VirtualFile root : classesRoots) {
                    libraryModel.addRoot(root, OrderRootType.CLASSES);
                }
                for (VirtualFile root : sourceRoots) {
                    libraryModel.addRoot(root, OrderRootType.SOURCES);
                }
                for (VirtualFile root : javaDocs) {
                    libraryModel.addRoot(root, JavadocOrderRootType.getInstance());
                }
                libraryModel.commit();
            }
            catch (Throwable t) {
                libraryModel.dispose();
                throw t;
            }
            model.addLibraryEntry(library);
            OrderEntry[] orderEntries = model.getOrderEntries();
            OrderEntry last = orderEntries[orderEntries.length - 1];
            System.arraycopy(orderEntries, 0, orderEntries, 1, orderEntries.length - 1);
            orderEntries[0] = last;
            model.rearrangeOrderEntries(orderEntries);
            return library;
        });
    }

    @NotNull
    public static Library addLibrary(@NotNull ModifiableRootModel model, String libName, @NotNull String libPath, String ... jarArr) {
        ArrayList<VirtualFile> classesRoots = new ArrayList<VirtualFile>();
        for (String jar : jarArr) {
            String path;
            if (!libPath.endsWith("/") && !jar.startsWith("/")) {
                jar = "/" + jar;
            }
            VirtualFile root = (path = libPath + jar).endsWith(".jar") ? JarFileSystem.getInstance().refreshAndFindFileByPath(path + "!/") : LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            assert (root != null) : "Library root folder not found: " + path + "!/";
            classesRoots.add(root);
        }
        return PsiTestUtil.addProjectLibrary(model, libName, classesRoots, Collections.emptyList(), Collections.emptyList());
    }

    public static void addLibrary(@NotNull Module module2, String libName, @NotNull String libDir, @NotNull String[] classRoots, @NotNull String[] sourceRoots) {
        String proto = (classRoots.length > 0 ? classRoots[0] : sourceRoots[0]).endsWith(".jar!/") ? "jar" : "file";
        String parentUrl = VirtualFileManager.constructUrl((String)proto, (String)libDir);
        ArrayList<String> classesUrls = new ArrayList<String>();
        for (String classRoot : classRoots) {
            classesUrls.add(parentUrl + classRoot);
        }
        ArrayList<String> sourceUrls = new ArrayList<String>();
        for (String sourceRoot : sourceRoots) {
            sourceUrls.add(parentUrl + sourceRoot);
        }
        ModuleRootModificationUtil.addModuleLibrary((Module)module2, (String)libName, classesUrls, sourceUrls);
    }

    @NotNull
    public static Module addModule(@NotNull Project project2, @NotNull ModuleType type, @NotNull String name2, @NotNull VirtualFile root) {
        return (Module)WriteCommandAction.writeCommandAction((Project)project2).compute(() -> {
            String moduleName;
            ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
            try {
                moduleName = moduleModel.newModule(root.getPath() + "/" + name2 + ".iml", type.getId()).getName();
                moduleModel.commit();
            }
            catch (Throwable t) {
                moduleModel.dispose();
                throw t;
            }
            Module dep = ModuleManager.getInstance((Project)project2).findModuleByName(moduleName);
            assert (dep != null) : moduleName;
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)dep).getModifiableModel();
            try {
                model.addContentEntry(root).addSourceFolder(root, false);
                model.commit();
            }
            catch (Throwable t) {
                model.dispose();
                throw t;
            }
            return dep;
        });
    }

    public static void setCompilerOutputPath(@NotNull Module module2, @NotNull String url, boolean forTests) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            CompilerModuleExtension extension = (CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class);
            extension.inheritCompilerOutputPath(false);
            if (forTests) {
                extension.setCompilerOutputPathForTests(url);
            } else {
                extension.setCompilerOutputPath(url);
            }
        });
    }

    public static void setExcludeCompileOutput(@NotNull Module module2, boolean exclude) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(exclude));
    }

    public static void setJavadocUrls(@NotNull Module module2, String ... urls) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> ((JavaModuleExternalPaths)model.getModuleExtension(JavaModuleExternalPaths.class)).setJavadocUrls(urls));
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addJdkAnnotations(@NotNull Sdk sdk) {
        String path = FileUtil.toSystemIndependentName((String)PlatformTestUtil.getCommunityPath()) + "/java/jdkAnnotations";
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
        return PsiTestUtil.addRootsToJdk(sdk, AnnotationOrderRootType.getInstance(), root);
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addRootsToJdk(@NotNull Sdk sdk, @NotNull OrderRootType rootType, VirtualFile ... roots) {
        Sdk clone;
        try {
            clone = (Sdk)sdk.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        SdkModificator sdkModificator = clone.getSdkModificator();
        for (VirtualFile root : roots) {
            sdkModificator.addRoot(root, rootType);
        }
        sdkModificator.commitChanges();
        return clone;
    }

    public static void checkStubsMatchText(@NotNull PsiFile file) {
        try {
            StubTextInconsistencyException.checkStubTextConsistency((PsiFile)file);
        }
        catch (StubTextInconsistencyException e) {
            PsiTestUtil.compareStubTexts(e);
        }
    }

    public static void compareStubTexts(@NotNull StubTextInconsistencyException e) {
        PsiTestUtil.assertPsiTextTreeConsistency(e.getStubsFromPsi(), e.getStubsFromText());
        throw e;
    }

    public static void checkPsiStructureWithCommit(@NotNull PsiFile psiFile, @NotNull Consumer<? super PsiFile> checker) {
        checker.accept((PsiFile)psiFile);
        Document document2 = psiFile.getViewProvider().getDocument();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
        if (document2 != null && manager.isUncommited(document2)) {
            manager.commitDocument(document2);
            checker.accept((PsiFile)manager.getPsiFile(document2));
        }
    }

    public static class LibraryBuilder {
        private final String myName;
        private final List<VirtualFile> myClassesRoots = new ArrayList<VirtualFile>();
        private final List<VirtualFile> mySourceRoots = new ArrayList<VirtualFile>();
        private final List<VirtualFile> myJavaDocRoots = new ArrayList<VirtualFile>();

        private LibraryBuilder(String name2) {
            this.myName = name2;
        }

        @NotNull
        public LibraryBuilder classesRoot(@NotNull VirtualFile root) {
            this.myClassesRoots.add(root);
            return this;
        }

        @NotNull
        public LibraryBuilder classesRoot(@NotNull String rootPath) {
            this.myClassesRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot((File)new File(rootPath))));
            return this;
        }

        @NotNull
        public LibraryBuilder sourceRoot(@NotNull VirtualFile root) {
            this.mySourceRoots.add(root);
            return this;
        }

        @NotNull
        public LibraryBuilder sourceRoot(@NotNull String rootPath) {
            this.mySourceRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot((File)new File(rootPath))));
            return this;
        }

        @NotNull
        public LibraryBuilder javaDocRoot(@NotNull VirtualFile root) {
            this.myJavaDocRoots.add(root);
            return this;
        }

        @NotNull
        public LibraryBuilder javaDocRoot(@NotNull String rootPath) {
            this.myJavaDocRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot((File)new File(rootPath))));
            return this;
        }

        @NotNull
        public Library addTo(@NotNull ModifiableRootModel model) {
            return PsiTestUtil.addProjectLibrary(model, this.myName, this.myClassesRoots, this.mySourceRoots, this.myJavaDocRoots);
        }

        @NotNull
        public Library addTo(@NotNull Module module2) {
            Ref result = Ref.create();
            ModuleRootModificationUtil.updateModel((Module)module2, model -> result.set((Object)this.addTo((ModifiableRootModel)model)));
            return (Library)result.get();
        }
    }
}

