/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RunAll
implements Runnable {
    private final List<? extends ThrowableRunnable<?>> myActions;

    @SafeVarargs
    public RunAll(ThrowableRunnable<Throwable> ... actions) {
        this(ContainerUtil.newArrayList((Object[])actions));
    }

    private RunAll(@NotNull List<? extends ThrowableRunnable<?>> actions) {
        this.myActions = actions;
    }

    @SafeVarargs
    @Contract(pure=true)
    public final RunAll append(ThrowableRunnable<Throwable> ... actions) {
        return new RunAll(ContainerUtil.concat(this.myActions, (List)(actions.length == 1 ? Collections.singletonList(actions[0]) : ContainerUtilRt.newArrayList((Object[])actions))));
    }

    @Override
    public void run() {
        this.run(Collections.emptyList());
    }

    public void run(@NotNull List<? extends Throwable> suppressedExceptions) {
        List<Throwable> throwables = this.collectExceptions();
        throwables.addAll(0, suppressedExceptions);
        CompoundRuntimeException.throwIfNotEmpty(throwables);
    }

    @NotNull
    private List<Throwable> collectExceptions() {
        SmartList errors = new SmartList();
        for (ThrowableRunnable<?> action : this.myActions) {
            try {
                action.run();
            }
            catch (CompoundRuntimeException e) {
                errors.addAll(e.getExceptions());
            }
            catch (Throwable e) {
                errors.add(e);
            }
        }
        return errors;
    }
}

