/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.PlatformUtils;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class SdkLeakTracker {
    @NotNull
    private final Sdk[] oldSdks;

    public SdkLeakTracker() {
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        this.oldSdks = table == null ? new Sdk[]{} : table.getAllJdks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForJdkTableLeaks() {
        Sdk[] jdks;
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        if (table != null && (jdks = table.getAllJdks()).length != 0) {
            THashSet leaked = new THashSet(Arrays.asList(jdks));
            THashSet old = new THashSet(Arrays.asList(this.oldSdks));
            leaked.removeAll((Collection<?>)old);
            if (PlatformUtils.isAndroidStudio()) {
                SdkLeakTracker.exemptKotlinJdk((Set<Sdk>)leaked);
                if (!leaked.isEmpty()) {
                    SdkLeakTracker.exemptGradleJdk((Set<Sdk>)leaked);
                }
            }
            try {
                if (!leaked.isEmpty()) {
                    Assert.fail((String)("Leaked SDKs: " + leaked));
                }
            }
            finally {
                for (Sdk jdk : leaked) {
                    WriteAction.run(() -> table.removeJdk(jdk));
                }
            }
        }
    }

    private static void exemptGradleJdk(Set<Sdk> leaked) {
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            if (!"org.jetbrains.plugins.gradle".equals(descriptor2.getPluginId().getIdString())) continue;
            try {
                Class<?> serviceClass = descriptor2.getPluginClassLoader().loadClass("org.jetbrains.plugins.gradle.service.GradleInstallationManager");
                Object serviceInstance = ServiceManager.getService(serviceClass);
                Method getGradleJdk = serviceClass.getMethod("getGradleJdk", Project.class, String.class);
                Object jdk = getGradleJdk.invoke(serviceInstance, null, "ignored");
                if (!(jdk instanceof Sdk)) continue;
                leaked.remove(jdk);
                WriteAction.run(() -> ProjectJdkTable.getInstance().removeJdk((Sdk)jdk));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    private static void exemptKotlinJdk(Set<Sdk> leaked) {
        Sdk kotlinSdk = null;
        for (Sdk sdk : leaked) {
            if (!"Kotlin SDK".equals(sdk.getName())) continue;
            kotlinSdk = sdk;
            break;
        }
        if (kotlinSdk != null) {
            Sdk sdk = kotlinSdk;
            leaked.remove(sdk);
            WriteAction.run(() -> ProjectJdkTable.getInstance().removeJdk(sdk));
        }
    }
}

