/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.NettyUtil;
import org.junit.Assert;

public class ThreadTracker {
    private static final Logger LOG;
    private final Map<String, Thread> before = ThreadTracker.getThreads();
    private final boolean myDefaultProjectInitialized = ProjectManagerEx.getInstanceEx().isDefaultProjectInitialized();
    private static final Method getThreads;
    private static final Set<String> wellKnownOffenders;

    @NotNull
    public static Map<String, Thread> getThreads() {
        Object[] threads;
        try {
            threads = (Thread[])getThreads.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ContainerUtil.newMapFromValues((Iterator)ContainerUtil.iterate((Object[])threads), Thread::getName);
    }

    public static void longRunningThreadCreated(@NotNull Disposable parentDisposable, String ... threadNamePrefixes) {
        wellKnownOffenders.addAll(Arrays.asList(threadNamePrefixes));
        Disposer.register((Disposable)parentDisposable, () -> wellKnownOffenders.removeAll(Arrays.asList(threadNamePrefixes)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLeak() throws AssertionError {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NettyUtil.awaitQuiescenceOfGlobalEventExecutor((long)100L, (TimeUnit)TimeUnit.SECONDS);
        ShutDownTracker.getInstance().waitFor(100L, TimeUnit.SECONDS);
        try {
            if (this.myDefaultProjectInitialized != ProjectManagerEx.getInstanceEx().isDefaultProjectInitialized()) {
                return;
            }
            Map<String, Thread> all = ThreadTracker.getThreads();
            HashMap<String, Thread> after2 = new HashMap<String, Thread>(all);
            after2.keySet().removeAll(this.before.keySet());
            Map stackTraces = ContainerUtil.map2Map(after2.values(), thread -> Pair.create((Object)thread, (Object)thread.getStackTrace()));
            for (Thread thread2 : after2.values()) {
                ThreadGroup group;
                if (thread2 == Thread.currentThread() || (group = thread2.getThreadGroup()) != null && "system".equals(group.getName()) || !thread2.isAlive()) continue;
                long start = System.currentTimeMillis();
                StackTraceElement[] traceBeforeWait = thread2.getStackTrace();
                if (ThreadTracker.shouldIgnore(thread2, traceBeforeWait)) continue;
                int WAIT_SEC = 10;
                StackTraceElement[] stackTrace = traceBeforeWait;
                while (System.currentTimeMillis() < start + (long)(WAIT_SEC * 1000)) {
                    UIUtil.dispatchAllInvocationEvents();
                    stackTrace = thread2.getStackTrace();
                    if (!ThreadTracker.shouldIgnore(thread2, stackTrace)) continue;
                }
                stackTraces.put(thread2, stackTrace);
                if (ThreadTracker.shouldIgnore(thread2, stackTrace)) continue;
                all.keySet().removeAll(after2.keySet());
                Map otherStackTraces = ContainerUtil.map2Map(all.values(), t -> Pair.create((Object)t, (Object)t.getStackTrace()));
                String trace = PerformanceWatcher.printStacktrace((String)"", (Thread)thread2, (StackTraceElement[])stackTrace);
                String traceBefore = PerformanceWatcher.printStacktrace((String)"", (Thread)thread2, (StackTraceElement[])traceBeforeWait);
                Assert.fail((String)("Thread leaked: " + traceBefore + (trace.equals(traceBefore) ? "" : "(its trace after " + WAIT_SEC + " seconds wait:) " + trace) + "\n\nLeaking threads dump:\n" + ThreadTracker.dumpThreadsToString(after2, stackTraces) + "\n----\nAll other threads dump:\n" + ThreadTracker.dumpThreadsToString(all, otherStackTraces)));
            }
        }
        finally {
            this.before.clear();
        }
    }

    private static String dumpThreadsToString(Map<String, Thread> after2, Map<Thread, StackTraceElement[]> stackTraces) {
        StringBuilder f = new StringBuilder();
        after2.forEach((name2, thread) -> {
            f.append("\"" + name2 + "\" (" + (thread.isAlive() ? "alive" : "dead") + ") " + (Object)((Object)thread.getState()) + "\n");
            for (StackTraceElement element : (StackTraceElement[])stackTraces.get(thread)) {
                f.append("\tat " + element + "\n");
            }
            f.append("\n");
        });
        return f.toString();
    }

    private static boolean shouldIgnore(@NotNull Thread thread, @NotNull StackTraceElement[] stackTrace) {
        if (!thread.isAlive()) {
            return true;
        }
        if (ThreadTracker.isWellKnownOffender(thread.getName())) {
            return true;
        }
        if (stackTrace.length == 0) {
            return true;
        }
        if (ThreadTracker.isIdleApplicationPoolThread(stackTrace)) {
            return true;
        }
        return ThreadTracker.isIdleCommonPoolThread(thread, stackTrace) || ThreadTracker.isCoroutineSchedulerPoolThread(thread, stackTrace);
    }

    private static boolean isWellKnownOffender(@NotNull String threadName) {
        return ContainerUtil.exists(wellKnownOffenders, threadName::contains);
    }

    private static boolean isIdleApplicationPoolThread(@NotNull StackTraceElement[] stackTrace) {
        boolean insideTPEGetTask = Arrays.stream(stackTrace).anyMatch(element -> element.getMethodName().equals("getTask") && element.getClassName().equals("java.util.concurrent.ThreadPoolExecutor"));
        return insideTPEGetTask;
    }

    private static boolean isIdleCommonPoolThread(@NotNull Thread thread, @NotNull StackTraceElement[] stackTrace) {
        if (!ForkJoinWorkerThread.class.isAssignableFrom(thread.getClass())) {
            return false;
        }
        boolean insideAwaitWork = Arrays.stream(stackTrace).anyMatch(element -> element.getMethodName().equals("awaitWork") && element.getClassName().equals("java.util.concurrent.ForkJoinPool"));
        return insideAwaitWork;
    }

    private static boolean isCoroutineSchedulerPoolThread(@NotNull Thread thread, @NotNull StackTraceElement[] stackTrace) {
        if (!"kotlinx.coroutines.scheduling.CoroutineScheduler$Worker".equals(thread.getClass().getName())) {
            return false;
        }
        boolean insideCpuWorkerIdle = Arrays.stream(stackTrace).anyMatch(element -> element.getMethodName().equals("cpuWorkerIdle") && element.getClassName().equals("kotlinx.coroutines.scheduling.CoroutineScheduler$Worker"));
        return insideCpuWorkerIdle;
    }

    public static void awaitJDIThreadsTermination(int timeout, @NotNull TimeUnit unit) {
        ThreadTracker.awaitThreadTerminationWithParentParentGroup("JDI main", timeout, unit);
    }

    private static void awaitThreadTerminationWithParentParentGroup(@NotNull String grandThreadGroup, int timeout, @NotNull TimeUnit unit) {
        Thread jdiThread;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + unit.toMillis(timeout) && (jdiThread = (Thread)ContainerUtil.find(ThreadTracker.getThreads().values(), thread -> {
            ThreadGroup group = thread.getThreadGroup();
            return group != null && group.getParent() != null && grandThreadGroup.equals(group.getParent().getName());
        })) != null) {
            try {
                long timeLeft = start + unit.toMillis(timeout) - System.currentTimeMillis();
                LOG.debug("Waiting for the " + jdiThread + " for " + timeLeft + "ms");
                jdiThread.join(timeLeft);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        List sorted;
        LOG = Logger.getInstance(ThreadTracker.class);
        getThreads = (Method)ObjectUtils.notNull((Object)ReflectionUtil.getDeclaredMethod(Thread.class, (String)"getThreads", (Class[])new Class[0]));
        wellKnownOffenders = new THashSet();
        List<String> offenders = Arrays.asList("AWT-EventQueue-", "AWT-Shutdown", "AWT-Windows", "Batik CleanerThread", "CompilerThread0", "External compiler", "Finalizer", "Flushing Daemon", "IDEA Test Case Thread", "Image Fetcher ", "Java2D Disposer", "JobScheduler FJ pool ", "JPS thread pool", "Keep-Alive-Timer", "main", "Monitor Ctrl-Break", "Netty ", "ObjectCleanerThread", "Reference Handler", "RMI TCP Connection", "SeedGenerator Thread", "Signal Dispatcher", "timer-int", "timer-sys", "TimerQueue", "UserActivityMonitor thread", "VM Periodic Task Thread", "VM Thread", "YJPAgent-Telemetry");
        if (!offenders.equals(sorted = offenders.stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList()))) {
            String proper = StringUtil.join((Collection)ContainerUtil.map(sorted, s -> '\"' + s + '\"'), (String)",\n").replaceAll("\"Flushing Daemon\"", "FlushingDaemon.NAME");
            throw new AssertionError((Object)("Thread names must be sorted (for ease of maintainance). Something like this will do:\n" + proper));
        }
        wellKnownOffenders.addAll(offenders);
        Application application = ApplicationManager.getApplication();
        if (!application.isDisposed()) {
            ThreadTracker.longRunningThreadCreated((Disposable)application, "Periodic tasks thread", "ApplicationImpl pooled thread ", "Process I/O pool ");
        }
        try {
            Preferences.userRoot().flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }
}

