/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.exceptionCases.AbstractExceptionCase;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ui.UIUtil;
import gnu.trove.Equality;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.ComparisonFailure;

public abstract class UsefulTestCase
extends TestCase {
    public static final boolean IS_UNDER_TEAMCITY;
    public static final String TEMP_DIR_MARKER = "unitTest_";
    public static final boolean OVERWRITE_TESTDATA;
    private static final String ORIGINAL_TEMP_DIR;
    private static final Map<String, Long> TOTAL_SETUP_COST_MILLIS;
    private static final Map<String, Long> TOTAL_TEARDOWN_COST_MILLIS;
    protected static final Logger LOG;
    @NotNull
    private final Disposable myTestRootDisposable = new TestDisposable();
    static String ourPathToKeep;
    private final List<String> myPathsToKeep = new ArrayList<String>();
    private String myTempDir;
    static final Key<String> CREATION_PLACE;
    private static final String DEFAULT_SETTINGS_EXTERNALIZED;
    private static final CodeInsightSettings defaultSettings;
    private List<Throwable> mySuppressedExceptions;
    private static final Set<String> DELETE_ON_EXIT_HOOK_DOT_FILES;
    private static final Class DELETE_ON_EXIT_HOOK_CLASS;

    protected void addSuppressedException(@NotNull Throwable e) {
        SmartList list = this.mySuppressedExceptions;
        if (list == null) {
            this.mySuppressedExceptions = list = new SmartList();
        }
        list.add((Throwable)e);
    }

    public UsefulTestCase() {
    }

    public UsefulTestCase(@NotNull String name2) {
        super(name2);
    }

    protected boolean shouldContainTempFiles() {
        return true;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.shouldContainTempFiles()) {
            IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
            String testName = null;
            if (policy != null) {
                testName = policy.getPerTestTempDirName();
            }
            if (testName == null) {
                testName = FileUtil.sanitizeFileName((String)this.getTestName(true));
            }
            testName = new File(testName).getName();
            this.myTempDir = FileUtil.createTempDirectory((String)(TEMP_DIR_MARKER + testName), (String)"", (boolean)false).getPath();
            FileUtil.resetCanonicalTempPathCache((String)this.myTempDir);
        }
        boolean isStressTest = this.isStressTest();
        ApplicationInfoImpl.setInStressTest((boolean)isStressTest);
        if (this.isPerformanceTest()) {
            Timings.getStatistics();
        }
        Disposer.setDebugMode((!isStressTest ? 1 : 0) != 0);
    }

    protected void tearDown() throws Exception {
        new RunAll(() -> this.disposeRootDisposable(), () -> UsefulTestCase.cleanupSwingDataStructures(), () -> UsefulTestCase.cleanupDeleteOnExitHookList(), () -> Disposer.setDebugMode((boolean)true), () -> {
            if (this.shouldContainTempFiles()) {
                FileUtil.resetCanonicalTempPathCache((String)ORIGINAL_TEMP_DIR);
                if (this.hasTmpFilesToKeep()) {
                    File[] files = new File(this.myTempDir).listFiles();
                    if (files != null) {
                        for (File file : files) {
                            if (this.shouldKeepTmpFile(file)) continue;
                            FileUtil.delete((File)file);
                        }
                    }
                } else {
                    FileUtil.delete((File)new File(this.myTempDir));
                }
            }
        }, () -> UIUtil.removeLeakingAppleListeners(), () -> UsefulTestCase.waitForAppLeakingThreads(10L, TimeUnit.SECONDS)).run((List)ObjectUtils.notNull(this.mySuppressedExceptions, Collections.emptyList()));
    }

    protected final void disposeRootDisposable() {
        Disposer.dispose((Disposable)this.getTestRootDisposable());
    }

    protected void addTmpFileToKeep(@NotNull File file) {
        this.myPathsToKeep.add(file.getPath());
    }

    private boolean hasTmpFilesToKeep() {
        return ourPathToKeep != null && FileUtil.isAncestor((String)this.myTempDir, (String)ourPathToKeep, (boolean)false) || !this.myPathsToKeep.isEmpty();
    }

    private boolean shouldKeepTmpFile(@NotNull File file) {
        String path = file.getPath();
        if (FileUtil.pathsEqual((String)path, (String)ourPathToKeep)) {
            return true;
        }
        for (String pathToKeep : this.myPathsToKeep) {
            if (!FileUtil.pathsEqual((String)path, (String)pathToKeep)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupDeleteOnExitHookList() {
        ArrayList<String> list;
        Class clazz = DELETE_ON_EXIT_HOOK_CLASS;
        synchronized (clazz) {
            if (DELETE_ON_EXIT_HOOK_DOT_FILES.isEmpty()) {
                return;
            }
            list = new ArrayList<String>(DELETE_ON_EXIT_HOOK_DOT_FILES);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            String path = (String)list.get(i);
            File file = new File(path);
            if (!file.delete() && file.exists()) continue;
            Class clazz2 = DELETE_ON_EXIT_HOOK_CLASS;
            synchronized (clazz2) {
                DELETE_ON_EXIT_HOOK_DOT_FILES.remove(path);
                continue;
            }
        }
    }

    private static void cleanupSwingDataStructures() throws Exception {
        Object manager = ReflectionUtil.getDeclaredMethod(Class.forName("javax.swing.KeyboardManager"), (String)"getCurrentManager", (Class[])new Class[0]).invoke(null, new Object[0]);
        Map componentKeyStrokeMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"componentKeyStrokeMap");
        componentKeyStrokeMap.clear();
        Map containerMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"containerMap");
        containerMap.clear();
    }

    static void doCheckForSettingsDamage(@NotNull CodeStyleSettings oldCodeStyleSettings, @NotNull CodeStyleSettings currentCodeStyleSettings) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        new RunAll(new ThrowableRunnable[0]).append(() -> {
            try {
                UsefulTestCase.checkCodeInsightSettingsEqual(defaultSettings, settings);
            }
            catch (AssertionError error) {
                CodeInsightSettings clean = new CodeInsightSettings();
                for (Field field : clean.getClass().getFields()) {
                    try {
                        ReflectionUtil.copyFieldValue((Object)clean, (Object)settings, (Field)field);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw error;
            }
        }).append(() -> {
            currentCodeStyleSettings.getIndentOptions((FileType)StdFileTypes.JAVA);
            try {
                UsefulTestCase.checkCodeStyleSettingsEqual(oldCodeStyleSettings, currentCodeStyleSettings);
            }
            finally {
                currentCodeStyleSettings.clearCodeStyleSettings();
            }
        }).append(() -> InplaceRefactoring.checkCleared()).append(() -> StartMarkAction.checkCleared()).run();
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        return this.myTestRootDisposable;
    }

    protected void runTest() throws Throwable {
        Throwable[] throwables = new Throwable[1];
        Runnable runnable = () -> {
            try {
                TestLoggerFactory.onTestStarted();
                super.runTest();
                TestLoggerFactory.onTestFinished(true);
            }
            catch (InvocationTargetException e) {
                TestLoggerFactory.onTestFinished(false);
                e.fillInStackTrace();
                throwables[0] = e.getTargetException();
            }
            catch (IllegalAccessException e) {
                TestLoggerFactory.onTestFinished(false);
                e.fillInStackTrace();
                throwables[0] = e;
            }
            catch (Throwable e) {
                TestLoggerFactory.onTestFinished(false);
                throwables[0] = e;
            }
        };
        this.invokeTestRunnable(runnable);
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected boolean shouldRunTest() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null && !policy.canRun(((Object)((Object)this)).getClass())) {
            return false;
        }
        return TestFrameworkUtil.canRunTest(((Object)((Object)this)).getClass());
    }

    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null && !policy.runInDispatchThread()) {
            runnable.run();
        } else {
            EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)() -> {
                runnable.run();
                return null;
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void defaultRunBare() throws Throwable {
        Throwable exception;
        block13: {
            exception = null;
            long setupStart = System.nanoTime();
            this.setUp();
            long setupCost = (System.nanoTime() - setupStart) / 1000000L;
            this.logPerClassCost(setupCost, TOTAL_SETUP_COST_MILLIS);
            this.runTest();
            try {
                long teardownStart = System.nanoTime();
                this.tearDown();
                long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
            }
            catch (Throwable tearingDown) {
                if (exception == null) {
                    exception = tearingDown;
                    break block13;
                }
                exception = new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
            }
            break block13;
            catch (Throwable running) {
                try {
                    exception = running;
                }
                catch (Throwable throwable) {
                    try {
                        long teardownStart = System.nanoTime();
                        this.tearDown();
                        long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                        this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
                    }
                    catch (Throwable tearingDown) {
                        exception = exception == null ? tearingDown : new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
                    }
                    throw throwable;
                }
                try {
                    long teardownStart = System.nanoTime();
                    this.tearDown();
                    long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                    this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
                }
                catch (Throwable tearingDown) {
                    if (exception == null) {
                        exception = tearingDown;
                        break block13;
                    }
                    exception = new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void logPerClassCost(long cost, @NotNull Map<String, Long> costMap) {
        Class<?> superclass = ((Object)((Object)this)).getClass().getSuperclass();
        Long oldCost = costMap.get(superclass.getName());
        long newCost = oldCost == null ? cost : oldCost + cost;
        costMap.put(superclass.getName(), newCost);
    }

    static void logSetupTeardownCosts() {
        System.out.println("Setup costs");
        long totalSetup = 0L;
        for (Map.Entry<String, Long> entry : TOTAL_SETUP_COST_MILLIS.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            totalSetup += entry.getValue().longValue();
        }
        System.out.println("Teardown costs");
        long totalTeardown = 0L;
        for (Map.Entry<String, Long> entry : TOTAL_TEARDOWN_COST_MILLIS.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            totalTeardown += entry.getValue().longValue();
        }
        System.out.println(String.format("Total overhead: setup %d ms, teardown %d ms", totalSetup, totalTeardown));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalSetupMs' value='%d']", totalSetup));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalTeardownMs' value='%d']", totalTeardown));
    }

    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        if (this.runInDispatchThread()) {
            TestRunnerUtil.replaceIdeEventQueueSafely();
            EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)this::defaultRunBare));
        } else {
            this.defaultRunBare();
        }
    }

    protected boolean runInDispatchThread() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            return policy.runInDispatchThread();
        }
        return true;
    }

    protected void edt(@NotNull ThrowableRunnable<Throwable> runnable) {
        EdtTestUtil.runInEdtAndWait(runnable);
    }

    @NotNull
    public static String toString(@NotNull Iterable<?> collection) {
        if (!collection.iterator().hasNext()) {
            return "<empty>";
        }
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            if (o instanceof THashSet) {
                builder.append(new TreeSet((THashSet)o));
            } else {
                builder.append(o);
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull T[] actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals("", actual, expected);
    }

    public static void assertOrderedEquals(@NotNull byte[] actual, @NotNull byte[] expected) {
        UsefulTestCase.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            byte a = actual[i];
            byte e = expected[i];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i), (byte)e, (byte)a);
        }
    }

    public static void assertOrderedEquals(@NotNull int[] actual, @NotNull int[] expected) {
        if (actual.length != expected.length) {
            UsefulTestCase.fail((String)("Expected size: " + expected.length + "; actual: " + actual.length + "\nexpected: " + Arrays.toString(expected) + "\nactual  : " + Arrays.toString(actual)));
        }
        for (int i = 0; i < actual.length; ++i) {
            int a = actual[i];
            int e = expected[i];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i), (int)e, (int)a);
        }
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, Arrays.asList(expected));
    }

    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        UsefulTestCase.assertOrderedEquals("", actual, expected);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, expected, Equality.CANONICAL);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected, @NotNull Equality<? super T> comparator) {
        if (!UsefulTestCase.equals(actual, expected, comparator)) {
            String expectedString = UsefulTestCase.toString(expected);
            String actualString = UsefulTestCase.toString(actual);
            Assert.assertEquals((String)errorMsg, (Object)expectedString, (Object)actualString);
            Assert.fail((String)("Warning! 'toString' does not reflect the difference.\nExpected: " + expectedString + "\nActual: " + actualString));
        }
    }

    private static <T> boolean equals(@NotNull Iterable<? extends T> a1, @NotNull Iterable<? extends T> a2, @NotNull Equality<? super T> comparator) {
        Iterator<T> it1 = a1.iterator();
        Iterator<T> it2 = a2.iterator();
        while (it1.hasNext() || it2.hasNext()) {
            if (!it1.hasNext() || !it2.hasNext()) {
                return false;
            }
            if (comparator.equals(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull T[] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertOrderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull T[] actual, T ... expected) {
        UsefulTestCase.assertSameElements(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, T ... expected) {
        UsefulTestCase.assertSameElements(actual, Arrays.asList(expected));
    }

    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        UsefulTestCase.assertSameElements("", actual, expected);
    }

    public static <T> void assertSameElements(@NotNull String message, @NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        if (actual.size() != expected.size() || !new HashSet<T>(expected).equals(new HashSet<T>(actual))) {
            Assert.assertEquals((String)message, new HashSet<T>(expected), new HashSet<T>(actual));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertContainsOrdered(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        PeekableIteratorWrapper expectedIt = new PeekableIteratorWrapper(expected.iterator());
        PeekableIteratorWrapper actualIt = new PeekableIteratorWrapper(collection.iterator());
        while (actualIt.hasNext() && expectedIt.hasNext()) {
            Object actualElem;
            Object expectedElem = expectedIt.peek();
            if (expectedElem.equals(actualElem = actualIt.peek())) {
                expectedIt.next();
            }
            actualIt.next();
        }
        if (expectedIt.hasNext()) {
            throw new ComparisonFailure("", UsefulTestCase.toString(expected), UsefulTestCase.toString(collection));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertContainsElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.retainAll(expected);
        UsefulTestCase.assertSameElements(UsefulTestCase.toString(collection), copy, expected);
    }

    @NotNull
    public static String toString(@NotNull Object[] collection, @NotNull String separator) {
        return UsefulTestCase.toString(Arrays.asList(collection), separator);
    }

    @SafeVarargs
    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, T ... notExpected) {
        UsefulTestCase.assertDoesntContain(collection, Arrays.asList(notExpected));
    }

    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> notExpected) {
        ArrayList<T> expected = new ArrayList<T>(collection);
        expected.removeAll(notExpected);
        UsefulTestCase.assertSameElements(collection, expected);
    }

    @NotNull
    public static String toString(@NotNull Collection<?> collection, @NotNull String separator) {
        List list = ContainerUtil.map2List(collection, String::valueOf);
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (String o : list) {
            if (flag) {
                builder.append(separator);
            }
            builder.append(o);
            flag = true;
        }
        return builder.toString();
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        int i = 0;
        for (T actual : collection) {
            try {
                checkers[i].consume(actual);
            }
            catch (AssertionFailedError e) {
                System.out.println(i + ": " + actual);
                throw e;
            }
            ++i;
        }
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull T[] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        HashSet<Consumer<T>> checkerSet = new HashSet<Consumer<T>>(Arrays.asList(checkers));
        int i = 0;
        Throwable lastError = null;
        for (T actual : collection) {
            boolean flag = true;
            for (Consumer consumer : checkerSet) {
                Throwable error = UsefulTestCase.accepts(consumer, actual);
                if (error == null) {
                    checkerSet.remove(consumer);
                    flag = false;
                    break;
                }
                lastError = error;
            }
            if (flag) {
                lastError.printStackTrace();
                Assert.fail((String)("Incorrect element(" + i + "): " + actual));
            }
            ++i;
        }
    }

    private static <T> Throwable accepts(@NotNull Consumer<? super T> condition, T actual) {
        try {
            condition.consume(actual);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static <T> T assertInstanceOf(Object o, @NotNull Class<T> aClass) {
        Assert.assertNotNull((String)("Expected instance of: " + aClass.getName() + " actual: " + null), (Object)o);
        Assert.assertTrue((String)("Expected instance of: " + aClass.getName() + " actual: " + o.getClass().getName()), (boolean)aClass.isInstance(o));
        Object t = o;
        return (T)t;
    }

    public static <T> T assertOneElement(@NotNull Collection<? extends T> collection) {
        Iterator<T> iterator2 = collection.iterator();
        String toString = UsefulTestCase.toString(collection);
        Assert.assertTrue((String)toString, (boolean)iterator2.hasNext());
        T t = iterator2.next();
        Assert.assertFalse((String)toString, (boolean)iterator2.hasNext());
        return t;
    }

    public static <T> T assertOneElement(@NotNull T[] ts) {
        Assert.assertEquals((String)Arrays.asList(ts).toString(), (long)1L, (long)ts.length);
        return ts[0];
    }

    @SafeVarargs
    public static <T> void assertOneOf(T value, T ... values) {
        boolean found2 = false;
        for (T v : values) {
            if (!Objects.equals(value, v)) continue;
            found2 = true;
        }
        Assert.assertTrue((String)(value + " should be equal to one of " + Arrays.toString(values)), (boolean)found2);
    }

    public static void printThreadDump() {
        PerformanceWatcher.dumpThreadsToConsole((String)"Thread dump:");
    }

    public static void assertEmpty(@NotNull Object[] array) {
        UsefulTestCase.assertOrderedEquals(array, new Object[0]);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        UsefulTestCase.assertNotNull(collection);
        UsefulTestCase.assertFalse((boolean)collection.isEmpty());
    }

    public static void assertEmpty(@NotNull Collection<?> collection) {
        UsefulTestCase.assertEmpty(collection.toString(), collection);
    }

    public static void assertNullOrEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertEmpty("", collection);
    }

    public static void assertEmpty(String s) {
        UsefulTestCase.assertTrue((String)s, (boolean)StringUtil.isEmpty((String)s));
    }

    public static <T> void assertEmpty(@NotNull String errorMsg, @NotNull Collection<? extends T> collection) {
        UsefulTestCase.assertOrderedEquals(errorMsg, collection, Collections.emptyList());
    }

    public static void assertSize(int expectedSize, @NotNull Object[] array) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(Arrays.asList(array)), (int)expectedSize, (int)array.length);
    }

    public static void assertSize(int expectedSize, @NotNull Collection<?> c) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(c), (int)expectedSize, (int)c.size());
    }

    @NotNull
    protected <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        Disposer.register((Disposable)this.getTestRootDisposable(), disposable);
        return disposable;
    }

    public static void assertSameLines(@NotNull String expected, @NotNull String actual) {
        UsefulTestCase.assertSameLines(null, expected, actual);
    }

    public static void assertSameLines(@Nullable String message, @NotNull String expected, @NotNull String actual) {
        String expectedText = StringUtil.convertLineSeparators((String)expected.trim());
        String actualText = StringUtil.convertLineSeparators((String)actual.trim());
        Assert.assertEquals((String)message, (Object)expectedText, (Object)actualText);
    }

    public static void assertExists(@NotNull File file) {
        UsefulTestCase.assertTrue((String)("File should exist " + file), (boolean)file.exists());
    }

    public static void assertDoesntExist(@NotNull File file) {
        UsefulTestCase.assertFalse((String)("File should not exist " + file), (boolean)file.exists());
    }

    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        return UsefulTestCase.getTestName(this.getName(), lowercaseFirstLetter);
    }

    @NotNull
    public static String getTestName(@Nullable String name2, boolean lowercaseFirstLetter) {
        return name2 == null ? "" : PlatformTestUtil.getTestName(name2, lowercaseFirstLetter);
    }

    @NotNull
    protected String getTestDirectoryName() {
        String testName = this.getTestName(true);
        return testName.replaceAll("_.*", "");
    }

    public static void assertSameLinesWithFile(@NotNull String filePath2, @NotNull String actualText) {
        UsefulTestCase.assertSameLinesWithFile(filePath2, actualText, true);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath2, @NotNull String actualText, @NotNull Supplier<String> messageProducer) {
        UsefulTestCase.assertSameLinesWithFile(filePath2, actualText, true, messageProducer);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath2, @NotNull String actualText, boolean trimBeforeComparing) {
        UsefulTestCase.assertSameLinesWithFile(filePath2, actualText, trimBeforeComparing, null);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath2, @NotNull String actualText, boolean trimBeforeComparing, @Nullable Supplier<String> messageProducer) {
        String fileText;
        try {
            if (OVERWRITE_TESTDATA) {
                VfsTestUtil.overwriteTestData(filePath2, actualText);
                System.out.println("File " + filePath2 + " created.");
            }
            fileText = FileUtil.loadFile((File)new File(filePath2), (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        catch (FileNotFoundException e) {
            VfsTestUtil.overwriteTestData(filePath2, actualText);
            throw new AssertionFailedError("No output text found. File " + filePath2 + " created.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String expected = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? fileText.trim() : fileText));
        String actual = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? actualText.trim() : actualText));
        if (!Comparing.equal((String)expected, (String)actual)) {
            throw new FileComparisonFailure(messageProducer == null ? null : messageProducer.get(), expected, actual, filePath2);
        }
    }

    protected static void clearFields(@NotNull Object test) throws IllegalAccessException {
        for (Class<?> aClass = test.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields(test, aClass);
        }
    }

    public static void clearDeclaredFields(@NotNull Object test, @NotNull Class aClass) throws IllegalAccessException {
        for (Field field : aClass.getDeclaredFields()) {
            int modifiers;
            String name2 = field.getDeclaringClass().getName();
            if (name2.startsWith("junit.framework.") || name2.startsWith("com.intellij.testFramework.") || ((modifiers = field.getModifiers()) & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            field.set(test, null);
        }
    }

    private static void checkCodeStyleSettingsEqual(@NotNull CodeStyleSettings expected, @NotNull CodeStyleSettings settings) {
        if (!expected.equals((Object)settings)) {
            Element oldS = new Element("temp");
            expected.writeExternal(oldS);
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            String newString = JDOMUtil.writeElement((Element)newS);
            String oldString = JDOMUtil.writeElement((Element)oldS);
            Assert.assertEquals((String)"Code style settings damaged", (Object)oldString, (Object)newString);
        }
    }

    private static void checkCodeInsightSettingsEqual(@NotNull CodeInsightSettings oldSettings, @NotNull CodeInsightSettings settings) {
        if (!oldSettings.equals((Object)settings)) {
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            Assert.assertEquals((String)"Code insight settings damaged", (Object)DEFAULT_SETTINGS_EXTERNALIZED, (Object)JDOMUtil.writeElement((Element)newS));
        }
    }

    public boolean isPerformanceTest() {
        String testName = this.getName();
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        return TestFrameworkUtil.isPerformanceTest((String)testName, (String)className);
    }

    public boolean isStressTest() {
        return UsefulTestCase.isStressTest(this.getName(), ((Object)((Object)this)).getClass().getName());
    }

    private static boolean isStressTest(String testName, String className) {
        return TestFrameworkUtil.isPerformanceTest((String)testName, (String)className) || UsefulTestCase.containsStressWords(testName) || UsefulTestCase.containsStressWords(className);
    }

    private static boolean containsStressWords(@Nullable String name2) {
        return name2 != null && (name2.contains("Stress") || name2.contains("Slow"));
    }

    public static void doPostponedFormatting(@NotNull Project project2) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting();
        });
    }

    protected void assertException(@NotNull AbstractExceptionCase exceptionCase) {
        this.assertException(exceptionCase, null);
    }

    protected void assertException(@NotNull AbstractExceptionCase exceptionCase, @Nullable String expectedErrorMsg) {
        UsefulTestCase.assertExceptionOccurred(true, exceptionCase, expectedErrorMsg);
    }

    public static <T extends Throwable> void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<T> runnable) {
        UsefulTestCase.assertThrows(exceptionClass, null, runnable);
    }

    public static <T extends Throwable> void assertThrows(final @NotNull Class<? extends Throwable> exceptionClass, @Nullable String expectedErrorMsg, final @NotNull ThrowableRunnable<T> runnable) {
        UsefulTestCase.assertExceptionOccurred(true, new AbstractExceptionCase(){

            public Class<Throwable> getExpectedExceptionClass() {
                return exceptionClass;
            }

            @Override
            public void tryClosure() throws Throwable {
                runnable.run();
            }
        }, expectedErrorMsg);
    }

    protected <T extends Throwable> void assertNoException(@NotNull AbstractExceptionCase<T> exceptionCase) throws T {
        UsefulTestCase.assertExceptionOccurred(false, exceptionCase, null);
    }

    protected void assertNoThrowable(@NotNull Runnable closure) {
        String throwableName = null;
        try {
            closure.run();
        }
        catch (Throwable thr) {
            throwableName = thr.getClass().getName();
        }
        UsefulTestCase.assertNull(throwableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Throwable> void assertExceptionOccurred(boolean shouldOccur, @NotNull AbstractExceptionCase<T> exceptionCase, String expectedErrorMsg) throws T {
        block9: {
            boolean wasThrown = false;
            try {
                exceptionCase.tryClosure();
            }
            catch (Throwable e) {
                if (shouldOccur) {
                    wasThrown = true;
                    String errorMessage = exceptionCase.getAssertionErrorMessage();
                    UsefulTestCase.assertEquals((String)errorMessage, exceptionCase.getExpectedExceptionClass(), e.getClass());
                    if (expectedErrorMsg != null) {
                        UsefulTestCase.assertEquals((String)"Compare error messages", (String)expectedErrorMsg, (String)e.getMessage());
                    }
                    break block9;
                }
                if (exceptionCase.getExpectedExceptionClass().equals(e.getClass())) {
                    wasThrown = true;
                    System.out.println();
                    e.printStackTrace(System.out);
                    UsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + e.getMessage()));
                    break block9;
                }
                throw e;
            }
            finally {
                if (shouldOccur && !wasThrown) {
                    UsefulTestCase.fail((String)exceptionCase.getAssertionErrorMessage());
                }
            }
        }
    }

    protected boolean annotatedWith(@NotNull Class<? extends Annotation> annotationClass) {
        String methodName = "test" + this.getTestName(false);
        boolean methodChecked = false;
        for (Class<?> aClass = ((Object)((Object)this)).getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            Method method;
            if (aClass.getAnnotation(annotationClass) != null) {
                return true;
            }
            if (methodChecked || (method = ReflectionUtil.getDeclaredMethod(aClass, (String)methodName, (Class[])new Class[0])) == null) continue;
            if (method.getAnnotation(annotationClass) != null) {
                return true;
            }
            methodChecked = true;
        }
        return false;
    }

    @NotNull
    protected String getHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    public static void refreshRecursively(@NotNull VirtualFile file) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                file.getChildren();
                return true;
            }
        });
        file.refresh(false, true);
    }

    @Nullable
    public static VirtualFile refreshAndFindFile(@NotNull File file) {
        return (VirtualFile)UIUtil.invokeAndWaitIfNeeded(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file));
    }

    public static void waitForAppLeakingThreads(long timeout, @NotNull TimeUnit timeUnit) {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            Application application = ApplicationManager.getApplication();
            if (application != null && !application.isDisposed()) {
                DocumentCommitThread commitThread;
                FileBasedIndexImpl index = (FileBasedIndexImpl)FileBasedIndex.getInstance();
                if (index != null) {
                    index.waitForVfsEventsExecuted(timeout, timeUnit);
                }
                if ((commitThread = (DocumentCommitThread)ServiceManager.getService(DocumentCommitProcessor.class)) != null) {
                    commitThread.waitForAllCommits(timeout, timeUnit);
                }
            }
        }));
    }

    static {
        Class<?> aClass;
        IS_UNDER_TEAMCITY = System.getenv("TEAMCITY_VERSION") != null;
        OVERWRITE_TESTDATA = Boolean.getBoolean("idea.tests.overwrite.data");
        ORIGINAL_TEMP_DIR = FileUtil.getTempDirectory();
        TOTAL_SETUP_COST_MILLIS = new HashMap();
        TOTAL_TEARDOWN_COST_MILLIS = new HashMap();
        IdeaForkJoinWorkerThreadFactory.setupPoisonFactory();
        Logger.setFactory(TestLoggerFactory.class);
        LOG = Logger.getInstance(UsefulTestCase.class);
        CREATION_PLACE = Key.create((String)"CREATION_PLACE");
        defaultSettings = new CodeInsightSettings();
        System.setProperty("apple.awt.UIElement", "true");
        try {
            Element oldS = new Element("temp");
            defaultSettings.writeExternal(oldS);
            DEFAULT_SETTINGS_EXTERNALIZED = JDOMUtil.writeElement((Element)oldS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            aClass = Class.forName("java.io.DeleteOnExitHook");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set files = (Set)ReflectionUtil.getStaticFieldValue(aClass, Set.class, (String)"files");
        DELETE_ON_EXIT_HOOK_CLASS = aClass;
        DELETE_ON_EXIT_HOOK_DOT_FILES = files;
    }

    protected class TestDisposable
    implements Disposable {
        private volatile boolean myDisposed;

        public void dispose() {
            this.myDisposed = true;
        }

        public boolean isDisposed() {
            return this.myDisposed;
        }

        public String toString() {
            String testName = UsefulTestCase.this.getTestName(false);
            return ((Object)((Object)UsefulTestCase.this)).getClass() + (StringUtil.isEmpty((String)testName) ? "" : ".test" + testName);
        }
    }
}

