/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class VfsTestUtil {
    public static final Key<String> TEST_DATA_FILE_PATH = Key.create((String)"TEST_DATA_FILE_PATH");

    private VfsTestUtil() {
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath) {
        return VfsTestUtil.createFile(root, relativePath, "");
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath, @NotNull String text) {
        try {
            return VfsTestUtil.createFileOrDir(root, relativePath, VfsUtil.toByteArray((VirtualFile)root, (String)text), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath, @NotNull byte[] data) {
        return VfsTestUtil.createFileOrDir(root, relativePath, data, false);
    }

    @NotNull
    public static VirtualFile createDir(@NotNull VirtualFile root, @NotNull String relativePath) {
        return VfsTestUtil.createFileOrDir(root, relativePath, ArrayUtilRt.EMPTY_BYTE_ARRAY, true);
    }

    @NotNull
    private static VirtualFile createFileOrDir(VirtualFile root, String relativePath, @NotNull byte[] data, boolean dir) {
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> {
                VirtualFile file;
                VirtualFile parent = root;
                for (String name2 : StringUtil.tokenize((String)PathUtil.getParentPath((String)relativePath), (String)"/")) {
                    VirtualFile child = parent.findChild(name2);
                    if (child == null || !child.isValid()) {
                        child = parent.createChildDirectory(VfsTestUtil.class, name2);
                    }
                    parent = child;
                }
                parent.getChildren();
                String name3 = PathUtil.getFileName((String)relativePath);
                if (dir) {
                    file = parent.createChildDirectory(VfsTestUtil.class, name3);
                } else {
                    file = parent.findChild(name3);
                    if (file == null) {
                        file = parent.createChildData(VfsTestUtil.class, name3);
                    }
                    file.setBinaryContent(data);
                    FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{file});
                }
                return file;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteFile(@NotNull VirtualFile file) {
        try {
            WriteAction.runAndWait(() -> file.delete(null));
        }
        catch (Throwable throwable) {
            ExceptionUtilRt.rethrow((Throwable)throwable);
        }
    }

    public static void clearContent(@NotNull VirtualFile file) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                VfsUtil.saveText((VirtualFile)file, (String)"");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void overwriteTestData(@NotNull String filePath2, @NotNull String actual) {
        try {
            FileUtil.writeToFile((File)new File(filePath2), (String)actual);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static VirtualFile findFileByCaseSensitivePath(@NotNull String absolutePath) {
        String vfsPath = FileUtil.toSystemIndependentName((String)absolutePath);
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(vfsPath);
        Assert.assertNotNull((String)("file " + absolutePath + " not found"), (Object)vFile);
        String realVfsPath = vFile.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !vfsPath.equals(realVfsPath) && vfsPath.equalsIgnoreCase(realVfsPath)) {
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + vfsPath + "\nreal path " + realVfsPath));
        }
        return vFile;
    }

    public static void assertFilePathEndsWithCaseSensitivePath(@NotNull VirtualFile file, @NotNull String suffixPath) {
        String vfsSuffixPath = FileUtil.toSystemIndependentName((String)suffixPath);
        String vfsPath = file.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !vfsPath.endsWith(vfsSuffixPath) && StringUtil.endsWithIgnoreCase((String)vfsPath, (String)vfsSuffixPath)) {
            String realSuffixPath = vfsPath.substring(vfsPath.length() - vfsSuffixPath.length());
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + suffixPath + "\nreal path " + realSuffixPath));
        }
    }

    @NotNull
    public static List<VFileEvent> getEvents(@NotNull Runnable action) {
        final ArrayList<VFileEvent> allEvents = new ArrayList<VFileEvent>();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                allEvents.addAll(events);
            }
        });
        try {
            action.run();
        }
        finally {
            connection.disconnect();
        }
        return allEvents;
    }

    @NotNull
    public static List<String> print(@NotNull List<? extends VFileEvent> events) {
        return ContainerUtil.map(events, VfsTestUtil::print);
    }

    private static String print(VFileEvent e) {
        int type = 63;
        if (e instanceof VFileCreateEvent) {
            type = 67;
        } else if (e instanceof VFileDeleteEvent) {
            type = 68;
        } else if (e instanceof VFileContentChangeEvent) {
            type = 85;
        } else if (e instanceof VFilePropertyChangeEvent) {
            type = 80;
        }
        return (char)type + " : " + e.getPath();
    }
}

