/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.codeInsight.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.util.JDOMUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchyViewTestFixture {
    private static final String NODE_ELEMENT_NAME = "node";
    private static final String ANY_NODES_ELEMENT_NAME = "any";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String BASE_ATTR_NAME = "base";

    public void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @NotNull String expectedStructure) {
        try {
            HierarchyViewTestFixture.checkHierarchyTreeStructure(treeStructure, JDOMUtil.load((CharSequence)expectedStructure));
        }
        catch (Throwable e) {
            TestCase.assertEquals((String)"XML structure comparison for your convenience, actual failure details BELOW", (String)expectedStructure, (String)HierarchyViewTestFixture.dump(treeStructure, null, 0));
            e.printStackTrace();
        }
    }

    @NotNull
    public static String dump(@NotNull HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor2, int level) {
        StringBuilder s = new StringBuilder();
        HierarchyViewTestFixture.dump(treeStructure, descriptor2, level, s);
        return s.toString();
    }

    private static void dump(@NotNull HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor2, int level, @NotNull StringBuilder b) {
        if (level > 10) {
            for (int i = 0; i < level; ++i) {
                b.append("  ");
            }
            b.append("<Probably infinite part skipped>\n");
            return;
        }
        if (descriptor2 == null) {
            descriptor2 = (HierarchyNodeDescriptor)treeStructure.getRootElement();
        }
        for (int i = 0; i < level; ++i) {
            b.append("  ");
        }
        descriptor2.update();
        b.append("<node text=\"").append(descriptor2.getHighlightedText().getText()).append("\"").append(treeStructure.getBaseDescriptor() == descriptor2 ? " base=\"true\"" : "");
        Object[] children = treeStructure.getChildElements((Object)descriptor2);
        if (children.length > 0) {
            b.append(">\n");
            for (Object o : children) {
                HierarchyNodeDescriptor d = (HierarchyNodeDescriptor)o;
                HierarchyViewTestFixture.dump(treeStructure, d, level + 1, b);
            }
            for (int i = 0; i < level; ++i) {
                b.append("  ");
            }
            b.append("</node>\n");
        } else {
            b.append("/>\n");
        }
    }

    private static void checkHierarchyTreeStructure(@NotNull HierarchyTreeStructure treeStructure, @Nullable Element rootElement) {
        HierarchyNodeDescriptor rootNodeDescriptor = (HierarchyNodeDescriptor)treeStructure.getRootElement();
        rootNodeDescriptor.update();
        if (rootElement == null || !NODE_ELEMENT_NAME.equals(rootElement.getName())) {
            throw new IllegalArgumentException("Incorrect root element in verification resource");
        }
        HierarchyViewTestFixture.checkNodeDescriptorRecursively(treeStructure, rootNodeDescriptor, rootElement);
    }

    private static void checkNodeDescriptorRecursively(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element expectedElement) {
        HierarchyViewTestFixture.checkBaseNode(treeStructure, descriptor2, expectedElement);
        HierarchyViewTestFixture.checkContent(descriptor2, expectedElement);
        HierarchyViewTestFixture.checkChildren(treeStructure, descriptor2, expectedElement);
    }

    private static void checkBaseNode(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element expectedElement) {
        String baseAttrValue = expectedElement.getAttributeValue(BASE_ATTR_NAME);
        HierarchyNodeDescriptor baseDescriptor = treeStructure.getBaseDescriptor();
        boolean mustBeBase = "true".equalsIgnoreCase(baseAttrValue);
        TestCase.assertTrue((String)"Incorrect base node", (boolean)(mustBeBase ? baseDescriptor == descriptor2 : baseDescriptor != descriptor2));
    }

    private static void checkContent(@NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element expectedElement) {
        TestCase.assertEquals((String)expectedElement.getAttributeValue(TEXT_ATTR_NAME), (String)descriptor2.getHighlightedText().getText());
    }

    private static void checkChildren(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor2, @NotNull Element element) {
        if (element.getChild(ANY_NODES_ELEMENT_NAME) != null) {
            return;
        }
        Object[] children = treeStructure.getChildElements((Object)descriptor2);
        ArrayList expectedChildren = new ArrayList(element.getChildren(NODE_ELEMENT_NAME));
        StringBuilder messageBuilder = new StringBuilder("Actual children of [" + descriptor2.getHighlightedText().getText() + "]:\n");
        for (Object child2 : children) {
            HierarchyNodeDescriptor nodeDescriptor = (HierarchyNodeDescriptor)child2;
            nodeDescriptor.update();
            messageBuilder.append("    [").append(nodeDescriptor.getHighlightedText().getText()).append("]\n");
        }
        TestCase.assertEquals((String)messageBuilder.toString(), (int)expectedChildren.size(), (int)children.length);
        Arrays.sort(children, Comparator.comparing(child -> ((HierarchyNodeDescriptor)child).getHighlightedText().getText()));
        Collections.sort(expectedChildren, Comparator.comparing(child -> child.getAttributeValue(TEXT_ATTR_NAME)));
        Iterator iterator2 = expectedChildren.iterator();
        for (Object child3 : children) {
            HierarchyViewTestFixture.checkNodeDescriptorRecursively(treeStructure, (HierarchyNodeDescriptor)child3, (Element)iterator2.next());
        }
    }
}

