/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.SkipInHeadlessEnvironment;
import com.intellij.testFramework.SkipSlowTestLocally;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.fixtures.BareTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

public abstract class BareTestFixtureTestCase
extends Assert {
    public static final Logger LOG = Logger.getInstance(BareTestFixtureTestCase.class);
    @Rule
    public final TestName myNameRule = new TestName();
    private BareTestFixture myFixture;
    @Rule
    public TestRule testLoggerWatcher = TestLoggerFactory.createTestWatcher();

    @Before
    public final void setupFixture() throws Exception {
        ApplicationInfoImpl.setInStressTest((boolean)TestFrameworkUtil.isPerformanceTest(null, (String)((Object)((Object)this)).getClass().getName()));
        boolean headless = TestFrameworkUtil.SKIP_HEADLESS && ((Object)((Object)this)).getClass().getAnnotation(SkipInHeadlessEnvironment.class) != null;
        Assume.assumeFalse((String)("Class '" + ((Object)((Object)this)).getClass().getName() + "' is skipped because it requires working UI environment"), (boolean)headless);
        boolean slow = TestFrameworkUtil.SKIP_SLOW && ((Object)((Object)this)).getClass().getAnnotation(SkipSlowTestLocally.class) != null;
        Assume.assumeFalse((String)("Class '" + ((Object)((Object)this)).getClass().getName() + "' is skipped because it is dog slow"), (boolean)slow);
        this.myFixture = IdeaTestFixtureFactory.getFixtureFactory().createBareFixture();
        this.myFixture.setUp();
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> ApplicationInfoImpl.setInStressTest((boolean)false));
    }

    @After
    public final void tearDownFixture() throws Exception {
        if (this.myFixture != null) {
            this.myFixture.tearDown();
            this.myFixture = null;
        }
    }

    @NotNull
    protected final String getTestName(boolean lowercaseFirstLetter) {
        return PlatformTestUtil.getTestName(this.myNameRule.getMethodName(), lowercaseFirstLetter);
    }

    @NotNull
    public final Disposable getTestRootDisposable() {
        return this.myFixture.getTestRootDisposable();
    }
}

