/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.navigation.GotoImplementationHandler;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.actions.ListTemplatesAction;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBListUpdater;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CodeInsightTestUtil {
    private CodeInsightTestUtil() {
    }

    @Nullable
    public static IntentionAction findIntentionByText(@NotNull List<? extends IntentionAction> actions, @NonNls @NotNull String text) {
        for (IntentionAction intentionAction : actions) {
            String s = intentionAction.getText();
            if (!s.equals(text)) continue;
            return intentionAction;
        }
        return null;
    }

    @Nullable
    public static IntentionAction findIntentionByPartialText(@NotNull List<? extends IntentionAction> actions, @NonNls @NotNull String text) {
        for (IntentionAction intentionAction : actions) {
            String s = intentionAction.getText();
            if (!s.contains(text)) continue;
            return intentionAction;
        }
        return null;
    }

    public static void doIntentionTest(CodeInsightTestFixture fixture, @NonNls String file, @NonNls String actionText) {
        String extension = FileUtilRt.getExtension((String)file);
        file = FileUtil.getNameWithoutExtension((String)file);
        if (extension.isEmpty()) {
            extension = "xml";
        }
        CodeInsightTestUtil.doIntentionTest(fixture, actionText, file + "." + extension, file + "_after." + extension);
    }

    public static void doIntentionTest(@NotNull CodeInsightTestFixture fixture, @NonNls String action, @NotNull String before, @NotNull String after2) {
        fixture.configureByFile(before);
        List<IntentionAction> availableIntentions = fixture.getAvailableIntentions();
        IntentionAction intentionAction = CodeInsightTestUtil.findIntentionByText(availableIntentions, action);
        if (intentionAction == null) {
            PsiElement element = fixture.getFile().findElementAt(fixture.getCaretOffset());
            Assert.fail((String)("Action not found: " + action + " in place: " + element + " among " + availableIntentions));
        }
        fixture.launchAction(intentionAction);
        fixture.checkResultByFile(after2, false);
    }

    public static void doWordSelectionTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, String ... after2) {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            assert (after2 != null && after2.length > 0);
            fixture.configureByFile(before);
            for (String file : after2) {
                fixture.performEditorAction("EditorSelectWord");
                fixture.checkResultByFile(file, false);
            }
        }));
    }

    public static void doWordSelectionTestOnDirectory(@NotNull CodeInsightTestFixture fixture, @NotNull String directoryName, @NotNull String filesExtension) {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            fixture.copyDirectoryToProject(directoryName, directoryName);
            fixture.configureByFile(directoryName + "/before." + filesExtension);
            int i = 1;
            while (true) {
                String fileName = directoryName + "/after" + i + "." + filesExtension;
                if (!new File(fixture.getTestDataPath() + "/" + fileName).exists()) break;
                fixture.performEditorAction("EditorSelectWord");
                fixture.checkResultByFile(fileName);
                ++i;
            }
            junit.framework.Assert.assertTrue((String)"At least one 'after'-file required", (i > 1 ? 1 : 0) != 0);
        }));
    }

    public static void doSurroundWithTest(@NotNull CodeInsightTestFixture fixture, @NotNull Surrounder surrounder, @NotNull String before, @NotNull String after2) {
        fixture.configureByFile(before);
        WriteCommandAction.writeCommandAction((Project)fixture.getProject()).run(() -> SurroundWithHandler.invoke((Project)fixture.getProject(), (Editor)fixture.getEditor(), (PsiFile)fixture.getFile(), (Surrounder)surrounder));
        fixture.checkResultByFile(after2, false);
    }

    public static void doLiveTemplateTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        fixture.configureByFile(before);
        new ListTemplatesAction().actionPerformedImpl(fixture.getProject(), fixture.getEditor());
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)fixture.getEditor());
        assert (lookup != null);
        lookup.finishLookup('\n');
        fixture.checkResultByFile(after2, false);
    }

    public static void doSmartEnterTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        fixture.configureByFile(before);
        List processors = SmartEnterProcessors.INSTANCE.allForLanguage(fixture.getFile().getLanguage());
        WriteCommandAction.writeCommandAction((Project)fixture.getProject()).run(() -> {
            Editor editor = fixture.getEditor();
            for (SmartEnterProcessor processor2 : processors) {
                processor2.process(fixture.getProject(), editor, fixture.getFile());
            }
        });
        fixture.checkResultByFile(after2, false);
    }

    public static void doFormattingTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        fixture.configureByFile(before);
        WriteCommandAction.writeCommandAction((Project)fixture.getProject()).run(() -> CodeStyleManager.getInstance((Project)fixture.getProject()).reformat((PsiElement)fixture.getFile()));
        fixture.checkResultByFile(after2, false);
    }

    public static void doInlineRename(VariableInplaceRenameHandler handler, String newName, CodeInsightTestFixture fixture) {
        CodeInsightTestUtil.doInlineRename(handler, newName, fixture.getEditor(), fixture.getElementAtCaret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInlineRename(VariableInplaceRenameHandler handler, String newName, @NotNull Editor editor, PsiElement elementAtCaret) {
        Project project2 = editor.getProject();
        Disposable disposable = Disposer.newDisposable();
        try {
            TemplateManagerImpl.setTemplateTesting((Disposable)disposable);
            handler.doRename(elementAtCaret, editor, DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            TemplateState state = TemplateManagerImpl.getTemplateState((Editor)editor);
            assert (state != null);
            TextRange range = state.getCurrentVariableRange();
            assert (range != null);
            Editor finalEditor = editor;
            WriteCommandAction.writeCommandAction((Project)project2).run(() -> finalEditor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newName));
            state = TemplateManagerImpl.getTemplateState((Editor)editor);
            assert (state != null);
            state.gotoEnd(false);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    public static void doInlineRenameTest(VariableInplaceRenameHandler handler, String file, String extension, String newName, CodeInsightTestFixture fixture) {
        fixture.configureByFile(file + "." + extension);
        CodeInsightTestUtil.doInlineRename(handler, newName, fixture);
        fixture.checkResultByFile(file + "_after." + extension);
    }

    public static void doActionTest(AnAction action, String file, CodeInsightTestFixture fixture) {
        String extension = FileUtilRt.getExtension((String)file);
        String name2 = FileUtil.getNameWithoutExtension((String)file);
        fixture.configureByFile(file);
        fixture.testAction(action);
        fixture.checkResultByFile(name2 + "_after." + extension);
    }

    public static void addTemplate(final Template template, Disposable parentDisposable) {
        final TemplateSettings settings = TemplateSettings.getInstance();
        settings.addTemplate(template);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                settings.removeTemplate(template);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static GotoTargetHandler.GotoData gotoImplementation(Editor editor, PsiFile file) {
        GotoTargetHandler.GotoData data = new GotoImplementationHandler().getSourceAndTargetElements(editor, file);
        if (data.listUpdaterTask != null) {
            JBList list = new JBList();
            CollectionListModel model = new CollectionListModel(new ArrayList());
            list.setModel((ListModel)new NameFilteringListModel((ListModel)model, Function.ID, Condition.FALSE, String::new));
            JBPopup popup = new ComponentPopupBuilderImpl((JComponent)list, null).createPopup();
            data.listUpdaterTask.init(popup, (ListComponentUpdater)new JBListUpdater(list), new Ref());
            data.listUpdaterTask.queue();
            try {
                while (!data.listUpdaterTask.isFinished()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
            }
            finally {
                Disposer.dispose((Disposable)popup);
            }
        }
        return data;
    }
}

