/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.ide.IdeView;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

class HeavyIdeaTestFixtureImpl
extends BaseFixture
implements HeavyIdeaTestFixture {
    private Project myProject;
    private final Set<File> myFilesToDelete = new HashSet<File>();
    private IdeaTestApplication myApplication;
    private final Set<ModuleFixtureBuilder> myModuleFixtureBuilders = new LinkedHashSet<ModuleFixtureBuilder>();
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private final String myName;
    private final boolean myIsDirectoryBasedProject;
    private SdkLeakTracker myOldSdks;

    HeavyIdeaTestFixtureImpl(@NotNull String name2, boolean isDirectoryBasedProject) {
        this.myName = name2;
        this.myIsDirectoryBasedProject = isDirectoryBasedProject;
    }

    void addModuleFixtureBuilder(ModuleFixtureBuilder builder) {
        this.myModuleFixtureBuilders.add(builder);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        this.setUpProject();
        EncodingManager.getInstance();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
        this.myOldSdks = new SdkLeakTracker();
    }

    @Override
    public void tearDown() throws Exception {
        RunAll runAll = new RunAll(new ThrowableRunnable[0]);
        if (this.myProject != null) {
            runAll = runAll.append(() -> LightPlatformTestCase.doTearDown(this.getProject(), this.myApplication)).append(() -> {
                for (ModuleFixtureBuilder moduleFixtureBuilder : this.myModuleFixtureBuilders) {
                    moduleFixtureBuilder.getFixture().tearDown();
                }
            }).append(() -> EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> PlatformTestCase.closeAndDisposeProjectAndCheckThatNoOpenProjects(this.getProject())))).append(() -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)this.getProject())).append(() -> {
                this.myProject = null;
            });
        }
        JarFileSystemImpl.cleanupForNextTest();
        for (File fileToDelete : this.myFilesToDelete) {
            runAll = runAll.append(() -> {
                List errors = Files.walk(fileToDelete.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(x -> {
                    try {
                        Files.delete(x);
                        return null;
                    }
                    catch (IOException e) {
                        return e;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                CompoundRuntimeException.throwIfNotEmpty(errors);
            });
        }
        runAll.append(() -> super.tearDown()).append(() -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        }).append(() -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }).append(LightPlatformTestCase::checkEditorsReleased).append(() -> {
            if (this.myOldSdks != null) {
                this.myOldSdks.checkForJdkTableLeaks();
            }
        }).append(() -> PlatformTestCase.cleanupApplicationCaches(null)).run();
    }

    private void setUpProject() throws IOException {
        File tempDirectory = FileUtil.createTempDirectory((String)this.myName, (String)"");
        PlatformTestCase.synchronizeTempDirVfs((VirtualFile)ObjectUtils.assertNotNull((Object)LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory)));
        this.myFilesToDelete.add(tempDirectory);
        String projectPath = this.generateProjectPath(tempDirectory);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new Throwable(projectPath).printStackTrace(new PrintStream(buffer));
        this.myProject = PlatformTestCase.createProject(projectPath, buffer.toString());
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            ProjectManagerEx.getInstanceEx().openTestProject(this.myProject);
            for (ModuleFixtureBuilder moduleFixtureBuilder : this.myModuleFixtureBuilders) {
                moduleFixtureBuilder.getFixture().setUp();
            }
            LightPlatformTestCase.clearUncommittedDocuments(this.myProject);
            ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        }));
    }

    @NotNull
    protected String generateProjectPath(@NotNull File tempDirectory) {
        String suffix = this.myIsDirectoryBasedProject ? "" : ".ipr";
        return FileUtil.toSystemIndependentName((String)tempDirectory.getPath()) + "/" + this.myName + suffix;
    }

    private void initApplication() {
        this.myApplication = IdeaTestApplication.getInstance();
        this.myApplication.setDataProvider(new MyDataProvider());
    }

    @Override
    public Project getProject() {
        Assert.assertNotNull((String)"setUp() should be called first", (Object)this.myProject);
        return this.myProject;
    }

    @Override
    public Module getModule() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        return modules.length == 0 ? null : modules[0];
    }

    @Override
    public PsiFile addFileToProject(@NotNull @NonNls String rootPath, @NotNull @NonNls String relativePath, @NotNull @NonNls String fileText) throws IOException {
        VirtualFile dir = VfsUtil.createDirectories((String)(rootPath + "/" + PathUtil.getParentPath((String)relativePath)));
        VirtualFile[] virtualFile = new VirtualFile[1];
        WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
            virtualFile[0] = dir.createChildData((Object)this, StringUtil.getShortName((String)relativePath, (char)'/'));
            VfsUtil.saveText((VirtualFile)virtualFile[0], (String)fileText);
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        });
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile[0]));
    }

    private class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            VirtualFile[] contentRoots;
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return HeavyIdeaTestFixtureImpl.this.myProject;
            }
            if (CommonDataKeys.EDITOR.is(dataId) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                if (HeavyIdeaTestFixtureImpl.this.myProject == null) {
                    return null;
                }
                return FileEditorManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).getSelectedTextEditor();
            }
            Editor editor = (Editor)this.getData(CommonDataKeys.EDITOR.getName());
            if (editor != null) {
                FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)HeavyIdeaTestFixtureImpl.this.myProject);
                return manager.getData(dataId, editor, editor.getCaretModel().getCurrentCaret());
            }
            if (LangDataKeys.IDE_VIEW.is(dataId) && (contentRoots = ProjectRootManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).getContentRoots()).length > 0) {
                final PsiDirectory psiDirectory = PsiManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).findDirectory(contentRoots[0]);
                return new IdeView(){

                    @NotNull
                    public PsiDirectory[] getDirectories() {
                        return new PsiDirectory[]{psiDirectory};
                    }

                    public PsiDirectory getOrChooseDirectory() {
                        return psiDirectory;
                    }
                };
            }
            return null;
        }
    }
}

