/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class LightTempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private final VirtualFile mySourceRoot;
    private final boolean myUsePlatformSourceRoot;

    public LightTempDirTestFixtureImpl() {
        VirtualFile fsRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
        Assert.assertNotNull((Object)fsRoot);
        try {
            this.mySourceRoot = (VirtualFile)WriteAction.computeAndWait(() -> fsRoot.createChildDirectory((Object)this, "root"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.myUsePlatformSourceRoot = false;
    }

    public LightTempDirTestFixtureImpl(boolean usePlatformSourceRoot) {
        this.myUsePlatformSourceRoot = usePlatformSourceRoot;
        this.mySourceRoot = null;
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.deleteAll();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String path) {
        return (VirtualFile)WriteAction.computeAndWait(() -> {
            try {
                return this.findOrCreateChildDir(this.getSourceRoot(), path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        return this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String dataDir, final @NotNull String targetDir, final @NotNull VirtualFileFilter filter) {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                Assert.assertNotNull((String)("Cannot find testdata directory " + dataDir), (Object)from);
                try {
                    UsefulTestCase.refreshRecursively(from);
                    VirtualFile tempDir = LightTempDirTestFixtureImpl.this.getSourceRoot();
                    if (targetDir.length() > 0) {
                        tempDir = LightTempDirTestFixtureImpl.this.findOrCreateChildDir(tempDir, targetDir);
                    }
                    VfsUtil.copyDirectory((Object)this, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                    return tempDir;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private VirtualFile findOrCreateChildDir(VirtualFile root, String relativePath) throws IOException {
        if (relativePath.length() == 0) {
            return root;
        }
        String trimPath = StringUtil.trimStart((String)relativePath, (String)"/");
        List dirs = StringUtil.split((String)trimPath, (String)"/");
        for (String dirName : dirs) {
            if (dirName.equals(".")) continue;
            if (dirName.equals("..")) {
                if ((root = root.getParent()) != null) continue;
                throw new IllegalArgumentException("Invalid path: " + relativePath);
            }
            VirtualFile dir = root.findChild(dirName);
            if (dir != null) {
                root = dir;
                continue;
            }
            try {
                root = root.createChildDirectory((Object)this, dirName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return root;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        return "temp:///root";
    }

    @Override
    public VirtualFile getFile(@NotNull String path) {
        VirtualFile sourceRoot = this.getSourceRoot();
        VirtualFile result = sourceRoot.findFileByRelativePath(path);
        if (result == null) {
            sourceRoot.refresh(false, true);
            result = sourceRoot.findFileByRelativePath(path);
        }
        return result;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String targetPath) {
        String path = PathUtil.getParentPath((String)targetPath);
        String name2 = PathUtil.getFileName((String)targetPath);
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> {
                VirtualFile targetDir = this.findOrCreateDir(path);
                return targetDir.createChildData((Object)this, name2);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name2, @NotNull String text) throws IOException {
        VirtualFile file = this.createFile(name2);
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file, (String)text));
        return file;
    }

    public void deleteAll() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                VirtualFile[] toDelete = LightTempDirTestFixtureImpl.this.myUsePlatformSourceRoot ? LightTempDirTestFixtureImpl.this.getSourceRoot().getChildren() : new VirtualFile[]{LightTempDirTestFixtureImpl.this.mySourceRoot};
                for (VirtualFile file : toDelete) {
                    try {
                        file.delete((Object)this);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @NotNull
    private VirtualFile getSourceRoot() {
        if (this.myUsePlatformSourceRoot) {
            return LightPlatformTestCase.getSourceRoot();
        }
        return this.mySourceRoot;
    }
}

