/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class TempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private File myTempDir;

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        return this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String dataDir, final @NotNull String targetDir, final @NotNull VirtualFileFilter filter) {
        this.createTempDirectory();
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(TempDirTestFixtureImpl.this.myTempDir.getCanonicalPath().replace(File.separatorChar, '/'));
                    Assert.assertNotNull((Object)tempDir);
                    if (targetDir.length() > 0) {
                        Assert.assertFalse((String)"nested directories not implemented", (boolean)targetDir.contains("/"));
                        VirtualFile child = tempDir.findChild(targetDir);
                        if (child == null) {
                            child = tempDir.createChildDirectory((Object)this, targetDir);
                        }
                        tempDir = child;
                    }
                    VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                    Assert.assertNotNull((String)(dataDir + " not found"), (Object)from);
                    VfsUtil.copyDirectory(null, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                    return tempDir;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        return this.createTempDirectory().getAbsolutePath();
    }

    public File createTempFile(String fileName) throws IOException {
        String prefix = StringUtil.getPackageName((String)fileName);
        if (prefix.length() < 3) {
            prefix = prefix + "___";
        }
        String suffix = "." + StringUtil.getShortName((String)fileName);
        File file = FileUtil.createTempFile((File)new File(this.getTempDirPath()), (String)prefix, (String)suffix, (boolean)true);
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{file.getPath()});
        return file;
    }

    @Override
    public VirtualFile getFile(@NotNull String path) {
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> {
                String fullPath = this.myTempDir.getCanonicalPath() + '/' + path;
                VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{fullPath});
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
                return file;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name2) {
        File file = new File(this.createTempDirectory(), name2);
        return (VirtualFile)WriteAction.computeAndWait(() -> {
            FileUtil.createIfDoesntExist((File)file);
            VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{file.getPath()});
            return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        });
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String name2) throws IOException {
        File file = new File(this.createTempDirectory(), name2);
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{file.getPath()});
        return VfsUtil.createDirectories((String)file.getPath());
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name2, @NotNull String text) throws IOException {
        VirtualFile file = this.createFile(name2);
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file, (String)text));
        return file;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createTempDirectory();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            if (this.myTempDir != null) {
                WriteAction.runAndWait(() -> this.findOrCreateDir("").delete((Object)this));
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected File getTempHome() {
        return null;
    }

    @NotNull
    protected File createTempDirectory() {
        try {
            if (this.myTempDir == null) {
                File tempHome = this.getTempHome();
                this.myTempDir = tempHome == null ? FileUtil.createTempDirectory((String)"unitTest", null, (boolean)false) : FileUtil.createTempDirectory((File)tempHome, (String)"unitTest", null, (boolean)false);
            }
            return this.myTempDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create temp dir", e);
        }
    }
}

