/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.propertyBased.MadTestingAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;

public abstract class ActionOnFile
implements MadTestingAction {
    private final Project myProject;
    private final VirtualFile myVirtualFile;

    protected ActionOnFile(@NotNull PsiFile file) {
        this.myProject = file.getProject();
        this.myVirtualFile = file.getVirtualFile();
    }

    @NotNull
    protected PsiFile getFile() {
        return PsiManager.getInstance((Project)this.getProject()).findFile(this.getVirtualFile());
    }

    @NotNull
    protected Project getProject() {
        return this.myProject;
    }

    @NotNull
    protected VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @NotNull
    protected Document getDocument() {
        return FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
    }

    protected int generatePsiOffset(@NotNull ImperativeCommand.Environment env, @Nullable String logMessage) {
        return (Integer)env.generateValue(Generator.integers((int)0, (int)this.getFile().getTextLength()).noShrink(), logMessage);
    }

    protected int generateDocOffset(@NotNull ImperativeCommand.Environment env, @Nullable String logMessage) {
        return (Integer)env.generateValue(Generator.integers((int)0, (int)this.getDocument().getTextLength()).noShrink(), logMessage);
    }
}

