/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LexerTestCase;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.DeleteRange;
import com.intellij.testFramework.propertyBased.InsertString;
import com.intellij.testFramework.propertyBased.MadTestingAction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;
import org.junit.Assert;

public class CheckHighlighterConsistency
extends ActionOnFile {
    @NotNull
    public static final Function<PsiFile, Generator<? extends MadTestingAction>> randomEditsWithHighlighterChecks = file -> {
        FileEditorManager.getInstance((Project)file.getProject()).openFile(file.getVirtualFile(), true);
        return Generator.sampledFrom((Object[])new ActionOnFile[]{new CheckHighlighterConsistency((PsiFile)file), new InsertString((PsiFile)file), new DeleteRange((PsiFile)file)});
    };

    public CheckHighlighterConsistency(@NotNull PsiFile file) {
        super(file);
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        env.logMessage(this.toString());
        Editor editor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedTextEditor();
        assert (editor.getDocument() == this.getDocument());
        CheckHighlighterConsistency.performCheck(editor);
    }

    public static void performCheck(@NotNull Editor editor) {
        LexerEditorHighlighter highlighter = (LexerEditorHighlighter)((EditorEx)editor).getHighlighter();
        CharSequence text = editor.getDocument().getImmutableCharSequence();
        String incremental = CheckHighlighterConsistency.dumpHighlighterTokens(highlighter, text);
        highlighter.setText((CharSequence)"");
        highlighter.setText(text);
        String full = CheckHighlighterConsistency.dumpHighlighterTokens(highlighter, text);
        if (!full.equals(incremental)) {
            Assert.assertEquals((Object)("Full lexer highlighter:\n" + full), (Object)("Incremental lexer highlighter:\n" + incremental));
        }
    }

    @NotNull
    private static String dumpHighlighterTokens(LexerEditorHighlighter highlighter, CharSequence text) {
        StringBuilder tokens = new StringBuilder();
        HighlighterIterator iterator2 = highlighter.createIterator(0);
        while (!iterator2.atEnd()) {
            tokens.append(iterator2.getStart()).append(" ").append(LexerTestCase.printSingleToken(text, iterator2.getTokenType(), iterator2.getStart(), iterator2.getEnd()));
            iterator2.advance();
        }
        return tokens.toString();
    }
}

