/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.paths.WebReference;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.propertyBased.MadTestingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionPolicy {
    public String getPossibleSelectionCharacters() {
        return "\n\t\r .(";
    }

    @Nullable
    protected String getExpectedVariant(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement leaf, @Nullable PsiReference ref) {
        String leafText;
        if (this.isAfterError(file, leaf)) {
            return null;
        }
        String string = leafText = ref != null ? ref.getRangeInElement().substring(ref.getElement().getText()) : leaf.getText();
        if (leafText.isEmpty() || !Character.isLetter(leafText.charAt(0)) || leaf instanceof PsiWhiteSpace || PsiTreeUtil.getNonStrictParentOfType((PsiElement)leaf, (Class[])new Class[]{PsiComment.class}) != null) {
            return null;
        }
        if (leafText.length() == 1 && "org.intellij.lang.regexp.RegExpElementType".equals(PsiUtilCore.getElementType((PsiElement)leaf).getClass().getName())) {
            return null;
        }
        if (CompletionPolicy.isDeclarationName(editor, file, leaf, ref)) {
            return null;
        }
        if (ref != null) {
            PsiElement target = CompletionPolicy.getValidResolveResult(ref);
            if (target == null || !this.shouldSuggestReferenceText(ref, target)) {
                return null;
            }
            if (ref instanceof PsiMultiReference) {
                for (PsiReference ref1 : ((PsiMultiReference)ref).getReferences()) {
                    if (!target.getClass().isInstance(ref1.resolve()) || this.shouldSuggestReferenceText(ref1, target)) continue;
                    return null;
                }
            }
        } else {
            if (!SyntaxTraverser.psiTraverser((PsiElement)file).filter(PsiErrorElement.class).isEmpty()) {
                return null;
            }
            if (!this.shouldSuggestNonReferenceLeafText(leaf)) {
                return null;
            }
        }
        return leafText;
    }

    protected boolean isAfterError(@NotNull PsiFile file, @NotNull PsiElement leaf) {
        return MadTestingUtil.isAfterError(file, leaf.getTextRange().getStartOffset());
    }

    public boolean shouldCheckDuplicates(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement leaf) {
        return leaf != null && !this.isAfterError(file, leaf);
    }

    private static PsiElement getValidResolveResult(@NotNull PsiReference ref) {
        if (ref instanceof PsiPolyVariantReference) {
            for (ResolveResult result : ((PsiPolyVariantReference)ref).multiResolve(false)) {
                if (result.isValidResult()) continue;
                return null;
            }
        }
        return ref.resolve();
    }

    private static boolean isDeclarationName(Editor editor, PsiFile file, PsiElement leaf, @Nullable PsiReference ref) {
        PsiElement nameIdentifier;
        PsiFile targetFile;
        PsiElement target = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
        if (target != null) {
            target = target.getNavigationElement();
        }
        PsiFile psiFile = targetFile = target != null ? target.getContainingFile() : null;
        if (targetFile == null || targetFile.getViewProvider() != file.getViewProvider()) {
            return false;
        }
        if (target.getTextOffset() == leaf.getTextRange().getStartOffset() || ref != null && target.getTextOffset() == ref.getElement().getTextRange().getStartOffset() + ref.getRangeInElement().getStartOffset()) {
            return true;
        }
        return target instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)target).getNameIdentifier()) != null && PsiTreeUtil.isAncestor((PsiElement)nameIdentifier, (PsiElement)leaf, (boolean)false);
    }

    protected boolean shouldSuggestNonReferenceLeafText(@NotNull PsiElement leaf) {
        return true;
    }

    protected boolean shouldSuggestReferenceText(@NotNull PsiReference ref, @NotNull PsiElement target) {
        return !(ref instanceof WebReference);
    }
}

