/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.fixtures.TestLookupElementPresentation;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.CompletionPolicy;
import com.intellij.testFramework.propertyBased.InvokeIntention;
import com.intellij.testFramework.propertyBased.MadTestingUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;

public class InvokeCompletion
extends ActionOnFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.propertyBased.InvokeCompletion");
    private final CompletionPolicy myPolicy;

    public InvokeCompletion(@NotNull PsiFile file, @NotNull CompletionPolicy policy) {
        super(file);
        this.myPolicy = policy;
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        int offset = this.generateDocOffset(env, "Invoke basic completion at offset %s");
        String selectionCharacters = this.myPolicy.getPossibleSelectionCharacters();
        char c = selectionCharacters.charAt((Integer)env.generateValue(Generator.integers((int)0, (int)(selectionCharacters.length() - 1)), null));
        this.performActionAt(offset, c, env);
    }

    private void performActionAt(int offset, char completionChar, ImperativeCommand.Environment env) {
        Project project2 = this.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, this.getVirtualFile(), 0), true);
        assert (editor != null);
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        editor.getCaretModel().moveToOffset(offset);
        CharSequence textBefore = editor.getDocument().getImmutableCharSequence();
        MadTestingUtil.restrictChangesToDocument(editor.getDocument(), () -> {
            Disposable raiseCompletionLimit = Disposer.newDisposable();
            Registry.get((String)"ide.completion.variant.limit").setValue(100000, raiseCompletionLimit);
            try {
                PsiTestUtil.checkPsiStructureWithCommit(this.getFile(), PsiTestUtil::checkStubsMatchText);
                Editor caretEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)this.getFile());
                this.performCompletion(caretEditor, Objects.requireNonNull(PsiUtilBase.getPsiFileInEditor((Editor)caretEditor, (Project)project2)), completionChar, env);
                PsiTestUtil.checkPsiStructureWithCommit(this.getFile(), PsiTestUtil::checkStubsMatchText);
            }
            catch (Throwable e) {
                LOG.debug("Text before completion:\n" + textBefore);
                env.logMessage("Error happened, the file's text before invoking printed to the debug log, search for 'Text before completion' there");
                throw e;
            }
            finally {
                Disposer.dispose((Disposable)raiseCompletionLimit);
                LookupManager.getInstance((Project)project2).hideActiveLookup();
                UIUtil.dispatchAllInvocationEvents();
            }
        });
    }

    private void performCompletion(@NotNull Editor editor, @NotNull PsiFile file, char completionChar, ImperativeCommand.Environment env) {
        int caretOffset = editor.getCaretModel().getOffset();
        PsiElement leaf = file.findElementAt(TargetElementUtil.adjustOffset((PsiFile)file, (Document)this.getDocument(), (int)caretOffset));
        PsiReference ref = TargetElementUtil.findReference((Editor)editor);
        String expectedVariant = leaf == null || leaf instanceof PsiPlainText ? null : this.myPolicy.getExpectedVariant(editor, file, leaf, ref);
        boolean prefixEqualsExpected = this.isPrefixEqualToExpectedVariant(caretOffset, leaf, ref, expectedVariant);
        boolean shouldCheckDuplicates = this.myPolicy.shouldCheckDuplicates(editor, file, file.findElementAt(caretOffset));
        long stampBefore = this.getDocument().getModificationStamp();
        new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(this.getProject(), editor);
        String notFound = ". Please either fix completion so that the variant is suggested, or, if absolutely needed, tweak CompletionPolicy to exclude it.";
        LookupEx lookup = LookupManager.getActiveLookup((Editor)editor);
        if (lookup == null) {
            if (editor.getCaretModel().getOffset() != caretOffset || this.getDocument().getModificationStamp() != stampBefore) {
                env.logMessage("Completion item was auto-inserted");
                return;
            }
            env.logMessage("No lookup");
            if (expectedVariant == null || prefixEqualsExpected || !this.checkAnnotatorErrorsAtCaret(editor, file, env, expectedVariant)) {
                return;
            }
            TestCase.fail((String)("No lookup, but expected '" + expectedVariant + "' among completion variants" + notFound));
        }
        List items = lookup.getItems();
        if (expectedVariant != null) {
            LookupElement sameItem = (LookupElement)ContainerUtil.find((Iterable)items, e -> e.getAllLookupStrings().stream().anyMatch(s -> Comparing.equal((String)s, (String)expectedVariant, (boolean)e.isCaseSensitive())));
            if (sameItem == null && !this.checkAnnotatorErrorsAtCaret(editor, file, env, expectedVariant)) {
                return;
            }
            TestCase.assertNotNull((String)("No variant '" + expectedVariant + "' among " + items + notFound), (Object)sameItem);
        }
        if (shouldCheckDuplicates) {
            InvokeCompletion.checkNoDuplicates(items);
        }
        LookupElement item = (LookupElement)env.generateValue(Generator.sampledFrom((List)items), null);
        env.logMessage("Select '" + item + "' with '" + StringUtil.escapeStringCharacters((String)String.valueOf(completionChar)) + "'");
        lookup.setCurrentItem(item);
        if (LookupEvent.isSpecialCompletionChar((char)completionChar)) {
            ((LookupImpl)lookup).finishLookup(completionChar, item);
        } else {
            EditorActionManager.getInstance().getTypedAction().actionPerformed(editor, completionChar, ((EditorImpl)lookup.getTopLevelEditor()).getDataContext());
        }
    }

    private boolean checkAnnotatorErrorsAtCaret(@NotNull Editor editor, @NotNull PsiFile file, ImperativeCommand.Environment env, String expectedVariant) {
        int caretOffset;
        List<HighlightInfo> infos = InvokeIntention.highlightErrors(this.getProject(), editor);
        boolean hasErrors = ContainerUtil.exists(infos, arg_0 -> InvokeCompletion.lambda$checkAnnotatorErrorsAtCaret$3(caretOffset = editor.getCaretModel().getOffset(), arg_0));
        if (hasErrors) {
            env.logMessage("Found syntax errors at the completion point, skipping expected completion check for '" + expectedVariant + "'");
            return false;
        }
        return true;
    }

    private boolean isPrefixEqualToExpectedVariant(int caretOffset, PsiElement leaf, PsiReference ref, String expectedVariant) {
        if (expectedVariant == null) {
            return false;
        }
        int expectedEnd = ref != null ? ref.getRangeInElement().getEndOffset() + ref.getElement().getTextRange().getStartOffset() : (leaf != null ? leaf.getTextRange().getEndOffset() : 0);
        return expectedEnd == caretOffset && this.getFile().getText().substring(0, caretOffset).endsWith(expectedVariant);
    }

    private static void checkNoDuplicates(List<LookupElement> items) {
        HashSet<List<Object>> presentations = new HashSet<List<Object>>();
        for (LookupElement item : items) {
            List<Object> info;
            TestLookupElementPresentation p = TestLookupElementPresentation.renderReal(item);
            if (InvokeCompletion.seemsTruncated(p.getItemText()) || InvokeCompletion.seemsTruncated(p.getTailText()) || InvokeCompletion.seemsTruncated(p.getTypeText()) || presentations.add(info = Arrays.asList(TestLookupElementPresentation.unwrapIcon(p.getIcon()), p.getItemText(), p.getItemTextForeground(), p.isItemTextBold(), p.isItemTextUnderlined(), p.getTailFragments(), p.getTypeText(), TestLookupElementPresentation.unwrapIcon(p.getTypeIcon()), p.isTypeGrayed(), p.isStrikeout()))) continue;
            TestCase.fail((String)("Duplicate suggestions: " + (Object)((Object)p)));
        }
    }

    private static boolean seemsTruncated(String text) {
        return text != null && text.contains("...");
    }

    private static /* synthetic */ boolean lambda$checkAnnotatorErrorsAtCaret$3(int caretOffset, HighlightInfo i) {
        return i.getStartOffset() <= caretOffset && caretOffset <= i.getEndOffset();
    }
}

