/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.PlatformTestUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TempDirectory
extends TemporaryFolder {
    private String myName;
    private File myRoot;

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        this.myName = PlatformTestUtil.lowercaseFirstLetter(FileUtil.sanitizeFileName((String)description.getMethodName(), (boolean)false), true);
        return super.apply(base, description);
    }

    protected void before() throws IOException {
        if (this.myName == null) {
            throw new IllegalStateException("apply() was not called");
        }
        File dir = File.createTempFile("unitTest_" + this.myName + "_", "");
        Assert.assertTrue((String)("Cannot delete: " + dir.getPath()), (dir.delete() || !dir.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Cannot create: " + dir.getPath()), (dir.mkdir() || dir.isDirectory() ? 1 : 0) != 0);
        this.myRoot = dir.getCanonicalFile();
    }

    protected void after() {
        if (this.myRoot == null) {
            throw new IllegalStateException("before() was not called");
        }
        FileUtil.delete((File)this.myRoot);
        this.myRoot = null;
        this.myName = null;
    }

    public File getRoot() {
        if (this.myRoot == null) {
            throw new IllegalStateException("before() was not called");
        }
        return this.myRoot;
    }

    public File newFolder(String directoryName) throws IOException {
        Path dir = Paths.get(this.getRoot().getPath(), directoryName);
        if (dir.toFile().exists()) {
            throw new IOException("Already exists: " + dir);
        }
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir.toFile();
    }

    public File newFile(String fileName) throws IOException {
        Path file = Paths.get(this.getRoot().getPath(), fileName);
        if (file.toFile().exists()) {
            throw new IOException("Already exists: " + file);
        }
        TempDirectory.makeDirectories(file.getParent());
        Files.createFile(file, new FileAttribute[0]);
        return file.toFile();
    }

    private static void makeDirectories(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            TempDirectory.makeDirectories(path.getParent());
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }
}

