/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.testIntegration.RecentTestRunner;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationEntry;
import com.intellij.testIntegration.SingleTestEntry;
import com.intellij.testIntegration.SuiteEntry;
import com.intellij.testIntegration.TestEntryVisitor;
import com.intellij.testIntegration.TestLocator;
import org.jetbrains.annotations.NotNull;

class RecentTestRunnerImpl
implements RecentTestRunner {
    private static final AnAction RUN = ActionManager.getInstance().getAction("RunClass");
    private static final AnAction DEBUG = ActionManager.getInstance().getAction("DebugClass");
    private final TestLocator myTestLocator;
    protected AnAction myCurrentAction = RUN;

    @Override
    public void setMode(RecentTestRunner.Mode mode) {
        switch (mode) {
            case RUN: {
                this.myCurrentAction = RUN;
                break;
            }
            case DEBUG: {
                this.myCurrentAction = DEBUG;
            }
        }
    }

    RecentTestRunnerImpl(TestLocator testLocator) {
        this.myTestLocator = testLocator;
    }

    @Override
    public void run(RecentTestsPopupEntry entry) {
        entry.accept(new TestEntryVisitor(){

            @Override
            public void visitTest(@NotNull SingleTestEntry test) {
                RecentTestRunnerImpl.this.run(test.getUrl());
            }

            @Override
            public void visitSuite(@NotNull SuiteEntry suite) {
                RecentTestRunnerImpl.this.run(suite.getSuiteUrl());
            }

            @Override
            public void visitRunConfiguration(@NotNull RunConfigurationEntry configuration) {
                RecentTestRunnerImpl.this.run(configuration.getRunSettings());
            }
        });
    }

    private void run(RunnerAndConfigurationSettings configuration) {
        Executor executor = this.myCurrentAction == RUN ? DefaultRunExecutor.getRunExecutorInstance() : DefaultDebugExecutor.getDebugExecutorInstance();
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor);
    }

    private void run(@NotNull String url) {
        Location location = this.myTestLocator.getLocation(url);
        if (location == null) {
            return;
        }
        DataContext data = dataId -> {
            if (Location.DATA_KEY.is(dataId)) {
                return location;
            }
            return null;
        };
        this.myCurrentAction.actionPerformed(AnActionEvent.createFromAnAction((AnAction)this.myCurrentAction, null, (String)"", (DataContext)data));
    }
}

