/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class ExternalClasspathClassLoader {
    private static List<File> loadFilesPaths(String classpathFilePath) {
        try {
            File file = new File(classpathFilePath);
            LinkedHashSet<File> roots = new LinkedHashSet<File>();
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                while (reader.ready()) {
                    roots.add(new File(reader.readLine()));
                }
            }
            return new ArrayList<File>(roots);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<File> getRoots() {
        String classPathFilePath = System.getProperty("classpath.file");
        return classPathFilePath != null ? ExternalClasspathClassLoader.loadFilesPaths(classPathFilePath) : null;
    }

    public static List<File> getExcludeRoots() {
        try {
            String classPathFilePath = System.getProperty("exclude.tests.roots.file");
            return classPathFilePath != null ? ExternalClasspathClassLoader.loadFilesPaths(classPathFilePath) : null;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static void install() {
        try {
            URL[] urls = ExternalClasspathClassLoader.parseUrls();
            if (urls != null) {
                URLClassLoader auxLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
                Thread.currentThread().setContextClassLoader(auxLoader);
                Thread.currentThread().setContextClassLoader(ExternalClasspathClassLoader.loadOptimizedLoader(urls, auxLoader));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ClassLoader loadOptimizedLoader(Object urls, URLClassLoader auxLoader) throws Exception {
        Object builder = auxLoader.loadClass("com.intellij.util.lang.UrlClassLoader").getMethod("build", new Class[0]).invoke(null, new Object[0]);
        builder.getClass().getMethod("urls", URL[].class).invoke(builder, urls);
        builder.getClass().getMethod("useCache", new Class[0]).invoke(builder, new Object[0]);
        builder.getClass().getMethod("allowLock", new Class[0]).invoke(builder, new Object[0]);
        builder.getClass().getMethod("allowBootstrapResources", new Class[0]).invoke(builder, new Object[0]);
        builder.getClass().getMethod("parent", ClassLoader.class).invoke(builder, auxLoader.getParent());
        return (ClassLoader)builder.getClass().getMethod("get", new Class[0]).invoke(builder, new Object[0]);
    }

    private static URL[] parseUrls() {
        try {
            List<File> roots = ExternalClasspathClassLoader.getRoots();
            if (roots == null) {
                return null;
            }
            URL[] urls = new URL[roots.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = roots.get(i).toURI().toURL();
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

