/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.TestFileSystemItem;
import org.jetbrains.annotations.NotNull;

public class TestFileSystemBuilder {
    private final TestFileSystemItem myItem;
    private final TestFileSystemBuilder myParent;

    private TestFileSystemBuilder(TestFileSystemItem item, TestFileSystemBuilder parent) {
        this.myItem = item;
        this.myParent = parent;
    }

    @NotNull
    public TestFileSystemItem build() {
        TestFileSystemBuilder builder = this;
        while (builder.myParent != null) {
            builder = builder.myParent;
        }
        return builder.myItem;
    }

    @NotNull
    public TestFileSystemBuilder dir(String name2) {
        TestFileSystemItem item = new TestFileSystemItem(name2, false, true);
        this.myItem.addChild(item);
        return new TestFileSystemBuilder(item, this);
    }

    @NotNull
    public TestFileSystemBuilder archive(String name2) {
        TestFileSystemItem item = new TestFileSystemItem(name2, true, false);
        this.myItem.addChild(item);
        return new TestFileSystemBuilder(item, this);
    }

    @NotNull
    public TestFileSystemBuilder file(String name2) {
        this.myItem.addChild(new TestFileSystemItem(name2, false, false));
        return this;
    }

    @NotNull
    public TestFileSystemBuilder file(String name2, String content) {
        this.myItem.addChild(new TestFileSystemItem(name2, false, false, content));
        return this;
    }

    public TestFileSystemBuilder end() {
        return this.myParent;
    }

    @NotNull
    public static TestFileSystemBuilder fs() {
        return new TestFileSystemBuilder(new TestFileSystemItem("root", false, true), null);
    }
}

