/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.TestFileSystemBuilder;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class TestFileSystemItem {
    private final boolean myDirectory;
    private final boolean myArchive;
    private final String myName;
    @Nullable
    private final String myContent;
    private final Map<String, TestFileSystemItem> myChildren = new HashMap<String, TestFileSystemItem>();

    TestFileSystemItem(String name2, boolean archive, boolean directory, @Nullable String content) {
        this.myDirectory = directory;
        this.myArchive = archive;
        this.myName = name2;
        this.myContent = content;
    }

    TestFileSystemItem(String name2, boolean archive, boolean directory) {
        this(name2, archive, directory, null);
    }

    void addChild(TestFileSystemItem item) {
        Assert.assertFalse((String)(item.myName + " already added"), (boolean)this.myChildren.containsKey(item.myName));
        this.myChildren.put(item.myName, item);
    }

    public void assertDirectoryEqual(File file) {
        this.assertDirectoryEqual(file, "/");
    }

    public void assertFileEqual(File file) {
        TestFileSystemItem fileItem = this.myChildren.values().iterator().next();
        fileItem.assertFileEqual(file, "/");
    }

    private void assertDirectoryEqual(File file, String relativePath) {
        File[] actualChildren = file.listFiles();
        HashSet<String> notFound = new HashSet<String>(this.myChildren.keySet());
        if (actualChildren != null) {
            for (File child : actualChildren) {
                String name2 = child.getName();
                TestFileSystemItem item = this.myChildren.get(name2);
                Assert.assertNotNull((String)("unexpected file: " + relativePath + name2), (Object)item);
                item.assertFileEqual(child, relativePath + name2 + "/");
                notFound.remove(name2);
            }
        }
        Assert.assertTrue((String)("files " + ((Object)notFound).toString() + " not found in " + relativePath), (boolean)notFound.isEmpty());
    }

    private void assertFileEqual(File file, String relativePath) {
        try {
            Assert.assertEquals((String)("in " + relativePath), (Object)this.myName, (Object)file.getName());
            if (this.myArchive) {
                File dirForExtracted = FileUtil.createTempDirectory((String)"extracted_archive", null, (boolean)false);
                ZipUtil.extract((File)file, (File)dirForExtracted, null);
                this.assertDirectoryEqual(dirForExtracted, relativePath);
                FileUtil.delete((File)dirForExtracted);
            } else if (this.myDirectory) {
                Assert.assertTrue((String)(relativePath + file.getName() + " is not a directory"), (boolean)file.isDirectory());
                this.assertDirectoryEqual(file, relativePath);
            } else if (this.myContent != null) {
                String content = FileUtil.loadFile((File)file);
                Assert.assertEquals((String)("content mismatch for " + relativePath), (Object)this.myContent, (Object)content);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TestFileSystemBuilder fs() {
        return TestFileSystemBuilder.fs();
    }
}

