/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.classpath;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseLibrariesDialogBase
extends DialogWrapper {
    private final SimpleTree myTree = new SimpleTree();
    private AbstractTreeBuilder myBuilder;
    private List<Library> myResult;
    private final Map<Object, Object> myParentsMap = new THashMap();

    protected ChooseLibrariesDialogBase(JComponent parentComponent, String title) {
        super((Component)parentComponent, false);
        this.setTitle(title);
    }

    protected ChooseLibrariesDialogBase(Project project2, String title) {
        super(project2, false);
        this.setTitle(title);
    }

    protected void init() {
        super.init();
        this.updateOKAction();
    }

    private static String notEmpty(String nodeText) {
        return StringUtil.isNotEmpty((String)nodeText) ? nodeText : "<unnamed>";
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.util.ui.classpath.ChooseLibrariesDialog";
    }

    protected int getLibraryTableWeight(@NotNull LibraryTable libraryTable) {
        return 0;
    }

    protected boolean isAutoExpandLibraryTable(@NotNull LibraryTable libraryTable) {
        return false;
    }

    protected void doOKAction() {
        this.myResult = new ArrayList<Library>();
        this.processSelection((Processor<? super Library>)new CommonProcessors.CollectProcessor(this.myResult));
        super.doOKAction();
    }

    private void updateOKAction() {
        this.setOKActionEnabled(!this.processSelection((Processor<? super Library>)new CommonProcessors.FindFirstProcessor()));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @NotNull
    public List<Library> getSelectedLibraries() {
        return this.myResult == null ? Collections.emptyList() : this.myResult;
    }

    protected void queueUpdateAndSelect(@NotNull Library library) {
        this.myBuilder.queueUpdate().doWhenDone(() -> this.myBuilder.select((Object)library));
    }

    private boolean processSelection(Processor<? super Library> processor2) {
        for (Object element : this.myBuilder.getSelectedElements()) {
            if (!(element instanceof Library) || processor2.process((Object)((Library)element))) continue;
            return false;
        }
        return true;
    }

    protected boolean acceptsElement(Object element) {
        return true;
    }

    protected JComponent createNorthPanel() {
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultTreeExpander expander = new DefaultTreeExpander((JTree)this.myTree);
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        group.add(actionsManager.createExpandAllAction((TreeExpander)expander, (JComponent)this.myTree));
        group.add(actionsManager.createCollapseAllAction((TreeExpander)expander, (JComponent)this.myTree));
        JComponent component = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)group, true).getComponent();
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), component.getBorder()));
        return component;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myBuilder = new SimpleTreeBuilder((JTree)this.myTree, new DefaultTreeModel(new DefaultMutableTreeNode()), new MyStructure(this.getProject()), (Comparator)WeightBasedComparator.FULL_INSTANCE){};
        this.myBuilder.initRootNode();
        this.myTree.setDragEnabled(false);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.setRootVisible(false);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ChooseLibrariesDialogBase.this.updateOKAction();
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (ChooseLibrariesDialogBase.this.isOKActionEnabled()) {
                    ChooseLibrariesDialogBase.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myTree);
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        this.myTree.getActionMap().put("ENTER", this.getOKAction());
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        pane.setPreferredSize((Dimension)JBUI.size((int)500, (int)400));
        return pane;
    }

    @NotNull
    protected Project getProject() {
        return ProjectManager.getInstance().getDefaultProject();
    }

    protected LibrariesTreeNodeBase<Library> createLibraryDescriptor(NodeDescriptor parentDescriptor, Library library) {
        return new LibraryDescriptor(this.getProject(), parentDescriptor, library);
    }

    protected void collectChildren(Object element, List<Object> result) {
        if (element instanceof Application) {
            Collections.addAll(result, ProjectManager.getInstance().getOpenProjects());
            LibraryTablesRegistrar instance2 = LibraryTablesRegistrar.getInstance();
            result.add(instance2.getLibraryTable());
            result.addAll(instance2.getCustomLibraryTables());
        } else if (element instanceof Project) {
            Collections.addAll(result, ModuleManager.getInstance((Project)((Project)element)).getModules());
            result.add(LibraryTablesRegistrar.getInstance().getLibraryTable((Project)element));
        } else if (element instanceof LibraryTable) {
            Collections.addAll(result, ((LibraryTable)element).getLibraries());
        } else if (element instanceof Module) {
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)((Module)element)).getOrderEntries()) {
                LibraryOrderEntry libraryOrderEntry;
                if (!(entry instanceof LibraryOrderEntry) || !"module".equals((libraryOrderEntry = (LibraryOrderEntry)entry).getLibraryLevel())) continue;
                Library library = libraryOrderEntry.getLibrary();
                result.add(library);
            }
        }
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myBuilder);
        super.dispose();
    }

    public boolean isEmpty() {
        ArrayList<Object> children = new ArrayList<Object>();
        this.collectChildren(this.myBuilder.getTreeStructure().getRootElement(), children);
        return children.isEmpty();
    }

    private class MyStructure
    extends AbstractTreeStructure {
        private final Project myProject;

        MyStructure(Project project2) {
            this.myProject = project2;
        }

        @NotNull
        public Object getRootElement() {
            return ApplicationManager.getApplication();
        }

        @NotNull
        public Object[] getChildElements(@NotNull Object element) {
            ArrayList<Object> result = new ArrayList<Object>();
            ChooseLibrariesDialogBase.this.collectChildren(element, result);
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (ChooseLibrariesDialogBase.this.acceptsElement(it.next())) continue;
                it.remove();
            }
            for (Object e : result) {
                ChooseLibrariesDialogBase.this.myParentsMap.put(e, element);
            }
            return result.toArray();
        }

        public Object getParentElement(@NotNull Object element) {
            if (element instanceof Application) {
                return null;
            }
            if (element instanceof Project) {
                return ApplicationManager.getApplication();
            }
            if (element instanceof Module) {
                return ((Module)element).getProject();
            }
            if (element instanceof LibraryTable) {
                return ChooseLibrariesDialogBase.this.myParentsMap.get(element);
            }
            if (element instanceof Library) {
                return ChooseLibrariesDialogBase.this.myParentsMap.get(element);
            }
            throw new AssertionError();
        }

        @NotNull
        public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
            if (element instanceof Application) {
                return new RootDescriptor(this.myProject);
            }
            if (element instanceof Project) {
                return new ProjectDescriptor(this.myProject, (Project)element);
            }
            if (element instanceof Module) {
                return new ModuleDescriptor(this.myProject, parentDescriptor, (Module)element);
            }
            if (element instanceof LibraryTable) {
                LibraryTable libraryTable = (LibraryTable)element;
                return new LibraryTableDescriptor(this.myProject, parentDescriptor, libraryTable, ChooseLibrariesDialogBase.this.getLibraryTableWeight(libraryTable), ChooseLibrariesDialogBase.this.isAutoExpandLibraryTable(libraryTable));
            }
            if (element instanceof Library) {
                return ChooseLibrariesDialogBase.this.createLibraryDescriptor(parentDescriptor, (Library)element);
            }
            throw new AssertionError();
        }

        public void commit() {
        }

        public boolean hasSomethingToCommit() {
            return false;
        }
    }

    private static class LibraryTableDescriptor
    extends LibrariesTreeNodeBase<LibraryTable> {
        private final int myWeight;
        private final boolean myAutoExpand;

        protected LibraryTableDescriptor(Project project2, NodeDescriptor parentDescriptor, LibraryTable table, int weight, boolean autoExpand) {
            super(project2, parentDescriptor, table);
            this.myWeight = weight;
            this.myAutoExpand = autoExpand;
            this.getTemplatePresentation().setIcon(PlatformIcons.LIBRARY_ICON);
            String nodeText = table.getPresentation().getDisplayName(true);
            this.getTemplatePresentation().addText(ChooseLibrariesDialogBase.notEmpty(nodeText), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        public boolean isAutoExpandNode() {
            return this.myAutoExpand;
        }

        @Override
        public int getWeight() {
            return this.myWeight;
        }
    }

    private static class LibraryDescriptor
    extends LibrariesTreeNodeBase<Library> {
        protected LibraryDescriptor(Project project2, NodeDescriptor parentDescriptor, Library element) {
            super(project2, parentDescriptor, element);
            CellAppearanceEx appearance = OrderEntryAppearanceService.getInstance().forLibrary(project2, element, false);
            SimpleColoredComponent coloredComponent = new SimpleColoredComponent();
            appearance.customize(coloredComponent);
            PresentationData templatePresentation = this.getTemplatePresentation();
            templatePresentation.setIcon(coloredComponent.getIcon());
            templatePresentation.addText(ChooseLibrariesDialogBase.notEmpty(appearance.getText()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private static class ModuleDescriptor
    extends LibrariesTreeNodeBase<Module> {
        protected ModuleDescriptor(Project project2, NodeDescriptor parentDescriptor, Module element) {
            super(project2, parentDescriptor, element);
            PresentationData templatePresentation = this.getTemplatePresentation();
            templatePresentation.setIcon(ModuleType.get((Module)element).getIcon());
            templatePresentation.addText(ChooseLibrariesDialogBase.notEmpty(element.getName()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        @Override
        public int getWeight() {
            return 1;
        }
    }

    private static class ProjectDescriptor
    extends LibrariesTreeNodeBase<Project> {
        protected ProjectDescriptor(Project project2, Project element) {
            super(project2, null, element);
            this.getTemplatePresentation().setIcon(PlatformIcons.PROJECT_ICON);
            this.getTemplatePresentation().addText(ChooseLibrariesDialogBase.notEmpty(((Project)this.getElement()).getName()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private static class RootDescriptor
    extends LibrariesTreeNodeBase<Object> {
        protected RootDescriptor(Project project2) {
            super(project2, null, ApplicationManager.getApplication());
        }
    }

    protected static class LibrariesTreeNodeBase<T>
    extends SimpleNode {
        private final T myElement;

        protected LibrariesTreeNodeBase(Project project2, NodeDescriptor parentDescriptor, T element) {
            super(project2, parentDescriptor);
            this.myElement = element;
        }

        public T getElement() {
            return this.myElement;
        }

        @NotNull
        public SimpleNode[] getChildren() {
            return NO_CHILDREN;
        }

        public int getWeight() {
            return 0;
        }

        @NotNull
        public Object[] getEqualityObjects() {
            return new Object[]{this.myElement};
        }

        protected void update(@NotNull PresentationData presentation) {
            presentation.setIcon(this.getTemplatePresentation().getIcon(false));
        }
    }
}

