/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.classpath;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.util.ui.classpath.ChooseLibrariesDialogBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseLibrariesFromTablesDialog
extends ChooseLibrariesDialogBase {
    @Nullable
    private final Project myProject;
    private final boolean myShowCustomLibraryTables;

    protected ChooseLibrariesFromTablesDialog(@NotNull String title, @NotNull Project project2, boolean showCustomLibraryTables) {
        super(project2, title);
        this.myShowCustomLibraryTables = showCustomLibraryTables;
        this.myProject = project2;
    }

    protected ChooseLibrariesFromTablesDialog(@NotNull JComponent parentComponent, @NotNull String title, @Nullable Project project2, boolean showCustomLibraryTables) {
        super(parentComponent, title);
        this.myShowCustomLibraryTables = showCustomLibraryTables;
        this.myProject = project2;
    }

    public static ChooseLibrariesFromTablesDialog createDialog(@NotNull String title, @NotNull Project project2, boolean showCustomLibraryTables) {
        ChooseLibrariesFromTablesDialog dialog = new ChooseLibrariesFromTablesDialog(title, project2, showCustomLibraryTables);
        dialog.init();
        return dialog;
    }

    @Override
    @NotNull
    protected Project getProject() {
        if (this.myProject != null) {
            return this.myProject;
        }
        return super.getProject();
    }

    @Override
    protected JComponent createNorthPanel() {
        return null;
    }

    @Override
    protected void collectChildren(Object element, List<Object> result) {
        if (element instanceof Application) {
            for (LibraryTable table : ChooseLibrariesFromTablesDialog.getLibraryTables(this.myProject, this.myShowCustomLibraryTables)) {
                if (!this.hasLibraries(table)) continue;
                result.add(table);
            }
        } else if (element instanceof LibraryTable) {
            Collections.addAll(result, this.getLibraries((LibraryTable)element));
        }
    }

    public static List<LibraryTable> getLibraryTables(Project project2, boolean showCustomLibraryTables) {
        ArrayList<LibraryTable> tables = new ArrayList<LibraryTable>();
        LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
        if (project2 != null) {
            tables.add(registrar.getLibraryTable(project2));
        }
        tables.add(registrar.getLibraryTable());
        if (showCustomLibraryTables) {
            tables.addAll(registrar.getCustomLibraryTables());
        }
        return tables;
    }

    private boolean hasLibraries(LibraryTable table) {
        Library[] libraries2;
        for (Library library : libraries2 = this.getLibraries(table)) {
            if (!this.acceptsElement(library)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getLibraryTableWeight(@NotNull LibraryTable libraryTable) {
        if (libraryTable.getTableLevel().equals("module")) {
            return 0;
        }
        if (this.isProjectLibraryTable(libraryTable)) {
            return 1;
        }
        if (ChooseLibrariesFromTablesDialog.isApplicationLibraryTable(libraryTable)) {
            return 2;
        }
        return 3;
    }

    private static boolean isApplicationLibraryTable(LibraryTable libraryTable) {
        return libraryTable.equals(LibraryTablesRegistrar.getInstance().getLibraryTable());
    }

    private boolean isProjectLibraryTable(LibraryTable libraryTable) {
        LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
        return this.myProject != null && libraryTable.equals(registrar.getLibraryTable(this.myProject));
    }

    @Override
    protected boolean isAutoExpandLibraryTable(@NotNull LibraryTable libraryTable) {
        return ChooseLibrariesFromTablesDialog.isApplicationLibraryTable(libraryTable) || this.isProjectLibraryTable(libraryTable);
    }

    @NotNull
    protected Library[] getLibraries(@NotNull LibraryTable table) {
        return table.getLibraries();
    }
}

