/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomApplicationComponent;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DomFileIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> NAME = ID.create((String)"DomFileIndex");
    private final DataIndexer<String, Void, FileContent> myDataIndexer = new DataIndexer<String, Void, FileContent>(){

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            THashSet namespaces = new THashSet();
            XmlFileHeader header = NanoXmlUtil.parseHeader((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()));
            ContainerUtil.addIfNotNull((Collection)namespaces, (Object)header.getPublicId());
            ContainerUtil.addIfNotNull((Collection)namespaces, (Object)header.getSystemId());
            ContainerUtil.addIfNotNull((Collection)namespaces, (Object)header.getRootTagNamespace());
            String tagName = header.getRootTagLocalName();
            if (StringUtil.isNotEmpty((String)tagName)) {
                String[] strings;
                THashMap result = new THashMap();
                DomApplicationComponent component = DomApplicationComponent.getInstance();
                for (DomFileDescription description : component.getFileDescriptions(tagName)) {
                    strings = description.getAllPossibleRootTagNamespaces();
                    if (strings.length != 0 && !ContainerUtil.intersects(Arrays.asList(strings), (Collection)namespaces)) continue;
                    result.put((Object)description.getRootElementClass().getName(), null);
                }
                for (DomFileDescription description : component.getAcceptingOtherRootTagNameDescriptions()) {
                    strings = description.getAllPossibleRootTagNamespaces();
                    if (strings.length != 0 && !ContainerUtil.intersects(Arrays.asList(strings), (Collection)namespaces)) continue;
                    result.put((Object)description.getRootElementClass().getName(), null);
                }
                return result;
            }
            return Collections.emptyMap();
        }
    };

    @NotNull
    public ID<String, Void> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return this.myDataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML});
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return DomApplicationComponent.getInstance().getCumulativeVersion(false);
    }
}

