/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsHighlightingUtil;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolderImpl;
import com.intellij.util.xml.highlighting.DomHighlightStatus;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.highlighting.DomHighlightingHelperImpl;
import com.intellij.util.xml.highlighting.MockAnnotatingDomInspection;
import com.intellij.util.xml.highlighting.MockDomInspection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementAnnotationsManagerImpl
extends DomElementAnnotationsManager {
    public static final Object LOCK = new Object();
    private static final Key<DomElementsProblemsHolderImpl> DOM_PROBLEM_HOLDER_KEY = Key.create((String)"DomProblemHolder");
    private static final Key<CachedValue<Boolean>> CACHED_VALUE_KEY = Key.create((String)"DomProblemHolderCachedValue");
    private final EventDispatcher<DomElementAnnotationsManager.DomHighlightingListener> myDispatcher = EventDispatcher.create(DomElementAnnotationsManager.DomHighlightingListener.class);
    private static final DomElementsProblemsHolder EMPTY_PROBLEMS_HOLDER = new DomElementsProblemsHolder(){

        @NotNull
        public List<DomElementProblemDescriptor> getProblems(DomElement domElement) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean withChildren, HighlightSeverity minSeverity) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getAllProblems() {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getAllProblems(@NotNull DomElementsInspection inspection) {
            return Collections.emptyList();
        }

        public boolean isInspectionCompleted(@NotNull DomElementsInspection inspectionClass) {
            return false;
        }
    };
    private final Project myProject;

    public DomElementAnnotationsManagerImpl(@NotNull Project project2) {
        this.myProject = project2;
        ProjectInspectionProfileManager.getInstance((Project)project2).addProfileChangeListener(new ProfileChangeAdapter(){

            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile2) {
                DomElementAnnotationsManagerImpl.this.dropAnnotationsCache();
            }

            public void profileChanged(InspectionProfile profile2) {
                DomElementAnnotationsManagerImpl.this.dropAnnotationsCache();
            }
        }, (Disposable)project2);
    }

    public void dropAnnotationsCache() {
        this.incModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DomElementProblemDescriptor> appendProblems(@NotNull DomFileElement element, @NotNull DomElementAnnotationHolder annotationHolder, Class<? extends DomElementsInspection> inspectionClass) {
        DomElementAnnotationHolderImpl holderImpl = (DomElementAnnotationHolderImpl)annotationHolder;
        Object object = LOCK;
        synchronized (object) {
            DomElementsProblemsHolderImpl holder = this._getOrCreateProblemsHolder(element);
            holder.appendProblems(holderImpl, inspectionClass);
        }
        ((DomElementAnnotationsManager.DomHighlightingListener)this.myDispatcher.getMulticaster()).highlightingFinished(element);
        return Collections.unmodifiableList(holderImpl);
    }

    private DomElementsProblemsHolderImpl _getOrCreateProblemsHolder(DomFileElement element) {
        DomElement rootElement = element.getRootElement();
        XmlTag rootTag = rootElement.getXmlTag();
        if (rootTag == null) {
            return new DomElementsProblemsHolderImpl(element);
        }
        DomElementsProblemsHolderImpl holder = (DomElementsProblemsHolderImpl)rootTag.getUserData(DOM_PROBLEM_HOLDER_KEY);
        if (DomElementAnnotationsManagerImpl.isHolderOutdated(element.getFile()) || holder == null) {
            holder = new DomElementsProblemsHolderImpl(element);
            rootTag.putUserData(DOM_PROBLEM_HOLDER_KEY, (Object)holder);
            CachedValue cachedValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> new CachedValueProvider.Result((Object)Boolean.FALSE, new Object[]{element, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this, ProjectRootManager.getInstance((Project)this.myProject)}), false);
            cachedValue.getValue();
            element.getFile().putUserData(CACHED_VALUE_KEY, (Object)cachedValue);
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHolderUpToDate(DomElement element) {
        Object object = LOCK;
        synchronized (object) {
            return !DomElementAnnotationsManagerImpl.isHolderOutdated(DomUtil.getFile((DomElement)element));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outdateProblemHolder(DomElement element) {
        Object object = LOCK;
        synchronized (object) {
            DomUtil.getFile((DomElement)element).putUserData(CACHED_VALUE_KEY, null);
        }
    }

    private static boolean isHolderOutdated(XmlFile file) {
        CachedValue cachedValue = (CachedValue)file.getUserData(CACHED_VALUE_KEY);
        return cachedValue == null || !cachedValue.hasUpToDateValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DomElementsProblemsHolder getProblemHolder(DomElement element) {
        if (element == null || !element.isValid()) {
            return EMPTY_PROBLEMS_HOLDER;
        }
        DomFileElement fileElement = DomUtil.getFileElement((DomElement)element);
        Object object = LOCK;
        synchronized (object) {
            DomElementsProblemsHolder readyHolder;
            XmlTag tag = fileElement.getRootElement().getXmlTag();
            if (tag != null && (readyHolder = (DomElementsProblemsHolder)tag.getUserData(DOM_PROBLEM_HOLDER_KEY)) != null) {
                return readyHolder;
            }
            return EMPTY_PROBLEMS_HOLDER;
        }
    }

    @NotNull
    public DomElementsProblemsHolder getCachedProblemHolder(DomElement element) {
        return this.getProblemHolder(element);
    }

    public List<ProblemDescriptor> createProblemDescriptors(InspectionManager manager, DomElementProblemDescriptor problemDescriptor) {
        return ContainerUtil.createMaybeSingletonList((Object)DomElementsHighlightingUtil.createProblemDescriptors(manager, problemDescriptor));
    }

    public boolean isHighlightingFinished(DomElement[] domElements) {
        for (DomElement domElement : domElements) {
            if (this.getHighlightStatus(domElement) == DomHighlightStatus.INSPECTIONS_FINISHED) continue;
            return false;
        }
        return true;
    }

    public void addHighlightingListener(DomElementAnnotationsManager.DomHighlightingListener listener, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public DomHighlightingHelper getHighlightingHelper() {
        return DomHighlightingHelperImpl.INSTANCE;
    }

    @NotNull
    public <T extends DomElement> List<DomElementProblemDescriptor> checkFileElement(@NotNull DomFileElement<T> domFileElement, @NotNull DomElementsInspection<T> inspection, boolean onTheFly) {
        DomElementsProblemsHolder problemHolder = this.getProblemHolder((DomElement)domFileElement);
        if (DomElementAnnotationsManagerImpl.isHolderUpToDate(domFileElement) && problemHolder.isInspectionCompleted(inspection)) {
            return problemHolder.getAllProblems(inspection);
        }
        DomElementAnnotationHolderImpl holder = new DomElementAnnotationHolderImpl(onTheFly, domFileElement);
        inspection.checkFileElement(domFileElement, (DomElementAnnotationHolder)holder);
        return this.appendProblems(domFileElement, holder, inspection.getClass());
    }

    public List<DomElementsInspection> getSuitableDomInspections(DomFileElement fileElement, boolean enabledOnly) {
        Class rootType = fileElement.getRootElementClass();
        InspectionProfile profile2 = this.getInspectionProfile(fileElement);
        SmartList inspections = new SmartList();
        for (InspectionToolWrapper toolWrapper : profile2.getInspectionTools((PsiElement)fileElement.getFile())) {
            InspectionProfileEntry entry;
            if (enabledOnly && !profile2.isToolEnabled(HighlightDisplayKey.find((String)toolWrapper.getShortName()), (PsiElement)fileElement.getFile()) || !((entry = toolWrapper.getTool()) instanceof DomElementsInspection) || !ContainerUtil.exists((Iterable)((DomElementsInspection)entry).getDomClasses(), cls -> cls.isAssignableFrom(rootType))) continue;
            inspections.add((DomElementsInspection)entry);
        }
        return inspections;
    }

    protected InspectionProfile getInspectionProfile(DomFileElement fileElement) {
        return InspectionProjectProfileManager.getInstance((Project)fileElement.getManager().getProject()).getCurrentProfile();
    }

    @Nullable
    public <T extends DomElement> DomElementsInspection<T> getMockInspection(DomFileElement<? extends T> root) {
        if (root.getFileDescription().isAutomaticHighlightingEnabled()) {
            return new MockAnnotatingDomInspection(root.getRootElementClass());
        }
        if (this.getSuitableDomInspections(root, false).isEmpty()) {
            return new MockDomInspection(root.getRootElementClass());
        }
        return null;
    }

    private static boolean areInspectionsFinished(DomElementsProblemsHolderImpl holder, List<? extends DomElementsInspection> suitableInspections) {
        for (DomElementsInspection domElementsInspection : suitableInspections) {
            if (holder.isInspectionCompleted(domElementsInspection)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DomHighlightStatus getHighlightStatus(DomElement element) {
        Object object = LOCK;
        synchronized (object) {
            DomElementsProblemsHolder holder;
            DomFileElement root = DomUtil.getFileElement((DomElement)element);
            if (!DomElementAnnotationsManagerImpl.isHolderOutdated(root.getFile()) && (holder = this.getProblemHolder(element)) instanceof DomElementsProblemsHolderImpl) {
                DomElementsProblemsHolderImpl holderImpl = (DomElementsProblemsHolderImpl)holder;
                List<DomElementsInspection> suitableInspections = this.getSuitableDomInspections(root, true);
                DomElementsInspection mockInspection = this.getMockInspection(root);
                boolean annotatorsFinished = mockInspection == null || holderImpl.isInspectionCompleted(mockInspection);
                boolean inspectionsFinished = DomElementAnnotationsManagerImpl.areInspectionsFinished(holderImpl, suitableInspections);
                if (annotatorsFinished) {
                    if (suitableInspections.isEmpty() || inspectionsFinished) {
                        return DomHighlightStatus.INSPECTIONS_FINISHED;
                    }
                    return DomHighlightStatus.ANNOTATORS_FINISHED;
                }
            }
            return DomHighlightStatus.NONE;
        }
    }
}

