/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.util.SmartList;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChildrenDescriptionsHolder<T extends DomChildDescriptionImpl> {
    private final Map<XmlName, T> myMap = new THashMap();
    private final ChildrenDescriptionsHolder<? extends T> myDelegate;
    private volatile List<T> myCached = null;

    public ChildrenDescriptionsHolder(@Nullable ChildrenDescriptionsHolder<? extends T> delegate) {
        this.myDelegate = delegate;
    }

    public ChildrenDescriptionsHolder() {
        this(null);
    }

    final T addDescription(@NotNull T t) {
        this.myMap.put(((DomChildDescriptionImpl)t).getXmlName(), t);
        this.myCached = null;
        return t;
    }

    final void addDescriptions(@NotNull Collection<? extends T> collection) {
        for (DomChildDescriptionImpl t : collection) {
            this.addDescription(t);
        }
    }

    @Nullable
    final T getDescription(XmlName name2) {
        DomChildDescriptionImpl t = (DomChildDescriptionImpl)this.myMap.get(name2);
        if (t != null) {
            return (T)t;
        }
        return this.myDelegate != null ? (T)this.myDelegate.getDescription(name2) : null;
    }

    @Nullable
    final T getDescription(@NotNull String localName, String namespaceKey) {
        return this.getDescription(new XmlName(localName, namespaceKey));
    }

    @Nullable
    final T findDescription(@NotNull String localName) {
        for (XmlName xmlName : this.myMap.keySet()) {
            if (!xmlName.getLocalName().equals(localName)) continue;
            return (T)((DomChildDescriptionImpl)this.myMap.get(xmlName));
        }
        return this.myDelegate != null ? (T)this.myDelegate.findDescription(localName) : null;
    }

    @NotNull
    final List<T> getDescriptions() {
        ArrayList result = new ArrayList();
        this.dumpDescriptions(result);
        return result;
    }

    private List<T> getSortedDescriptions() {
        SmartList cached = this.myCached;
        if (cached != null) {
            return cached;
        }
        if (!this.myMap.isEmpty()) {
            cached = new SmartList(this.myMap.values());
            Collections.sort(cached);
        } else {
            cached = Collections.emptyList();
        }
        this.myCached = cached;
        return cached;
    }

    final void dumpDescriptions(Collection<? super T> to) {
        to.addAll(this.getSortedDescriptions());
        if (this.myDelegate != null) {
            this.myDelegate.dumpDescriptions(to);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChildrenDescriptionsHolder)) {
            return false;
        }
        ChildrenDescriptionsHolder holder = (ChildrenDescriptionsHolder)o;
        if (this.myDelegate != null ? !this.myDelegate.equals(holder.myDelegate) : holder.myDelegate != null) {
            return false;
        }
        return this.myMap.equals(holder.myMap);
    }

    public int hashCode() {
        int result = this.myMap.hashCode();
        result = 31 * result + (this.myDelegate != null ? this.myDelegate.hashCode() : 0);
        return result;
    }
}

