/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.paths.PathReference;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ConcurrentInstanceMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomResolveConverter;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.converters.PathReferenceConverter;
import com.intellij.util.xml.converters.values.NumberValueConverter;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConverterManagerImpl
implements ConverterManager {
    private final ImplementationClassCache myImplementationClassCache = new ImplementationClassCache(DomImplementationClassEP.CONVERTER_EP_NAME);
    private final ConcurrentMap<Class, Object> myConverterInstances = ConcurrentFactoryMap.createMap(key -> {
        Class implementation = this.myImplementationClassCache.get((Class)key);
        return ConcurrentInstanceMap.calculate((Class)(implementation == null ? key : implementation));
    });
    private final Map<Class, Converter> mySimpleConverters = new HashMap<Class, Converter>();

    ConverterManagerImpl() {
        this.mySimpleConverters.put(Byte.TYPE, (Converter)new NumberValueConverter(Byte.TYPE, false));
        this.mySimpleConverters.put(Byte.class, (Converter)new NumberValueConverter(Byte.class, true));
        this.mySimpleConverters.put(Short.TYPE, (Converter)new NumberValueConverter(Short.TYPE, false));
        this.mySimpleConverters.put(Short.class, (Converter)new NumberValueConverter(Short.class, true));
        this.mySimpleConverters.put(Integer.TYPE, (Converter)new NumberValueConverter(Integer.TYPE, false));
        this.mySimpleConverters.put(Integer.class, (Converter)new NumberValueConverter(Integer.class, false));
        this.mySimpleConverters.put(Long.TYPE, (Converter)new NumberValueConverter(Long.TYPE, false));
        this.mySimpleConverters.put(Long.class, (Converter)new NumberValueConverter(Long.class, true));
        this.mySimpleConverters.put(Float.TYPE, (Converter)new NumberValueConverter(Float.TYPE, false));
        this.mySimpleConverters.put(Float.class, (Converter)new NumberValueConverter(Float.class, true));
        this.mySimpleConverters.put(Double.TYPE, (Converter)new NumberValueConverter(Double.TYPE, false));
        this.mySimpleConverters.put(Double.class, (Converter)new NumberValueConverter(Double.class, true));
        this.mySimpleConverters.put(BigDecimal.class, (Converter)new NumberValueConverter(BigDecimal.class, true));
        this.mySimpleConverters.put(BigInteger.class, (Converter)new NumberValueConverter(BigInteger.class, true));
        this.mySimpleConverters.put(Boolean.TYPE, ResolvingConverter.BOOLEAN_CONVERTER);
        this.mySimpleConverters.put(Boolean.class, ResolvingConverter.BOOLEAN_CONVERTER);
        this.mySimpleConverters.put(String.class, Converter.EMPTY_CONVERTER);
        this.mySimpleConverters.put(Object.class, Converter.EMPTY_CONVERTER);
        this.mySimpleConverters.put(PathReference.class, PathReferenceConverter.INSTANCE);
    }

    public void addConverter(Class clazz, Converter converter) {
        this.mySimpleConverters.put(clazz, converter);
    }

    @NotNull
    public final Converter getConverterInstance(Class<? extends Converter> converterClass) {
        Converter converter = this.getInstance(converterClass);
        assert (converter != null) : "Converter not found for " + converterClass;
        return converter;
    }

    <T> T getInstance(Class<T> clazz) {
        return (T)this.myConverterInstances.get(clazz);
    }

    @Nullable
    public final Converter getConverterByClass(Class<?> convertingClass) {
        Converter converter = this.mySimpleConverters.get(convertingClass);
        if (converter != null) {
            return converter;
        }
        if (Enum.class.isAssignableFrom(convertingClass)) {
            return EnumConverter.createEnumConverter(convertingClass);
        }
        if (DomElement.class.isAssignableFrom(convertingClass)) {
            return DomResolveConverter.createConverter(convertingClass);
        }
        return null;
    }

    public <T extends Converter> void registerConverterImplementation(Class<T> converterInterface, T converterImpl) {
        this.myConverterInstances.put(converterInterface, converterImpl);
    }
}

