/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.HyphenNameStrategy;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaNameStrategy;
import com.intellij.util.xml.NameStrategy;
import com.intellij.util.xml.NameStrategyForAttributes;
import com.intellij.util.xml.Namespace;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.SubTagList;
import com.intellij.util.xml.TagValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomImplUtil");

    private DomImplUtil() {
    }

    public static void assertValidity(DomElement element, String msg) {
        if (element instanceof DomFileElementImpl) {
            String s = ((DomFileElementImpl)element).checkValidity();
            if (s != null) {
                throw new AssertionError((Object)s);
            }
            return;
        }
        DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler(element);
        assert (handler != null);
        try {
            handler.assertValid();
        }
        catch (AssertionError e) {
            throw new AssertionError((Object)(msg + ((Throwable)((Object)e)).getMessage()));
        }
    }

    public static boolean isTagValueGetter(JavaMethod method) {
        if (!DomImplUtil.isGetter(method)) {
            return false;
        }
        if (DomImplUtil.hasTagValueAnnotation(method)) {
            return true;
        }
        if ("getValue".equals(method.getName())) {
            if (method.getAnnotation(SubTag.class) != null) {
                return false;
            }
            if (method.getAnnotation(SubTagList.class) != null) {
                return false;
            }
            if (method.getAnnotation(Convert.class) != null || method.getAnnotation(Resolve.class) != null) {
                return !ReflectionUtil.isAssignable(GenericDomValue.class, (Class)method.getReturnType());
            }
            return !ReflectionUtil.isAssignable(DomElement.class, (Class)method.getReturnType());
        }
        return false;
    }

    private static boolean hasTagValueAnnotation(JavaMethod method) {
        return method.getAnnotation(TagValue.class) != null;
    }

    public static boolean isGetter(JavaMethod method) {
        boolean isIs;
        String name2 = method.getName();
        boolean isGet = name2.startsWith("get");
        boolean bl = isIs = !isGet && name2.startsWith("is");
        if (!isGet && !isIs) {
            return false;
        }
        if (method.getGenericParameterTypes().length != 0) {
            return false;
        }
        Type returnType = method.getGenericReturnType();
        if (isGet) {
            return returnType != Void.TYPE;
        }
        return DomReflectionUtil.canHaveIsPropertyGetterPrefix((Type)returnType);
    }

    public static boolean isTagValueSetter(JavaMethod method) {
        boolean setter = method.getName().startsWith("set") && method.getGenericParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
        return setter && (DomImplUtil.hasTagValueAnnotation(method) || "setValue".equals(method.getName()));
    }

    @Nullable
    public static DomNameStrategy getDomNameStrategy(Class<?> rawType, boolean isAttribute) {
        NameStrategyForAttributes annotation;
        Class aClass = null;
        if (isAttribute && (annotation = (NameStrategyForAttributes)DomReflectionUtil.findAnnotationDFS(rawType, NameStrategyForAttributes.class)) != null) {
            aClass = annotation.value();
        }
        if (aClass == null && (annotation = (NameStrategy)DomReflectionUtil.findAnnotationDFS(rawType, NameStrategy.class)) != null) {
            aClass = annotation.value();
        }
        if (aClass != null) {
            if (HyphenNameStrategy.class.equals(aClass)) {
                return DomNameStrategy.HYPHEN_STRATEGY;
            }
            if (JavaNameStrategy.class.equals((Object)aClass)) {
                return DomNameStrategy.JAVA_STRATEGY;
            }
            try {
                return (DomNameStrategy)aClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    public static List<XmlTag> findSubTags(@NotNull XmlTag tag, EvaluatedXmlName name2, XmlFile file) {
        if (!tag.isValid()) {
            throw new AssertionError((Object)"Invalid tag");
        }
        Object[] tags = tag.getSubTags();
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])tags, childTag -> {
            try {
                return DomImplUtil.isNameSuitable(name2, childTag.getLocalName(), childTag.getName(), childTag.getNamespace(), file);
            }
            catch (PsiInvalidElementAccessException e) {
                if (!childTag.isValid()) {
                    LOG.error("tag.getSubTags() returned invalid, tag=" + tag + ", containing file: " + tag.getContainingFile() + "subTag.parent=" + childTag.getNode().getTreeParent());
                    return false;
                }
                throw e;
            }
        });
    }

    public static List<XmlTag> findSubTags(XmlTag[] tags, EvaluatedXmlName name2, XmlFile file) {
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])tags, childTag -> DomImplUtil.isNameSuitable(name2, childTag, file));
    }

    public static boolean isNameSuitable(XmlName name2, XmlTag tag, @NotNull DomInvocationHandler handler, XmlFile file) {
        return DomImplUtil.isNameSuitable(handler.createEvaluatedXmlName(name2), tag, file);
    }

    private static boolean isNameSuitable(EvaluatedXmlName evaluatedXmlName, XmlTag tag, XmlFile file) {
        return DomImplUtil.isNameSuitable(evaluatedXmlName, tag.getLocalName(), tag.getName(), tag.getNamespace(), file);
    }

    public static boolean isNameSuitable(EvaluatedXmlName evaluatedXmlName, String localName, String qName, String namespace, XmlFile file) {
        String localName1 = evaluatedXmlName.getXmlName().getLocalName();
        return (localName1.equals(localName) || localName1.equals(qName)) && evaluatedXmlName.isNamespaceAllowed(namespace, file, !localName1.equals(qName));
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name2, Type type, @Nullable JavaMethod javaMethod) {
        Class<?> aClass = DomImplUtil.getErasure(type);
        if (aClass == null) {
            return null;
        }
        String key = DomImplUtil.getNamespaceKey(aClass);
        if (key == null && javaMethod != null) {
            for (Method method : javaMethod.getHierarchy()) {
                String key1 = DomImplUtil.getNamespaceKey(method.getDeclaringClass());
                if (key1 == null) continue;
                return new XmlName(name2, key1);
            }
        }
        return new XmlName(name2, key);
    }

    @Nullable
    private static Class<?> getErasure(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return DomImplUtil.getErasure(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            for (Type bound : ((TypeVariable)type).getBounds()) {
                Class<?> aClass = DomImplUtil.getErasure(bound);
                if (aClass == null) continue;
                return aClass;
            }
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type bound : wildcardType.getUpperBounds()) {
                Class<?> aClass = DomImplUtil.getErasure(bound);
                if (aClass == null) continue;
                return aClass;
            }
        }
        return null;
    }

    @Nullable
    private static String getNamespaceKey(@NotNull Class<?> type) {
        Namespace namespace = (Namespace)DomReflectionUtil.findAnnotationDFS(type, Namespace.class);
        return namespace != null ? namespace.value() : null;
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name2, JavaMethod method) {
        return DomImplUtil.createXmlName(name2, method.getGenericReturnType(), method);
    }

    public static List<XmlTag> getCustomSubTags(DomInvocationHandler handler, XmlTag[] subTags, XmlFile file) {
        if (subTags.length == 0) {
            return Collections.emptyList();
        }
        DomGenericInfoEx info = handler.getGenericInfo();
        THashSet usedNames = new THashSet();
        List collectionChildrenDescriptions = info.getCollectionChildrenDescriptions();
        int size = collectionChildrenDescriptions.size();
        for (int i = 0; i < size; ++i) {
            DomCollectionChildDescription description = (DomCollectionChildDescription)collectionChildrenDescriptions.get(i);
            usedNames.add(description.getXmlName());
        }
        List fixedChildrenDescriptions = info.getFixedChildrenDescriptions();
        int size2 = fixedChildrenDescriptions.size();
        for (int i = 0; i < size2; ++i) {
            DomFixedChildDescription description = (DomFixedChildDescription)fixedChildrenDescriptions.get(i);
            usedNames.add(description.getXmlName());
        }
        return ContainerUtil.findAll((Object[])subTags, arg_0 -> DomImplUtil.lambda$getCustomSubTags$2((Set)usedNames, handler, file, arg_0));
    }

    static XmlFile getFile(DomElement domElement) {
        if (domElement instanceof DomFileElement) {
            return ((DomFileElement)domElement).getFile();
        }
        DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler(domElement);
        assert (handler != null) : domElement;
        while (!(handler instanceof DomRootInvocationHandler)) {
            XmlTag tag = handler.getXmlTag();
            if (tag != null) {
                return DomImplUtil.getContainingFile(tag);
            }
            DomInvocationHandler parent = handler.getParentHandler();
            if (parent == null) {
                throw new AssertionError((Object)("No parent for " + handler.toStringEx()));
            }
            handler = parent;
        }
        return ((DomRootInvocationHandler)handler).getParent().getFile();
    }

    private static XmlFile getContainingFile(XmlTag tag) {
        PsiElement parentTag;
        while ((parentTag = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)tag)) instanceof XmlTag) {
            tag = (XmlTag)parentTag;
        }
        return (XmlFile)tag.getContainingFile();
    }

    private static /* synthetic */ boolean lambda$getCustomSubTags$2(Set usedNames, DomInvocationHandler handler, XmlFile file, XmlTag tag) {
        if (StringUtil.isEmpty((String)tag.getName())) {
            return false;
        }
        for (XmlName name2 : usedNames) {
            if (!DomImplUtil.isNameSuitable(name2, tag, handler, file)) continue;
            return false;
        }
        return true;
    }
}

