/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlFileTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlStructureViewTreeModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementsNavigationManager;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.structure.DomStructureTreeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomStructureViewTreeModel
extends XmlStructureViewTreeModel
implements Disposable {
    private final DomElementNavigationProvider myNavigationProvider;
    private final Function<DomElement, DomService.StructureViewMode> myDescriptor;

    public DomStructureViewTreeModel(@NotNull XmlFile file, @NotNull Function<DomElement, DomService.StructureViewMode> descriptor2, @Nullable Editor editor) {
        this(file, DomElementsNavigationManager.getManager((Project)file.getProject()).getDomElementsNavigateProvider(DomElementsNavigationManager.DEFAULT_PROVIDER_NAME), descriptor2, editor);
    }

    public DomStructureViewTreeModel(@NotNull XmlFile file, DomElementNavigationProvider navigationProvider, @NotNull Function<DomElement, DomService.StructureViewMode> descriptor2, @Nullable Editor editor) {
        super(file, editor);
        this.myNavigationProvider = navigationProvider;
        this.myDescriptor = descriptor2;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        XmlFile myFile = this.getPsiFile();
        DomFileElement fileElement = DomManager.getDomManager((Project)myFile.getProject()).getFileElement(myFile, DomElement.class);
        return fileElement == null ? new XmlFileTreeElement(myFile) : new DomStructureTreeElement(fileElement.getRootElement().createStableCopy(), this.myDescriptor, this.myNavigationProvider);
    }

    protected DomElementNavigationProvider getNavigationProvider() {
        return this.myNavigationProvider;
    }

    public String toString() {
        return super.toString() + "; file: " + this.getPsiFile();
    }
}

