/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.ui.BaseModifiableControl;
import com.intellij.util.xml.ui.DomWrapper;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class EditorTextFieldControl<T extends JComponent>
extends BaseModifiableControl<T, String> {
    private static final JTextField J_TEXT_FIELD = new JTextField(){

        @Override
        public void addNotify() {
            throw new UnsupportedOperationException("Shouldn't be shown");
        }

        @Override
        public void setVisible(boolean aFlag) {
            throw new UnsupportedOperationException("Shouldn't be shown");
        }
    };
    private final boolean myCommitOnEveryChange;
    private final DocumentListener myListener = new DocumentListener(){

        public void documentChanged(@NotNull DocumentEvent e) {
            EditorTextFieldControl.this.setModified();
            if (EditorTextFieldControl.this.myCommitOnEveryChange) {
                EditorTextFieldControl.this.commit();
            }
        }
    };

    protected EditorTextFieldControl(DomWrapper<String> domWrapper, boolean commitOnEveryChange) {
        super(domWrapper);
        this.myCommitOnEveryChange = commitOnEveryChange;
    }

    protected EditorTextFieldControl(DomWrapper<String> domWrapper) {
        this(domWrapper, false);
    }

    protected abstract EditorTextField getEditorTextField(@NotNull T var1);

    protected void doReset() {
        EditorTextField textField = this.getEditorTextField(this.getComponent());
        textField.getDocument().removeDocumentListener(this.myListener);
        super.doReset();
        textField.getDocument().addDocumentListener(this.myListener);
    }

    protected JComponent getComponentToListenFocusLost(T component) {
        return this.getEditorTextField(this.getComponent());
    }

    protected JComponent getHighlightedComponent(T component) {
        return J_TEXT_FIELD;
    }

    protected T createMainComponent(T boundedComponent) {
        Project project2 = this.getProject();
        boundedComponent = this.createMainComponent(boundedComponent, project2);
        EditorTextField editorTextField = this.getEditorTextField(boundedComponent);
        editorTextField.setSupplementary(true);
        editorTextField.getDocument().addDocumentListener(this.myListener);
        return boundedComponent;
    }

    protected abstract T createMainComponent(T var1, Project var2);

    @NotNull
    protected String getValue() {
        return this.getEditorTextField(this.getComponent()).getText();
    }

    protected void setValue(String value) {
        CommandProcessor.getInstance().runUndoTransparentAction(() -> WriteAction.run(() -> {
            JComponent component = this.getComponent();
            Document document2 = this.getEditorTextField(component).getDocument();
            document2.replaceString(0, document2.getTextLength(), (CharSequence)(value == null ? "" : value));
        }));
    }

    protected void updateComponent() {
        DomElement domElement = this.getDomElement();
        if (domElement == null || !domElement.isValid()) {
            return;
        }
        EditorTextField textField = this.getEditorTextField(this.getComponent());
        Project project2 = this.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!project2.isOpen()) {
                return;
            }
            if (!this.getDomWrapper().isValid()) {
                return;
            }
            DomElement domElement1 = this.getDomElement();
            if (domElement1 == null || !domElement1.isValid()) {
                return;
            }
            DomElementAnnotationsManager manager = DomElementAnnotationsManager.getInstance((Project)project2);
            DomElementsProblemsHolder holder = manager.getCachedProblemHolder(domElement1);
            List errorProblems = holder.getProblems(domElement1);
            ArrayList warningProblems = new ArrayList(holder.getProblems(domElement1, true, HighlightSeverity.WARNING));
            warningProblems.removeAll(errorProblems);
            Color background = this.getDefaultBackground();
            if (errorProblems.size() > 0 && textField.getText().trim().length() == 0) {
                background = this.getErrorBackground();
            } else if (warningProblems.size() > 0) {
                background = this.getWarningBackground();
            }
            Editor editor = textField.getEditor();
            if (editor != null) {
                MarkupModel markupModel = editor.getMarkupModel();
                markupModel.removeAllHighlighters();
                if (!errorProblems.isEmpty() && editor.getDocument().getLineCount() > 0) {
                    TextAttributes attributes = SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes();
                    attributes.setEffectType(EffectType.WAVE_UNDERSCORE);
                    attributes.setEffectColor(attributes.getForegroundColor());
                    markupModel.addLineHighlighter(0, 0, attributes);
                    editor.getContentComponent().setToolTipText(((DomElementProblemDescriptor)errorProblems.get(0)).getDescriptionTemplate());
                }
            }
            textField.setBackground(background);
        });
    }

    public boolean canNavigate(DomElement element) {
        return this.getDomElement().equals(element);
    }

    public void navigate(DomElement element) {
        EditorTextField field = this.getEditorTextField(this.getComponent());
        SwingUtilities.invokeLater(() -> {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)field, true));
            field.selectAll();
        });
    }
}

