/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrPathManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + CidrPathManager.class.getPackage().getName()));
    private static File ourCidrRootPath;
    private static final Map<Class, Ref<File>> ourPluginPathsCache;
    private static final Set<File> ourFileWithExecutableUpdated;

    public static File getCidrSourcesRoot() {
        if (ourCidrRootPath == null) {
            ourCidrRootPath = new File(PathManager.getHomePath(), System.getProperty("cidr.root.path", "CIDR"));
        }
        return ourCidrRootPath;
    }

    @NotNull
    public static String getPlatformRelativePath(@NotNull String relativePath) {
        return (SystemInfo.isWindows ? "win/" : (SystemInfo.isMac ? "mac/" : "linux/")) + relativePath;
    }

    @NotNull
    public static File getBinFile(@NotNull Class clazz, @NotNull String inSourcesPath, @NotNull String relativePath, @Nullable String relativePathToAdditionalBinaries) {
        File pluginPath = CidrPathManager.getPluginPath(clazz);
        if (pluginPath != null) {
            File result = CidrPathManager.ensureFileIsExecutable(new File(pluginPath, "bin/" + relativePath));
            if (relativePathToAdditionalBinaries != null) {
                CidrPathManager.ensureFilesInDirAreExecutable(new File(pluginPath, "bin/" + relativePathToAdditionalBinaries));
            }
            return result;
        }
        if (PluginManagerCore.isRunningFromSources()) {
            File result = CidrPathManager.ensureFileIsExecutable(new File(CidrPathManager.getCidrSourcesRoot(), inSourcesPath + "/" + relativePath));
            if (relativePathToAdditionalBinaries != null) {
                CidrPathManager.ensureFilesInDirAreExecutable(new File(CidrPathManager.getCidrSourcesRoot(), inSourcesPath + "/" + relativePathToAdditionalBinaries));
            }
            return result;
        }
        return new File(PathManager.getBinPath(), relativePath);
    }

    private static void ensureFilesInDirAreExecutable(@NotNull File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File each : files) {
                CidrPathManager.ensureFileIsExecutable(each);
            }
        }
    }

    @NotNull
    private static File ensureFileIsExecutable(@NotNull File file) {
        if (!ourFileWithExecutableUpdated.contains(file)) {
            if (file.isFile() && !file.canExecute()) {
                LOG.info("Setting executable flag for " + file);
                if (!file.setExecutable(true)) {
                    LOG.warn("Cannot set executable flag for " + file);
                }
            }
            ourFileWithExecutableUpdated.add(file);
        }
        return file;
    }

    @Nullable
    private static File getPluginPath(@NotNull Class clazz) {
        Ref result = ourPluginPathsCache.get(clazz);
        if (result == null) {
            result = new Ref();
            ClassLoader loader = clazz.getClassLoader();
            if (loader instanceof PluginClassLoader) {
                IdeaPluginDescriptor plugin;
                PluginId id = ((PluginClassLoader)loader).getPluginId();
                IdeaPluginDescriptor ideaPluginDescriptor = plugin = id == null ? null : PluginManager.getPlugin((PluginId)id);
                if (plugin != null) {
                    result.set((Object)plugin.getPath());
                }
            }
            ourPluginPathsCache.putIfAbsent(clazz, (Ref<File>)result);
        }
        return (File)result.get();
    }

    static {
        ourPluginPathsCache = new ConcurrentHashMap<Class, Ref<File>>();
        ourFileWithExecutableUpdated = ContainerUtil.newConcurrentSet();
    }
}

