/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.SavingRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class FilesModificationsListener {
    public FilesModificationsListener install(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        project2.getMessageBus().connect(parentDisposable).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Set<File> watchedFiles = FilesModificationsListener.this.getWatchedFiles();
                THashSet structurallyChangedFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                THashSet filesWithContentChanges = new THashSet();
                boolean externalChange = false;
                boolean fromSave = false;
                for (VFileEvent vFileEvent : events) {
                    VFilePropertyChangeEvent propEvent;
                    File recreatedFile = null;
                    File changedFile = null;
                    externalChange |= vFileEvent.isFromRefresh();
                    fromSave |= vFileEvent.getRequestor() instanceof SavingRequestor;
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        changedFile = new File(vFileEvent.getPath());
                    } else if (vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileCreateEvent) {
                        changedFile = new File(vFileEvent.getPath());
                    } else if (vFileEvent instanceof VFileCopyEvent) {
                        VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                        recreatedFile = new File(copyEvent.getNewParent().getPath(), copyEvent.getNewChildName());
                    } else if (vFileEvent instanceof VFileMoveEvent) {
                        changedFile = new File(((VFileMoveEvent)vFileEvent).getOldParent().getPath(), vFileEvent.getFile().getName());
                        recreatedFile = new File(vFileEvent.getPath());
                    } else if (vFileEvent instanceof VFilePropertyChangeEvent && (propEvent = (VFilePropertyChangeEvent)vFileEvent).getPropertyName() == "name") {
                        changedFile = new File(new File(vFileEvent.getPath()).getParentFile(), (String)((VFilePropertyChangeEvent)vFileEvent).getOldValue());
                        recreatedFile = new File(vFileEvent.getPath());
                    }
                    if (changedFile == null && recreatedFile == null) continue;
                    for (File eachWatchedFile : watchedFiles) {
                        if (changedFile != null && FileUtil.isAncestor((File)changedFile, (File)eachWatchedFile, (boolean)false)) {
                            if (vFileEvent instanceof VFileContentChangeEvent) {
                                ContainerUtil.addIfNotNull((Collection)filesWithContentChanges, (Object)vFileEvent.getFile());
                            } else {
                                structurallyChangedFiles.add(eachWatchedFile);
                            }
                        }
                        if (recreatedFile == null || !FileUtil.isAncestor((File)recreatedFile, (File)eachWatchedFile, (boolean)false) || !eachWatchedFile.exists()) continue;
                        structurallyChangedFiles.add(eachWatchedFile);
                    }
                }
                if (!structurallyChangedFiles.isEmpty() || !filesWithContentChanges.isEmpty()) {
                    FilesModificationsListener.this.watchedFilesChanged((Set<File>)structurallyChangedFiles, (Set<VirtualFile>)filesWithContentChanges, externalChange, fromSave);
                }
            }
        });
        return this;
    }

    @NotNull
    protected abstract Set<File> getWatchedFiles();

    protected abstract void watchedFilesChanged(@NotNull Set<File> var1, @NotNull Set<VirtualFile> var2, boolean var3, boolean var4);
}

