/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.doxygen.DxEnterInBlockCommentHandler;
import com.jetbrains.cidr.doxygen.DxLanguage;
import com.jetbrains.cidr.lang.editor.OCEnterInBlockCommentHandler;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class DxEnterInLineCommentHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        PsiElement psiAtOffset;
        Language language = EnterHandler.getLanguage((DataContext)dataContext);
        if (!(language instanceof DxLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiFile topFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        Editor topEditor = InjectedLanguageUtil.getTopLevelEditor((Editor)editor);
        int caretOffset = topEditor.getCaretModel().getOffset();
        if (topFile == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document2 = topEditor.getDocument();
        PsiDocumentManager.getInstance((Project)topFile.getProject()).commitDocument(document2);
        PsiElement element = topFile.findElementAt(caretOffset);
        PsiElement psiElement = psiAtOffset = element instanceof PsiWhiteSpace ? element.getPrevSibling() : element;
        if (this.shouldBeProcessed(document2, psiAtOffset, caretOffset)) {
            String text = document2.getText();
            if (psiAtOffset instanceof PsiComment && DoxygenUtil.isDoxygenEOLComment(psiAtOffset.getText())) {
                PsiComment comment = (PsiComment)psiAtOffset;
                String commentText = comment.getText();
                String prefix = OCEnterInBlockCommentHandler.getFirstCommentLineIndentFromContext(topEditor, caretOffset) + commentText.substring(0, 3);
                int caretInComment = caretOffset - comment.getTextRange().getStartOffset();
                StringBuilder result = new StringBuilder();
                Project project2 = topEditor.getProject();
                if (project2 == null) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                int newCaretPosition = caretOffset;
                if (commentText.length() == 3 && !DoxygenUtil.hasNextDocCommentSibling(comment) && comment instanceof PsiDocCommentBase) {
                    PsiElement owner2 = ((PsiDocCommentBase)comment).getOwner();
                    String tagPrefix = DxEnterInLineCommentHandler.getTagPrefix(topFile);
                    result.append(DxEnterInBlockCommentHandler.addBriefIfNeeded(topEditor, tagPrefix));
                    newCaretPosition += result.length();
                    DxEnterInBlockCommentHandler.generateDocComment(owner2, prefix, tagPrefix, result);
                    if (result.length() != 0) {
                        result.insert(0, ' ');
                        ++newCaretPosition;
                    }
                } else if (DxEnterInBlockCommentHandler.countWS(commentText, caretInComment) < commentText.length()) {
                    result.append("\n").append(prefix);
                    if (DoxygenUtil.hasArrow(comment)) {
                        result.append("<");
                    }
                    if (text.charAt(caretOffset) != ' ') {
                        result.append(" ");
                    } else {
                        ++newCaretPosition;
                    }
                    newCaretPosition += result.length();
                } else {
                    return EnterHandlerDelegate.Result.Continue;
                }
                if (result.length() == 0) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                document2.insertString(caretOffset, (CharSequence)result.toString());
                topEditor.getCaretModel().moveToOffset(newCaretPosition);
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected boolean shouldBeProcessed(Document document2, PsiElement psiAtOffset, int caretOffset) {
        return psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset && caretOffset < document2.getTextLength() && OCElementUtil.getElementType(psiAtOffset.getParent()) != OCElementTypes.PRAGMA && OCElementUtil.getElementType(PsiTreeUtil.skipWhitespacesBackward((PsiElement)psiAtOffset)) != OCElementTypes.DIRECTIVE;
    }

    private static String getTagPrefix(@NotNull PsiFile refFile) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)refFile, OCCodeStyleSettings.class);
        return settings.TAG_PREFIX_OF_LINE_COMMENT == OCCodeStyleSettings.DocTagPrefix.AT ? "@" : "\\";
    }
}

