/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.doxygen.DoxygenLexerAdapter;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import org.jetbrains.annotations.NotNull;

public class DxSyntaxHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey COMMENT_TEXT = TextAttributesKey.createTextAttributesKey((String)"Doxygen Comment", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT);
    public static final TextAttributesKey TAG_NAME = TextAttributesKey.createTextAttributesKey((String)"Doxygen Tag", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT_TAG);
    public static final TextAttributesKey TAG_PARAM = TextAttributesKey.createTextAttributesKey((String)"Doxygen Parameter", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT_TAG_VALUE);
    private static final TextAttributesKey[] TAG_NAME_KEYS = DxSyntaxHighlighter.pack((TextAttributesKey)TAG_NAME, (TextAttributesKey)COMMENT_TEXT);
    private static final TextAttributesKey[] TAG_PARAM_KEYS = DxSyntaxHighlighter.pack((TextAttributesKey)TAG_PARAM, (TextAttributesKey)COMMENT_TEXT);
    private static final TextAttributesKey[] COMMENT_TEXT_KEYS = DxSyntaxHighlighter.pack((TextAttributesKey)COMMENT_TEXT);

    @NotNull
    public Lexer getHighlightingLexer() {
        return new DoxygenLexerAdapter();
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType.equals(DxTypes.TAG_NAME)) {
            return TAG_NAME_KEYS;
        }
        if (tokenType.equals(DxTypes.TAG_PARAM)) {
            return TAG_PARAM_KEYS;
        }
        return COMMENT_TEXT_KEYS;
    }
}

