/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DxCommentProcessorUtil {
    @NotNull
    public static List<PsiComment> getCommentScope(@NotNull PsiElement elt) {
        List<PsiComment> comments = DxCommentProcessorUtil.findOCCommentForElementInternal(elt);
        return comments;
    }

    @NotNull
    public static List<PsiComment> findOCCommentFor(@Nullable PsiElement element) {
        List<PsiComment> comments = DxCommentProcessorUtil.findOCCommentForElementInternal(element);
        if (comments.size() == 0 && element instanceof OCSymbolDeclarator) {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            Project project2 = element.getProject();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol(project2);
            }
            if (symbol != null) {
                PsiElement associatedElement = symbol.locateDefinition(project2);
                return DxCommentProcessorUtil.findOCCommentForElementInternal(associatedElement);
            }
        }
        return comments;
    }

    @NotNull
    private static List<PsiComment> findOCCommentForElementInternal(@Nullable PsiElement elt) {
        if (elt instanceof OCDeclarator) {
            elt = elt.getParent();
        }
        if (elt instanceof OCStructLike) {
            elt = PsiTreeUtil.findFirstParent((PsiElement)elt, p -> p instanceof OCDeclaration);
        }
        if (elt == null) {
            return Collections.emptyList();
        }
        if (elt.getParent() instanceof OCProperty) {
            elt = elt.getParent();
        }
        if (elt.getParent() instanceof OCDeclarationStatement) {
            elt = elt.getParent();
        }
        if (elt.getContainingFile() == null) {
            return Collections.emptyList();
        }
        LinkedList<PsiComment> comments = new LinkedList<PsiComment>();
        DxCommentProcessorUtil.findPrevComments(elt, comments);
        DxCommentProcessorUtil.findInnerComments(elt, comments);
        DxCommentProcessorUtil.findNextComments(elt, comments);
        return comments;
    }

    private static void findPrevComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        PsiElement initElement = elt.getFirstChild();
        for (PsiElement element = elt.getPrevSibling(); element != null; element = element.getPrevSibling()) {
            if (element instanceof PsiWhiteSpace || element instanceof OCMacroCall) continue;
            if (!(element instanceof PsiComment)) break;
            initElement = element;
        }
        if (initElement != null) {
            ArrayList<PsiComment> allComments = new ArrayList<PsiComment>();
            ArrayList<PsiComment> withArrow = new ArrayList<PsiComment>();
            DxCommentProcessorUtil.findNextCommentsInternal(initElement, allComments, false);
            DxCommentProcessorUtil.findNextCommentsInternal(initElement, withArrow, true);
            allComments.removeAll(withArrow);
            for (PsiComment comment : allComments) {
                if (!DoxygenUtil.isDoxygenComment(comment)) continue;
                comments.add(comment);
            }
        }
    }

    private static void findInnerComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        if (elt instanceof OCClassDeclaration || elt instanceof OCMethod) {
            return;
        }
        ArrayList<PsiComment> firstComments = new ArrayList<PsiComment>();
        DxCommentProcessorUtil.findNextCommentsInternal(elt.getFirstChild(), firstComments, false);
        List innerComments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)elt, PsiComment.class);
        innerComments.removeAll(firstComments);
        for (PsiComment comment : innerComments) {
            if (!DoxygenUtil.isDoxygenComment(comment)) continue;
            comments.add(comment);
        }
    }

    private static void findNextComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        if (elt instanceof OCParameterDeclaration || elt.getParent() instanceof OCEnum) {
            DxCommentProcessorUtil.findNextCommentsForCommaSeparatedSequence(elt, comments);
        } else {
            DxCommentProcessorUtil.findNextCommentsInternal(elt.getNextSibling(), comments, true);
        }
    }

    private static void findNextCommentsInternal(@Nullable PsiElement elt, List<PsiComment> comments, boolean onlyDoxygen) {
        if (elt == null) {
            return;
        }
        for (PsiElement next = elt; next != null; next = next.getNextSibling()) {
            if (next instanceof PsiWhiteSpace) continue;
            if (next instanceof PsiComment) {
                PsiComment comment = (PsiComment)next;
                if (!onlyDoxygen) {
                    comments.add(comment);
                    continue;
                }
                if (!DoxygenUtil.isDoxygenComment(comment) || !DoxygenUtil.hasArrow(comment)) break;
                if (DoxygenUtil.isDoxygenEOLComment(comment.getText())) {
                    EOLCommentPack pack = new EOLCommentPack(comment);
                    comments.addAll(pack.getComments());
                    next = pack.getLastComment();
                    continue;
                }
                comments.add(comment);
                continue;
            }
            if (!(next instanceof OCDeclaration) && !DxCommentProcessorUtil.isOCDeclaration(next)) break;
            DxCommentProcessorUtil.findNextCommentsInternal(next.getFirstChild(), comments, onlyDoxygen);
            break;
        }
    }

    private static void findNextCommentsForCommaSeparatedSequence(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        boolean waitForArrow = false;
        for (PsiElement next = elt.getNextSibling(); next != null; next = next.getNextSibling()) {
            PsiComment comment;
            if (next instanceof PsiWhiteSpace) continue;
            if (next instanceof LeafElement && ((LeafElement)next).getElementType() == OCTokenTypes.COMMA) {
                waitForArrow = true;
                continue;
            }
            if (!(next instanceof PsiComment) || !DoxygenUtil.isDoxygenComment(comment = (PsiComment)next) || waitForArrow && !DoxygenUtil.hasArrow(comment)) break;
            if (DoxygenUtil.isDoxygenEOLComment(comment.getText())) {
                EOLCommentPack pack = new EOLCommentPack(comment);
                comments.addAll(pack.getComments());
                next = pack.getLastComment();
                continue;
            }
            comments.add(comment);
        }
    }

    private static boolean isOCDeclaration(@NotNull PsiElement elt) {
        return elt instanceof OCMethod || elt instanceof OCClassDeclaration || elt instanceof OCProperty || elt instanceof OCMethodSelectorPart;
    }

    private static class EOLCommentPack {
        private final List<PsiComment> comments = new ArrayList<PsiComment>();

        EOLCommentPack(@NotNull PsiComment EOLComment) {
            assert (DoxygenUtil.isDoxygenEOLComment(EOLComment.getText()));
            this.comments.add(EOLComment);
            EOLCommentPack.processEOLCommentPack(EOLComment, this.comments);
        }

        public List<PsiComment> getComments() {
            return this.comments;
        }

        @NotNull
        public PsiComment getLastComment() {
            assert (this.comments.size() > 0);
            return this.comments.get(this.comments.size() - 1);
        }

        private static void processEOLCommentPack(@NotNull PsiComment EOLComment, @NotNull List<PsiComment> pack) {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)EOLComment.getProject());
            Document document2 = manager.getDocument(EOLComment.getContainingFile());
            if (document2 == null) {
                return;
            }
            int startOffset = EOLComment.getTextOffset();
            int lineStartOffset = startOffset - document2.getLineStartOffset(document2.getLineNumber(startOffset));
            for (PsiElement next = EOLComment.getNextSibling(); next != null; next = next.getNextSibling()) {
                if (next instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)next.getText()) == 1) continue;
                if (next instanceof PsiComment) {
                    if (!EOLCommentPack.processEOLComment((PsiComment)next, document2, lineStartOffset, pack)) break;
                    continue;
                }
                if (!(next instanceof OCDeclaration) && !DxCommentProcessorUtil.isOCDeclaration(next)) break;
                for (PsiElement innerElement = next.getFirstChild(); innerElement != null && (innerElement instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)innerElement.getText()) == 1 || innerElement instanceof PsiComment && EOLCommentPack.processEOLComment((PsiComment)innerElement, document2, lineStartOffset, pack)); innerElement = innerElement.getNextSibling()) {
                }
                break;
            }
        }

        private static boolean processEOLComment(@NotNull PsiComment comment, @NotNull Document document2, int offset, @NotNull List<PsiComment> pack) {
            int startOffset;
            int lineStartOffset;
            if (DoxygenUtil.isDoxygenEOLComment(comment.getText()) && offset == (lineStartOffset = (startOffset = comment.getTextOffset()) - document2.getLineStartOffset(document2.getLineNumber(startOffset)))) {
                pack.add(comment);
                return true;
            }
            return false;
        }
    }
}

