/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.DxFileType;
import com.jetbrains.cidr.doxygen.psi.DxDocComment;
import com.jetbrains.cidr.doxygen.psi.DxFile;
import com.jetbrains.cidr.doxygen.psi.DxParamId;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import org.jetbrains.annotations.Nullable;

public class DxElementFactory {
    private static final String FILE_NAME = "DUMMY." + DxFileType.INSTANCE.getDefaultExtension();

    @Nullable
    public static ASTNode createParamNode(Project project2, String text) {
        DxDocComment comment = DxElementFactory.createComment(project2, "//! @param " + text);
        PsiElement paramId = PsiTreeUtil.findChildOfType((PsiElement)comment, DxParamId.class);
        if (paramId != null) {
            return paramId.getNode().findChildByType(DxTypes.TAG_PARAM);
        }
        return null;
    }

    public static DxDocComment createComment(Project project2, String text) {
        DxFile file = DxElementFactory.createDummyFile(project2, false, text);
        return (DxDocComment)file.getFirstChild();
    }

    private static DxFile createDummyFile(Project project2, boolean physical, CharSequence text) {
        long stamp = System.currentTimeMillis();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        return (DxFile)factory.createFileFromText(FILE_NAME, (FileType)DxFileType.INSTANCE, text, stamp, physical);
    }
}

