/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.doxygen.psi.DxParam;
import com.jetbrains.cidr.doxygen.psi.DxParamId;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DxPsiImplUtil {
    public static final String UNKNOWN = "<unknown>";

    @NotNull
    public static String getName(@NotNull DxDocTag docTag) {
        String name2 = DxPsiImplUtil.getOriginalName(docTag);
        name2 = StringUtil.trimStart((String)name2, (String)"\\");
        int idx = (name2 = StringUtil.trimStart((String)name2, (String)"@")).indexOf(123);
        if (idx != -1) {
            name2 = name2.substring(0, idx);
        }
        return name2;
    }

    @NotNull
    public static String getOriginalName(@NotNull DxDocTag docTag) {
        ASTNode tagName = docTag.getNode().findChildByType(DxTypes.TAG_NAME);
        return tagName != null ? tagName.getText() : UNKNOWN;
    }

    @NotNull
    public static String getName(@NotNull DxParamId element) {
        return element.getText();
    }

    @NotNull
    public static PsiElement setName(@NotNull DxParamId element, @NotNull String newName) {
        ASTNode node = element.getNode().findChildByType(DxTypes.TAG_PARAM);
        if (node instanceof LeafElement) {
            ((LeafElement)node).replaceWithText(newName);
            return element;
        }
        throw new IncorrectOperationException();
    }

    @Nullable
    public static PsiElement getNameIdentifier(@NotNull DxParamId element) {
        ASTNode node = element.getNode().findChildByType(DxTypes.TAG_PARAM);
        return node != null ? node.getPsi() : null;
    }

    @NotNull
    public static List<String> getOptions(@NotNull PsiElement element) {
        ASTNode tagName = element.getNode().findChildByType(DxTypes.TAG_OPTION);
        if (tagName != null) {
            return DxPsiImplUtil.extractOptions(tagName);
        }
        return Collections.emptyList();
    }

    public static List<String> extractOptions(@NotNull ASTNode tagName) {
        String text = tagName.getText().trim();
        text = StringUtil.substringAfter((String)text, (String)"[");
        text = StringUtil.substringBefore((String)text, (String)"]");
        List<String> result = StringUtil.split((String)text, (String)",").stream().map(s -> {
            if ((s = s.trim()).startsWith("*")) {
                s = StringUtil.substringAfter((String)s, (String)"*");
            }
            if (s.endsWith("*")) {
                s = StringUtil.substringBefore((String)s, (String)"*");
            }
            return s.trim();
        }).collect(Collectors.toList());
        return result;
    }

    public static String getName(@NotNull DxParam element) {
        DxParamId id;
        boolean hasEllipsis = element.getNode().findChildByType(DxTypes.ELLIPSIS) != null;
        String name2 = "";
        if (hasEllipsis) {
            name2 = "...";
        }
        if ((id = element.getParamId()) != null) {
            name2 = name2 + id.getName();
        }
        return name2;
    }
}

