/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrBuildConfigurationHelper<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>> {
    @NotNull
    public String getTargetTitle() {
        return CidrBundle.message("build.configuration.target", new Object[0]);
    }

    @NotNull
    public String getConfigurationTitle() {
        return CidrBundle.message("build.configuration.configuration", new Object[0]);
    }

    public boolean allowEditBuildConfiguration() {
        return true;
    }

    public boolean hasTargetsInSeveralProjects() {
        return false;
    }

    @NotNull
    public abstract List<TARGET> getTargets();

    @NotNull
    public List<BC> getConfigurations(@Nullable TARGET target) {
        return target == null ? Collections.emptyList() : target.getBuildConfigurations();
    }

    @Nullable
    public abstract BC getDefaultConfiguration(@Nullable TARGET var1);

    @NotNull
    public abstract List<? extends TARGET> getRunTargets();

    @Nullable
    public abstract TARGET findRunTarget(@Nullable BuildTargetData var1);

    @Nullable
    public TARGET findTarget(@Nullable BuildTargetData targetData) {
        return this.findTarget(targetData, this.getTargets());
    }

    @Contract(value="null, _ -> null")
    public abstract <T extends TARGET> T findTarget(@Nullable BuildTargetData var1, @NotNull List<T> var2);

    @Nullable
    public abstract BC findConfiguration(@Nullable TARGET var1, @Nullable String var2);

    @Nullable
    public TARGET getDefaultTarget() {
        return (TARGET)((CidrBuildTarget)ContainerUtil.getFirstItem(this.getTargets()));
    }

    @Nullable
    public TARGET findFirstSuitableTarget(@Nullable String targetName) {
        return CidrBuildConfigurationHelper.findFirstSuitableTarget(this.getTargets(), targetName);
    }

    @Contract(value="_, null -> null")
    public static <T extends CidrBuildTarget> T findFirstSuitableTarget(@NotNull List<T> targets, @Nullable String targetName) {
        if (targetName == null) {
            return null;
        }
        for (CidrBuildTarget each : targets) {
            if (!each.getName().equals(targetName)) continue;
            return (T)each;
        }
        return null;
    }

    @Nullable
    public abstract BuildTargetAndConfigurationData findSimilarValidInTargets(@Nullable TARGET var1, @Nullable BC var2, @NotNull List<TARGET> var3);

    public static boolean isTargetDetectionEnabled() {
        return Registry.is((String)"cidr.test.framework.targetTypeFromHeaderDetectionEnable");
    }

    public static boolean setTargetDetection(boolean value) {
        boolean oldValue = CidrBuildConfigurationHelper.isTargetDetectionEnabled();
        Registry.get((String)"cidr.test.framework.targetTypeFromHeaderDetectionEnable").setValue(value);
        return oldValue;
    }
}

