/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.ExecutionResult;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrExecUtil {
    private static final int ERROR_MESSAGE_WRAP_LENGTH = 80;

    @NotNull
    public static Map<String, String> appendBuildPathVars(@NotNull Map<String, String> env, @Nullable String buildPath) {
        CidrExecUtil.appendSearchPath(env, "DYLD_LIBRARY_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "DYLD_FRAMEWORK_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "__XPC_DYLD_LIBRARY_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "__XPC_DYLD_FRAMEWORK_PATH", buildPath);
        return env;
    }

    public static void setIfAbsent(@NotNull Map<String, String> env, @NotNull String paramName, @Nullable String value) {
        if (value != null && !env.containsKey(paramName)) {
            env.put(paramName, value);
        }
    }

    public static void appendSearchPath(@NotNull Map<String, String> env, @NotNull String paramName, @Nullable String appendPath) {
        if (appendPath == null) {
            return;
        }
        String result = env.get(paramName);
        result = result != null ? result + File.pathSeparator + appendPath : appendPath;
        env.put(paramName, result);
    }

    public static void checkErrorOnTermination(@NotNull StringBuilder errOut, @NotNull ExecutionResult<?> result) {
        if (result.isDone()) {
            return;
        }
        String error = errOut.toString();
        ExecutionException ex = null;
        if (!StringUtil.isEmptyOrSpaces((String)error)) {
            ex = new ExecutionException(error);
        }
        result.setException((Throwable)new ExecutionFinishedException((Throwable)ex));
    }

    public static String wrapErrorOutput(@NotNull String str) {
        return CidrExecUtil.wrapErrorOutput(str, 80);
    }

    public static String wrapErrorOutput(@NotNull String str, int wrapLen) {
        String[] lines = StringUtil.splitByLinesKeepSeparators((String)str);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            StringTokenizer st = new StringTokenizer(lines[i], " \n\r");
            if (st.hasMoreTokens()) {
                String word = st.nextToken();
                result.append(word);
                int lineLen = word.length();
                while (st.hasMoreTokens()) {
                    word = st.nextToken();
                    int wordLen = word.length();
                    if (lineLen + wordLen > wrapLen) {
                        result.append('\n');
                        lineLen = wordLen;
                    } else {
                        result.append(' ');
                        lineLen += wordLen + 1;
                    }
                    result.append(word);
                }
            }
            if (i >= lines.length - 1) continue;
            result.append('\n');
        }
        return result.toString();
    }
}

