/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugProcessConfiguratorStarter;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.statistics.CidrTestingFrameworkUsagesCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRunner
extends DefaultProgramRunner {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
        if (profile2 instanceof RunConfigurationWithSuppressedDefaultRunAction && DefaultRunExecutor.EXECUTOR_ID.equals(executorId)) {
            return false;
        }
        if (profile2 instanceof RunConfigurationWithSuppressedDefaultDebugAction && DefaultDebugExecutor.EXECUTOR_ID.equals(executorId)) {
            return false;
        }
        return profile2 instanceof CidrRunProfile;
    }

    protected static void triggerUsage(@Nullable RunnerAndConfigurationSettings configuration) {
        RunConfiguration runConfiguration;
        String frameworkId;
        if (configuration != null && (frameworkId = CidrTestingFrameworkUsagesCollector.getFrameworkId(runConfiguration = configuration.getConfiguration())) != null) {
            FUCounterUsageLogger.getInstance().logEvent(runConfiguration.getProject(), "cidr.testingFrameworks.usages", frameworkId);
        }
    }

    public XDebugSession startDebugSession(final CidrCommandLineState state, ExecutionEnvironment env, final boolean muteBreakpoints, final XDebugSessionListener ... listeners) throws ExecutionException {
        XDebugSession session = XDebuggerManager.getInstance((Project)env.getProject()).startSession(env, (XDebugProcessStarter)new XDebugProcessConfiguratorStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                for (XDebugSessionListener l : listeners) {
                    session.addSessionListener(l);
                }
                return state.startDebugProcess(session);
            }

            public void configure(XDebugSessionData data) {
                if (muteBreakpoints) {
                    data.setBreakpointsMuted(true);
                }
            }
        });
        CidrRunner.configureDebugSessionUI(session);
        return session;
    }

    private static void configureDebugSessionUI(@NotNull XDebugSession session) {
        RunnerLayoutUi runnerLayoutUi;
        ConsoleView consoleView = session.getConsoleView();
        if (consoleView instanceof ConsoleViewWrapperBase && (runnerLayoutUi = session.getUI()) != null) {
            ((ExecutionConsoleEx)consoleView).buildUi(runnerLayoutUi);
        }
    }
}

