/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.pty4j.windows.CygwinPTYInputStream;
import com.pty4j.windows.CygwinPTYOutputStream;
import com.pty4j.windows.NamedPipe;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class WinPipe {
    private static final Kernel32 KERNEL32 = (Kernel32)Native.loadLibrary((String)"kernel32", Kernel32.class);
    private static final int PIPE_ACCESS_INBOUND = 1;
    private static final int PIPE_ACCESS_OUTBOUND = 2;
    private static final AtomicInteger ourProcessCounter = new AtomicInteger();
    private final NamedPipe myNamedPipe;
    private final WinNT.HANDLE myHandle;
    private final String myPipeName;

    private WinPipe(int pipeDirectionFlag, @NotNull String nameSuffix) throws IOException {
        this.myPipeName = String.format("\\\\.\\pipe\\cidr-%d-%d-", KERNEL32.GetCurrentProcessId(), ourProcessCounter.getAndIncrement()) + nameSuffix;
        this.myHandle = KERNEL32.CreateNamedPipeA(this.myPipeName, pipeDirectionFlag | 0x40000000, 0, 1, 0, 0, 0, null);
        if (this.myHandle == WinBase.INVALID_HANDLE_VALUE) {
            KERNEL32.CloseHandle(this.myHandle);
            throw new IOException("Unable to create a named pipe");
        }
        this.myNamedPipe = new NamedPipe(this.myHandle, false);
    }

    @NotNull
    public static WinPipe createOutboundPipe(@NotNull String nameSuffix) throws IOException {
        return new WinPipe(2, nameSuffix);
    }

    @NotNull
    public static WinPipe createInboundPipe(@NotNull String nameSuffix) throws IOException {
        return new WinPipe(1, nameSuffix);
    }

    @NotNull
    public String getPipeName() {
        return this.myPipeName;
    }

    public InputStream getInputStream() {
        return new CygwinPTYInputStream(this.myNamedPipe);
    }

    public OutputStream getOutputStream() {
        return new CygwinPTYOutputStream(this.myNamedPipe);
    }

    public void close() throws IOException {
        if (!KERNEL32.CloseHandle(this.myHandle)) {
            throw new IOException("Unable to close named pipe: " + this.getPipeName());
        }
    }

    static interface Kernel32
    extends Library {
        public WinNT.HANDLE CreateNamedPipeA(String var1, int var2, int var3, int var4, int var5, int var6, int var7, WinBase.SECURITY_ATTRIBUTES var8);

        public boolean CloseHandle(WinNT.HANDLE var1);

        public int GetCurrentProcessId();
    }
}

