/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildEvent;
import com.jetbrains.cidr.execution.build.CidrBuildId;
import com.jetbrains.cidr.execution.build.CidrBuildListener;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.execution.build.CidrBuildTaskType;
import com.jetbrains.cidr.lang.OCLog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBuild {
    private static final NotificationGroup LOG_NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)CidrBundle.message("build.log.notification.group.name", new Object[0]));

    public static ExecutionResult<CidrBuildResult> execute(@NotNull Project project2, final @NotNull BuildContext context, @NotNull Runnable doExecute2) {
        final Object processCreationLock = new Object();
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            context.indicator = new EmptyProgressIndicator();
        } else {
            final ExecutionResult indicatorResult = new ExecutionResult();
            UIUtil.invokeLaterIfNeeded(() -> new Task.Backgroundable(project2, context.taskName, true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    indicatorResult.set(indicator);
                    boolean wasCanceled = false;
                    while (!context.myResult.isDone()) {
                        if (!wasCanceled && indicator.isCanceled()) {
                            wasCanceled = true;
                            Object object = processCreationLock;
                            synchronized (object) {
                                ProcessHandler process2 = context.processHandler;
                                if (process2 != null) {
                                    process2.destroyProcess();
                                }
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            throw new ProcessCanceledException((Throwable)e);
                        }
                    }
                }
            }.queue());
            try {
                context.indicator = (ProgressIndicator)indicatorResult.get();
                context.indicator.setText(context.progressTitle);
                context.indicator.setText2("");
            }
            catch (ExecutionException e) {
                context.myResult.setException(e);
                return context.myResult;
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!context.waitAndStart()) {
                return;
            }
            TransactionGuard.submitTransaction((Disposable)project2, () -> {
                Object object = processCreationLock;
                synchronized (object) {
                    if (context.indicator.isCanceled()) {
                        context.canceled();
                        return;
                    }
                    MessageView.SERVICE.getInstance((Project)project2);
                    FileDocumentManager.getInstance().saveAllDocuments();
                    doExecute2.run();
                }
            });
        });
        return context.myResult;
    }

    public static void startProcess(final @NotNull Project project2, final BuildContext context, final Collection<File> toRefresh) {
        context.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                context.indicator.setText(CidrBundle.message("build.refreshing", new Object[0]));
                context.indicator.setText2("");
                CidrBuild.refreshFiles(project2, toRefresh, () -> {
                    MessageType messageType;
                    if (project2.isDisposed()) {
                        return;
                    }
                    boolean buildSucceeded = event.getExitCode() == 0;
                    boolean canceled = context2.indicator.isCanceled();
                    context2.duration = System.currentTimeMillis() - context2.started;
                    if (canceled) {
                        messageType = MessageType.INFO;
                        context2.finishMessage = CidrBundle.message("build.canceled", context2.taskName);
                    } else {
                        boolean hasWarningsOrErrors;
                        boolean bl = hasWarningsOrErrors = context2.errors > 0 || context2.warnings > 0;
                        messageType = !buildSucceeded ? MessageType.ERROR : (hasWarningsOrErrors ? MessageType.WARNING : MessageType.INFO);
                        context2.finishMessage = buildSucceeded ? CidrBundle.message("build.finished", context2.taskName) : CidrBundle.message("build.failed", context2.taskName);
                        context2.finishDetails = hasWarningsOrErrors ? CidrBundle.message("build.details", context2.errors, context2.warnings) : null;
                    }
                    String fullMessage = CidrBuild.buildNotificationMessage(context2.finishMessage, context2.finishDetails, context2.duration);
                    CidrBuildResult buildResult = new CidrBuildResult(buildSucceeded, canceled, context2.started, context2.duration, context2.errors, context2.warnings, fullMessage);
                    context.finished(buildResult);
                    CidrBuild.showBuildNotification(project2, messageType, context2.finishMessage, context2.finishDetails, context2.duration);
                });
            }
        });
        ((CidrBuildListener)project2.getMessageBus().syncPublisher(CidrBuildListener.TOPIC)).beforeStarted(new CidrBuildEvent(context.buildConfiguration, context.taskType, context.id));
        context.processHandler.startNotify();
    }

    public static void refreshFiles(@NotNull Project project2, @NotNull Collection<File> files, @NotNull Runnable onFinish) {
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile[] virtualFiles = (VirtualFile[])ContainerUtil.map2Array((Collection)files, VirtualFile.class, each -> VfsUtil.findFileByIoFile((File)each, (boolean)true));
            List dirs = VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])virtualFiles);
            if (dirs.isEmpty()) {
                onFinish.run();
                return;
            }
            RefreshQueue.getInstance().refresh(true, true, onFinish, (Collection)dirs);
        }, ModalityState.NON_MODAL, project2.getDisposed());
    }

    @NotNull
    private static String buildNotificationMessage(@NotNull String message, @Nullable String details, long time) {
        String notificationContent = message + (details == null ? "" : " with " + details);
        if (time > 0L) {
            notificationContent = notificationContent + " in " + StringUtil.formatDuration((long)time);
        }
        return notificationContent;
    }

    public static String showBuildNotification(@NotNull Project project2, @NotNull MessageType messageType, @NotNull String message) {
        return CidrBuild.showBuildNotification(project2, messageType, message, null, 0L);
    }

    public static String showBuildNotification(@NotNull Project project2, @NotNull MessageType messageType, @NotNull String message, @Nullable String details, long time) {
        MessageView.SERVICE.getInstance((Project)project2);
        return CidrBuild.showBuildNotification(project2, ToolWindowId.MESSAGES_WINDOW, messageType, message, details, time);
    }

    public static String showBuildNotification(@NotNull Project project2, @NotNull String balloonToolWindow, @NotNull MessageType messageType, @NotNull String message, @Nullable String details, long time) {
        String notificationContent = CidrBuild.buildNotificationMessage(message, details, time);
        Notification notification = LOG_NOTIFICATION_GROUP.createNotification(notificationContent, messageType);
        notification.notify(project2);
        if (messageType == MessageType.ERROR) {
            String balloonToolWindowId;
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)project2);
            ToolWindow toolWindow = manager.getToolWindow(balloonToolWindow);
            if (toolWindow == null) {
                MessageView.SERVICE.getInstance((Project)project2);
                balloonToolWindowId = ToolWindowId.MESSAGES_WINDOW;
            } else {
                balloonToolWindowId = balloonToolWindow;
            }
            ApplicationManager.getApplication().invokeLater(() -> manager.notifyByBalloon(balloonToolWindowId, messageType, notificationContent));
        }
        SystemNotifications.getInstance().notify(notification.getGroupId(), StringUtil.capitalizeWords((String)message, (boolean)true), StringUtil.notNullize((String)details));
        return notificationContent;
    }

    static Pair<AnAction, Disposable> initializeBuildLog(@NotNull BuildContext context, @NotNull String logName) {
        File file = null;
        FileWriter writer = null;
        try {
            file = FileUtil.createTempFile((String)logName, (String)".log", (boolean)true);
            writer = new FileWriter(file);
        }
        catch (IOException e) {
            OCLog.LOG.error("Cannot create build log file", (Throwable)e);
        }
        final File finalFile = file;
        final FileWriter finalWriter = writer;
        AnAction showBuildLogAction = new AnAction(CidrBundle.message("build.action.showLog", new Object[0]), null, AllIcons.Debugger.Console){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (finalFile == null) {
                    return;
                }
                try {
                    Runtime.getRuntime().exec("open " + finalFile.getPath());
                }
                catch (IOException e) {
                    OCLog.LOG.error("Cannot open build log file: " + finalFile, (Throwable)e);
                }
            }

            public boolean isDumbAware() {
                return true;
            }

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(finalFile != null);
            }
        };
        if (finalWriter != null) {
            context.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    try {
                        finalWriter.close();
                    }
                    catch (IOException e) {
                        OCLog.LOG.warn((Throwable)e);
                    }
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    try {
                        finalWriter.write(event.getText());
                    }
                    catch (IOException e) {
                        OCLog.LOG.warn((Throwable)e);
                    }
                }
            });
        }
        Disposable disposable = new Disposable(){

            public void dispose() {
                if (finalWriter != null) {
                    try {
                        finalWriter.close();
                    }
                    catch (IOException e) {
                        OCLog.LOG.warn((Throwable)e);
                    }
                }
                if (finalFile != null) {
                    FileUtil.delete((File)finalFile);
                }
            }
        };
        return Pair.create((Object)showBuildLogAction, (Object)disposable);
    }

    public static class BuildContentRemoveListener
    extends ContentManagerAdapter {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ContentManager myContentManager;
        @NotNull
        private final Content myContent;
        @NotNull
        private final BuildContext myContext;

        public BuildContentRemoveListener(@NotNull Project project2, @NotNull ContentManager contentManager, @NotNull Content content, @NotNull BuildContext context) {
            this.myProject = project2;
            this.myContentManager = contentManager;
            this.myContent = content;
            this.myContext = context;
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            if (event.getContent() != this.myContent) {
                return;
            }
            this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            if (event.getContent() != this.myContent) {
                return;
            }
            if (this.myContext.isRunning()) {
                int result = Messages.showYesNoDialog((Project)this.myProject, (String)CidrBundle.message("build.inProgress.cancelQuestion", new Object[0]), (String)CidrBundle.message("build.inProgress", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result == 0) {
                    this.myContext.stop();
                } else {
                    event.consume();
                }
            }
        }
    }

    public static class BuildContext {
        @NotNull
        protected final ExecutionResult<CidrBuildResult> myResult = new ExecutionResult();
        private static final Key<Semaphore> BUILD_SEMAPHORE_KEY = Key.create((String)"BUILD_SEMAPHORE_KEY");
        @NotNull
        public final CidrBuildId id;
        @NotNull
        public final CidrBuildConfiguration buildConfiguration;
        @NotNull
        public final CidrBuildTaskType taskType;
        @NotNull
        public final String taskName;
        @NotNull
        public final String progressTitle;
        private final Project myProject;
        private final Semaphore myBuildSemaphore;
        @NotNull
        public ProgressIndicator indicator;
        @NotNull
        public ProcessHandler processHandler;
        @Nullable
        public String finishMessage;
        @Nullable
        public String finishDetails;
        public final long started = System.currentTimeMillis();
        public long duration;
        public int errors;
        public int warnings;

        public BuildContext(@NotNull Project project2, @NotNull CidrBuildConfiguration buildConfiguration, @Nullable CidrBuildTaskType taskType, @NotNull String taskName, @NotNull String progressTitle) {
            this.myProject = project2;
            this.id = CidrBuildId.create();
            this.buildConfiguration = buildConfiguration;
            this.taskType = taskType == null ? CidrBuildTaskType.BUILD : taskType;
            this.taskName = taskName;
            this.progressTitle = progressTitle;
            Semaphore semaphore = (Semaphore)this.myProject.getUserData(BUILD_SEMAPHORE_KEY);
            if (semaphore == null) {
                semaphore = (Semaphore)((UserDataHolderEx)this.myProject).putUserDataIfAbsent(BUILD_SEMAPHORE_KEY, (Object)new Semaphore(1));
            }
            this.myBuildSemaphore = semaphore;
        }

        public boolean isRunning() {
            return !this.indicator.isCanceled() && !this.processHandler.isProcessTerminated() && !this.processHandler.isProcessTerminating();
        }

        public ExecutionResult<CidrBuildResult> getResult() {
            return this.myResult;
        }

        public void stop() {
            this.indicator.cancel();
        }

        /*
         * Exception decompiling
         */
        public boolean waitAndStart() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void finished(@NotNull CidrBuildResult buildResult) {
            this.myBuildSemaphore.release();
            this.myResult.set(buildResult);
            ((CidrBuildListener)this.myProject.getMessageBus().syncPublisher(CidrBuildListener.TOPIC)).afterFinished(new CidrBuildEvent(this.buildConfiguration, this.taskType, this.id), buildResult);
        }

        private void canceled() {
            this.myResult.set(new CidrBuildResult(false, true, this.started, System.currentTimeMillis() - this.started, this.errors, this.warnings, CidrBundle.message("build.canceled", this.taskName)));
        }

        public void error(Throwable e) {
            this.myBuildSemaphore.release();
            this.myResult.setException(e);
        }
    }
}

