/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build;

import com.intellij.execution.ExecutionException;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBuildUtil {
    public static void handleProjectTaskResults(@NotNull ExecutionResult<CidrBuildResult> result, @Nullable ProjectTaskNotification callback) {
        if (callback != null) {
            try {
                CidrBuildResult buildResult = result.get();
                callback.finished(new ProjectTaskResult(buildResult.getCanceled(), buildResult.getSucceeded() ? 0 : Integer.max(1, buildResult.getErrors()), buildResult.getWarnings()));
            }
            catch (ExecutionException ex) {
                callback.finished(new ProjectTaskResult(false, 1, 0));
            }
        }
    }
}

