/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build.runners;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.util.concurrency.FutureResult;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.execution.build.runners.BackgroundableProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CompositeCallback;
import com.jetbrains.cidr.execution.build.runners.FutureCallback;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J@\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010 \u001a\u00020\u0015H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/execution/build/runners/BackgroundableProjectTaskRunner;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "tasks", "", "Lcom/intellij/task/ProjectTask;", "parentRunner", "Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;", "callback", "Lcom/intellij/task/ProjectTaskNotification;", "sessionId", "", "context", "Lcom/intellij/task/ProjectTaskContext;", "waitingIndicator", "Ljava/util/concurrent/Future;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;Lcom/intellij/task/ProjectTaskNotification;Ljava/lang/Object;Lcom/intellij/task/ProjectTaskContext;Ljava/util/concurrent/Future;)V", "executionStarted", "Lcom/intellij/util/concurrency/FutureResult;", "", "getExecutionStarted", "()Lcom/intellij/util/concurrency/FutureResult;", "collectTasks", "run", "", "indicator", "runTask", "runner", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "task", "waitForStart", "intellij.cidr.common"})
final class BackgroundableProjectTaskRunner
extends Task.Backgroundable {
    @NotNull
    private final FutureResult<Boolean> executionStarted;
    private final Collection<ProjectTask> tasks;
    private final CidrProjectTaskRunner parentRunner;
    private final ProjectTaskNotification callback;
    private final Object sessionId;
    private final ProjectTaskContext context;
    private final Future<ProgressIndicator> waitingIndicator;

    @NotNull
    public final FutureResult<Boolean> getExecutionStarted() {
        return this.executionStarted;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        block11: {
            if (!this.waitForStart()) {
                return;
            }
            Collection<ProjectTask> myTasks = this.collectTasks(this.tasks);
            if (myTasks.isEmpty()) {
                ProjectTaskNotification projectTaskNotification = this.callback;
                if (projectTaskNotification != null) {
                    projectTaskNotification.finished(new ProjectTaskResult(false, 1, 0));
                }
                return;
            }
            CompositeCallback compositeCallback = this.callback == null ? null : new CompositeCallback(this.callback, myTasks.size());
            try {
                for (ProjectTask task : myTasks) {
                    CidrTaskRunner taskRunner = this.parentRunner.runnerForTask(task);
                    if (taskRunner == null) {
                        CompositeCallback compositeCallback2 = compositeCallback;
                        if (compositeCallback2 == null) break;
                        compositeCallback2.forceFinished(new ProjectTaskResult(false, 1, 0));
                        break;
                    }
                    Future<Boolean> future = this.runTask(taskRunner, this.getProject(), task, compositeCallback, this.sessionId, this.context);
                    if (future.get().booleanValue()) continue;
                    CompositeCallback compositeCallback3 = compositeCallback;
                    if (compositeCallback3 == null) break;
                    compositeCallback3.forceFinished(new ProjectTaskResult(false, 1, 0));
                    break;
                }
            }
            catch (InterruptedException ex) {
                CompositeCallback compositeCallback4 = compositeCallback;
                if (compositeCallback4 != null) {
                    compositeCallback4.forceFinished(new ProjectTaskResult(true, 0, 0));
                }
                throw (Throwable)new ProcessCanceledException((Throwable)ex);
            }
            catch (CancellationException ex) {
                CompositeCallback compositeCallback5 = compositeCallback;
                if (compositeCallback5 != null) {
                    compositeCallback5.forceFinished(new ProjectTaskResult(true, 0, 0));
                }
                throw (Throwable)new ProcessCanceledException((Throwable)ex);
            }
            catch (Throwable ex) {
                CidrLog.LOG.error(ex);
                CompositeCallback compositeCallback6 = compositeCallback;
                if (compositeCallback6 == null) break block11;
                compositeCallback6.forceFinished(new ProjectTaskResult(false, 1, 0));
            }
        }
    }

    private final boolean waitForStart() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return true;
        }
        try {
            boolean cancelled = this.waitingIndicator.get().isCanceled();
            this.executionStarted.set((Object)true);
            return !cancelled;
        }
        catch (InterruptedException ex) {
            ProjectTaskNotification projectTaskNotification = this.callback;
            if (projectTaskNotification != null) {
                projectTaskNotification.finished(new ProjectTaskResult(true, 0, 0));
            }
            throw (Throwable)new ProcessCanceledException((Throwable)ex);
        }
        catch (CancellationException ex) {
            ProjectTaskNotification projectTaskNotification = this.callback;
            if (projectTaskNotification != null) {
                projectTaskNotification.finished(new ProjectTaskResult(true, 0, 0));
            }
            throw (Throwable)new ProcessCanceledException((Throwable)ex);
        }
        catch (Throwable ex) {
            block7: {
                CidrLog.LOG.error(ex);
                ProjectTaskNotification projectTaskNotification = this.callback;
                if (projectTaskNotification == null) break block7;
                projectTaskNotification.finished(new ProjectTaskResult(true, 1, 0));
            }
            throw (Throwable)new ProcessCanceledException(ex);
        }
    }

    private final Future<Boolean> runTask(CidrTaskRunner runner, Project project2, ProjectTask task, ProjectTaskNotification callback, Object sessionId, ProjectTaskContext context) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        runner.executeTask(project2, task, new FutureCallback(callback, future), sessionId, context);
        return future;
    }

    private final Collection<ProjectTask> collectTasks(Collection<? extends ProjectTask> tasks2) {
        boolean bl;
        List expandedTasks2;
        block3: {
            expandedTasks2 = StreamsKt.toList(tasks2.stream().filter((Predicate<? extends ProjectTask>)new Predicate<ProjectTask>(this){
                final /* synthetic */ BackgroundableProjectTaskRunner this$0;

                public final boolean test(ProjectTask it) {
                    return BackgroundableProjectTaskRunner.access$getParentRunner$p(this.this$0).canRun(it);
                }
                {
                    this.this$0 = backgroundableProjectTaskRunner;
                }
            }).map(new Function<T, R>(this){
                final /* synthetic */ BackgroundableProjectTaskRunner this$0;

                @NotNull
                public final Pair<ProjectTask, CidrTaskRunner> apply(ProjectTask it) {
                    return TuplesKt.to((Object)it, (Object)BackgroundableProjectTaskRunner.access$getParentRunner$p(this.this$0).runnerForTask(it));
                }
                {
                    this.this$0 = backgroundableProjectTaskRunner;
                }
            }).filter(collectTasks.expandedTasks.3.INSTANCE).map(collectTasks.expandedTasks.4.INSTANCE));
            Iterable $receiver$iv = expandedTasks2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    List it = (List)element$iv;
                    boolean bl2 = false;
                    if (!it.isEmpty()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.flatten((Iterable)expandedTasks2);
    }

    public BackgroundableProjectTaskRunner(@NotNull Project project2, @NotNull Collection<? extends ProjectTask> tasks2, @NotNull CidrProjectTaskRunner parentRunner, @Nullable ProjectTaskNotification callback, @NotNull Object sessionId, @NotNull ProjectTaskContext context, @NotNull Future<ProgressIndicator> waitingIndicator) {
        super(project2, CidrBundle.message("build.progress", new Object[0]), true);
        this.tasks = tasks2;
        this.parentRunner = parentRunner;
        this.callback = callback;
        this.sessionId = sessionId;
        this.context = context;
        this.waitingIndicator = waitingIndicator;
        this.executionStarted = new FutureResult();
    }

    public static final /* synthetic */ CidrProjectTaskRunner access$getParentRunner$p(BackgroundableProjectTaskRunner $this) {
        return $this.parentRunner;
    }
}

