/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build.runners;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.util.concurrency.FutureResult;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.build.runners.BackgroundableProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.execution.build.runners.WaitingTask;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Future;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000fH&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;", "Lcom/intellij/task/ProjectTaskRunner;", "()V", "myBuildSessionsQueue", "Lcom/intellij/openapi/progress/BackgroundTaskQueue;", "run", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/task/ProjectTaskContext;", "callback", "Lcom/intellij/task/ProjectTaskNotification;", "tasks", "", "Lcom/intellij/task/ProjectTask;", "runnerForTask", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "task", "intellij.cidr.common"})
public abstract class CidrProjectTaskRunner
extends ProjectTaskRunner {
    private final BackgroundTaskQueue myBuildSessionsQueue = new BackgroundTaskQueue(null, CidrBundle.message("build.progress", new Object[0]));

    public void run(@NotNull Project project2, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks2) {
        if (project2.isDisposed()) {
            return;
        }
        Object object = context.getSessionId();
        if (object == null) {
            object = UUID.randomUUID();
        }
        Object sessionId = object;
        FutureResult waitingIndicator = new FutureResult();
        BackgroundableProjectTaskRunner queuedTask = new BackgroundableProjectTaskRunner(project2, tasks2, this, callback, sessionId, context, (Future)waitingIndicator);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new WaitingTask(project2, (FutureResult<ProgressIndicator>)waitingIndicator, (Future)queuedTask.getExecutionStarted()).queue();
        }
        this.myBuildSessionsQueue.run((Task.Backgroundable)queuedTask, null, (ProgressIndicator)new EmptyProgressIndicator());
    }

    @Nullable
    public abstract CidrTaskRunner runnerForTask(@NotNull ProjectTask var1);
}

