/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBExpressionPlaceholder;
import com.jetbrains.cidr.lang.editor.CidrInjectionListener;
import com.jetbrains.cidr.lang.psi.CidrCodeFragment;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBackendConsoleInjectionHelper
implements BackendConsoleInjectionHelper {
    @Override
    public void subscribeToInjection(final @NotNull XDebugSession session) {
        final MessageBusConnection connection = session.getProject().getMessageBus().connect();
        class Listener
        implements CidrInjectionListener,
        XDebugSessionListener {
            private volatile Pair<Document, CidrCodeFragment> myDocumentAndFragment;

            Listener() {
            }

            @Override
            public void didInject(@NotNull PsiFile injected, PsiLanguageInjectionHost host) {
                Document document2;
                if (host instanceof GDBExpressionPlaceholder && (document2 = host.getContainingFile().getOriginalFile().getViewProvider().getDocument()) != null) {
                    this.myDocumentAndFragment = Pair.create((Object)document2, (Object)((CidrCodeFragment)injected));
                    CidrBackendConsoleInjectionHelper.updateContextInGDBConsole((Pair<Document, CidrCodeFragment>)this.myDocumentAndFragment);
                }
            }

            public void stackFrameChanged() {
                VirtualFile file;
                Pair<Document, CidrCodeFragment> documentAndFragment = this.myDocumentAndFragment;
                if (documentAndFragment != null && (file = FileDocumentManager.getInstance().getFile((Document)documentAndFragment.first)) != null) {
                    ApplicationManager.getApplication().invokeLater(() -> PsiDocumentManager.getInstance((Project)session.getProject()).reparseFiles(Collections.singleton(file), true), ModalityState.NON_MODAL);
                }
            }

            public void sessionStopped() {
                connection.disconnect();
            }
        }
        Listener listener = new Listener();
        connection.subscribe(CidrInjectionListener.INJECTION_TOPIC, (Object)listener);
        session.addSessionListener((XDebugSessionListener)listener);
    }

    private static void updateContextInGDBConsole(@Nullable Pair<Document, CidrCodeFragment> documentAndFragment) {
        if (documentAndFragment == null) {
            return;
        }
        CidrDebugProcess process2 = (CidrDebugProcess)((Document)documentAndFragment.first).getUserData(CidrDebugProcess.DEBUG_PROCESS_KEY);
        if (process2 != null) {
            ((CidrCodeFragment)documentAndFragment.second).setContext(process2.getDebuggerContext());
        }
    }
}

