/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerCommandExecutor;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerModuleMemory;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakPointBroadcast;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointHandler;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrDebugProcess
extends XDebugProcess
implements DebuggerDriver.Handler,
UserDataHolderEx {
    public static final long ABORT_COMMAND_TIMEOUT = 3000L;
    public static final String BACKEND_CONTENT_ID = "DEBUGGER_BACKEND_CONSOLE";
    public static final Key<CidrDebugProcess> DEBUG_PROCESS_KEY = Key.create((String)CidrDebugProcess.class.getSimpleName());
    public static final Key THROW_ON_THREAD_COLLECTION = Key.create((String)"THROW_ON_THREAD_COLLECTION");
    public static final Key THROW_ON_FRAME_COLLECTION = Key.create((String)"THROW_ON_FRAME_COLLECTION");
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private final Disposable myDisposable;
    private final CidrDebuggerCommandExecutor myDebuggerCommandExecutor;
    private final MyProcessHandler myProcessHandler;
    private final DebuggerDriver myDriverDoNotUse;
    private final String myDriverName;
    private final DebuggerDriverConfiguration myConfiguration;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private final CidrBreakpointHandler myBreakpointHandler;
    private final CidrWatchpointHandler myWatchpointHandler;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final CidrExceptionBreakpointHandler myExceptionBreakpointHandler;
    @Nullable
    private final CidrSymbolicBreakpointHandler mySymbolicBreakpointHandler;
    private final Semaphore myAttachedSemaphore = new Semaphore(0);
    protected final ConsoleView myConsole;
    private final List<Filter> myBackendConsoleFilters;
    private volatile LanguageConsoleView myBackendConsole;
    @NotNull
    private final CidrDebuggerModuleMemory myMemory;
    protected final RunParameters myRunParameters;
    private final ConcurrentMap<Language, CidrDebuggerTypesHelper> myTypesHelpers = ContainerUtil.newConcurrentMap();
    private final List<Couple<File>> mySymbolFiles = ContainerUtil.newArrayList();
    final ExecutionResult<DebuggerDriver.Inferior> myInferiorResult = new ExecutionResult();
    private volatile State myState = State.INITIALIZED;
    private volatile String myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connecting", (Object[])new Object[0]);
    private final Map<Pair<String, Integer>, CachedValue<List<String>>> myCompletionCache = new HashMap<Pair<String, Integer>, CachedValue<List<String>>>();

    public CidrDebugProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder) throws ExecutionException {
        this(parameters, session, consoleBuilder, it -> Filter.EMPTY_ARRAY);
    }

    public CidrDebugProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsoleFilterProvider backendConsoleFilterProvider) throws ExecutionException {
        super(session);
        session.setPauseActionSupported(true);
        this.myRunParameters = parameters;
        this.myConfiguration = parameters.getDebuggerDriverConfiguration();
        this.myDriverName = this.myConfiguration.getDriverName();
        this.myDisposable = Disposer.newDisposable((String)"CidrDebugProcess");
        Disposer.register((Disposable)this.getProject(), (Disposable)this.myDisposable);
        this.myDriverDoNotUse = this.myConfiguration.createDriver(this);
        this.myDebuggerCommandExecutor = new CidrDebuggerCommandExecutor(this, this.myDriverDoNotUse, this.myDisposable);
        final BaseProcessHandler driverProcessHandler = this.myDriverDoNotUse.getProcessHandler();
        this.myProcessHandler = new MyProcessHandler();
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                driverProcessHandler.startNotify();
            }

            private boolean shouldDetach(boolean willBeDestroyed) {
                return !willBeDestroyed;
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                CidrDebugProcess.this.myAttachedSemaphore.release();
                Alarm forceTerminateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
                CidrDebugProcess.this.postCommand(driver -> {
                    try {
                        if (this.shouldDetach(willBeDestroyed)) {
                            CidrDebugProcess.this.myInferiorResult.get().detach();
                        } else {
                            CidrDebugProcess.this.myInferiorResult.get().destroy();
                        }
                    }
                    finally {
                        if (forceTerminateAlarm.cancelAllRequests() > 0) {
                            CidrDebugProcess.this.myConfiguration.getHostMachine().destroyProcess(driverProcessHandler);
                        }
                    }
                    driver.checkErrors();
                });
                forceTerminateAlarm.addRequest(() -> {
                    CidrDebuggerLog.LOG.warn("Cannot detach/abort. Forcing driver termination");
                    CidrDebugProcess.this.myConfiguration.getHostMachine().destroyProcess(driverProcessHandler);
                }, 3000L, ModalityState.any());
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                CidrDebugProcess.this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
                CidrDebugProcess.this.myState = State.FINISHED;
                Disposer.dispose((Disposable)CidrDebugProcess.this.myDisposable);
            }
        }, this.myDisposable);
        this.myEditorsProvider = CidrDebugProcess.createEditorsProvider(session.getRunProfile());
        this.myBreakpointHandler = this.createBreakpointHandler();
        this.myWatchpointHandler = new CidrWatchpointHandler(this);
        this.myExceptionBreakpointHandler = this.createExceptionHandler();
        this.mySymbolicBreakpointHandler = this.createSymbolicHandler();
        List handlersList = ContainerUtil.packNullables((Object[])new XBreakpointHandler[]{this.myBreakpointHandler, this.myWatchpointHandler, this.myExceptionBreakpointHandler, this.mySymbolicBreakpointHandler});
        this.myBreakpointHandlers = handlersList.toArray(XBreakpointHandler.EMPTY_ARRAY);
        this.myConsole = consoleBuilder.getConsole();
        this.myBackendConsoleFilters = ContainerUtil.newSmartList((Object[])backendConsoleFilterProvider.getDefaultFilters(this.getProject()));
        this.myMemory = new CidrDebuggerModuleMemory(this, this.myDisposable);
    }

    @NotNull
    public String getCurrentStateMessage() {
        return this.myCurrentStateMessage;
    }

    @NotNull
    public ConsoleView getConsole() {
        return this.myConsole;
    }

    @NotNull
    private static XDebuggerEditorsProvider createEditorsProvider(RunProfile profile2) throws ExecutionException {
        return CidrDebuggerLanguageSupportManager.createEditor(profile2);
    }

    public boolean isDetachDefault() {
        return false;
    }

    public boolean supportsWatchpoints() {
        return this.myDriverDoNotUse.supportsWatchpoints();
    }

    public boolean supportsWatchpointLifetime() {
        return this.myDriverDoNotUse.supportsWatchpointLifetime();
    }

    public Project getProject() {
        return this.getSession().getProject();
    }

    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        return this.myConfiguration.createEvaluationContext(driver, expirable, frame);
    }

    public boolean driverSupportsArrayEvaluation() {
        return this.myConfiguration.supportsArrayEvaluation();
    }

    public boolean driverSupportsCodeFragmentEvaluation() {
        return this.myConfiguration.isCodeFragmentEvaluationSupported();
    }

    public boolean driverSupportsDisasm() {
        return this.myDriverDoNotUse.supportsDisasm();
    }

    public DebuggerDriver getDriverInTests() {
        return this.myDriverDoNotUse;
    }

    public DebuggerDriver.Inferior getInferiorInTests() {
        try {
            return this.myInferiorResult.get();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    protected ProcessHandler doGetProcessHandler() {
        return this.myProcessHandler;
    }

    protected boolean waitForTermination() {
        return this.myDriverDoNotUse.getProcessHandler().waitFor();
    }

    boolean waitForAttach(int timeout) throws InterruptedException {
        return this.myAttachedSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public final void start() {
        this.myState = State.STARTING;
        this.myBackendConsole = new LanguageConsoleImpl(this.getProject(), this.myDriverName, this.myDriverDoNotUse.getConsoleLanguage());
        this.myBackendConsoleFilters.forEach(arg_0 -> ((LanguageConsoleView)this.myBackendConsole).addMessageFilter(arg_0));
        this.myBackendConsole.getConsoleEditor().getDocument().putUserData(DEBUG_PROCESS_KEY, (Object)this);
        this.myBackendConsole.setEditable(false);
        this.postCommand((DebuggerDriver driver) -> {
            DebuggerDriver.Inferior inferior;
            try {
                inferior = this.doLoadTarget(driver);
                List<Couple<File>> list = this.mySymbolFiles;
                synchronized (list) {
                    for (Couple<File> file : this.mySymbolFiles) {
                        driver.addSymbolsFile((File)file.first, (File)file.second);
                    }
                    this.mySymbolFiles.clear();
                }
                this.myState = State.STARTED;
            }
            catch (ExecutionException e) {
                this.myInferiorResult.setException(e);
                throw e;
            }
            this.myInferiorResult.set(inferior);
        });
    }

    @NotNull
    protected abstract DebuggerDriver.Inferior doLoadTarget(@NotNull DebuggerDriver var1) throws ExecutionException;

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(){

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                Content content = ui.createContent(CidrDebugProcess.BACKEND_CONTENT_ID, CidrDebugProcess.this.myBackendConsole.getComponent(), CidrDebugProcess.this.myDriverName, AllIcons.Debugger.Console, null);
                Disposer.register((Disposable)ui.getContentManager(), (Disposable)CidrDebugProcess.this.myBackendConsole);
                content.setCloseable(false);
                ui.addContent(content, 0, PlaceInGrid.center, false);
                for (BackendConsoleInjectionHelper helper : (BackendConsoleInjectionHelper[])BackendConsoleInjectionHelper.EP_NAME.getExtensions()) {
                    helper.subscribeToInjection(CidrDebugProcess.this.getSession());
                }
                LanguageConsoleBuilder.registerExecuteAction((LanguageConsoleView)CidrDebugProcess.this.myBackendConsole, text -> CidrDebugProcess.this.executeConsoleCommand((String)text), (String)"AppCode.Debug.Console", null, null);
                CidrDebugProcess.this.getSession().addSessionListener(new XDebugSessionListener(){

                    public void sessionPaused() {
                        this.enableConsole(true);
                    }

                    public void sessionResumed() {
                        this.enableConsole(false);
                    }

                    public void sessionStopped() {
                        this.enableConsole(false);
                    }

                    private void enableConsole(boolean enabled) {
                        UIUtil.invokeAndWaitIfNeeded(() -> {
                            if (CidrDebugProcess.this.getProject().isDisposed() || Disposer.isDisposed((Disposable)CidrDebugProcess.this.myBackendConsole)) {
                                return;
                            }
                            CidrDebugProcess.this.myBackendConsole.setEditable(enabled);
                        });
                    }
                });
            }
        };
    }

    public boolean checkCanPerformCommands() {
        if (this.myDriverDoNotUse.isInPromptMode()) {
            this.getSession().reportMessage(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]), MessageType.WARNING);
            RunnerLayoutUi ui = this.getSession().getUI();
            Content gdbContent = ui.findContent(BACKEND_CONTENT_ID);
            ui.selectAndFocus(gdbContent, true, true);
            return false;
        }
        return true;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.myEditorsProvider;
    }

    @NotNull
    protected CidrBreakpointHandler createBreakpointHandler() {
        return new CidrBreakpointHandler(this);
    }

    @NotNull
    protected CidrExceptionBreakpointHandler createExceptionHandler() {
        return new CidrExceptionBreakpointHandler(this, (Class<? extends CidrExceptionBreakpointType>)CidrExceptionBreakpointType.class);
    }

    @Nullable
    private CidrSymbolicBreakpointHandler createSymbolicHandler() {
        CidrSymbolicBreakpointType symbolicBreakpointType = (CidrSymbolicBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class));
        return symbolicBreakpointType != null ? new CidrSymbolicBreakpointHandler(this, (Class<? extends XBreakpointType<XBreakpoint<CidrSymbolicBreakpointType.Properties>, ?>>)((Object)((Object)symbolicBreakpointType)).getClass()) : null;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        return this.myBreakpointHandlers;
    }

    @NotNull
    public ConsoleView createConsole() {
        this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        return this.myConsole;
    }

    public LanguageConsoleView getDebuggerConsole() {
        return this.myBackendConsole;
    }

    public void sessionInitialized() {
        this.postCommand((DebuggerDriver driver) -> {
            if (this.myState != State.STARTED) {
                return;
            }
            this.doStartTarget(this.myInferiorResult.get());
            this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]);
            this.getSession().rebuildViews();
        });
    }

    protected long doStartTarget(@NotNull DebuggerDriver.Inferior inferior) throws ExecutionException {
        return inferior.start();
    }

    public void stop() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            this.myWatchpointHandler.cleanup();
        }, (ModalityState)ModalityState.defaultModalityState());
        this.getProcessHandler().destroyProcess();
    }

    public void startPausing() {
        this.postCommand(DebuggerDriver::interrupt);
    }

    public void resume(@Nullable XSuspendContext context) {
        this.postCommand(DebuggerDriver::resume);
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        Address address = this.positionToAddress(position);
        this.postCommand((DebuggerDriver driver) -> {
            if (address != null) {
                driver.runTo(address);
            } else {
                driver.runTo(position.getFile().getPath(), position.getLine());
            }
        });
    }

    @Nullable
    private Address positionToAddress(@NotNull XSourcePosition position) {
        CidrMemoryDoc<?> memoryDoc = this.fileToMemoryDoc(position.getFile());
        return memoryDoc == null ? null : memoryDoc.getAddress(position);
    }

    @Nullable
    private CidrMemoryDoc<?> fileToMemoryDoc(@NotNull VirtualFile virtualFile) {
        if (!(virtualFile instanceof MemoryViewFile)) {
            return null;
        }
        MemoryViewFile memoryViewFile = (MemoryViewFile)virtualFile;
        CidrMemoryDoc<?> memoryDoc = memoryViewFile.getMemoryDoc();
        if (memoryDoc != null && !this.myMemory.contains(memoryDoc)) {
            return null;
        }
        return memoryDoc;
    }

    private static boolean isDisassemblyContext(@Nullable XSuspendContext context) {
        if (context == null) {
            return false;
        }
        XExecutionStack stack = context.getActiveExecutionStack();
        if (stack == null) {
            return false;
        }
        XStackFrame frame = stack.getTopFrame();
        if (!(frame instanceof CidrStackFrame)) {
            return false;
        }
        return !((CidrStackFrame)frame).hasSourceFile();
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context);
        this.postCommand((DebuggerDriver driver) -> driver.stepOver(stepByInstruction));
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context);
        this.postCommand((DebuggerDriver driver) -> driver.stepInto(false, stepByInstruction));
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        boolean stepByInstruction = CidrDebugProcess.isDisassemblyContext(context);
        this.postCommand((DebuggerDriver driver) -> driver.stepInto(true, stepByInstruction));
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.postCommand(DebuggerDriver::stepOut);
    }

    @Nullable
    public XSourcePosition createDisasmPosition(@NotNull Address address) {
        if (!this.driverSupportsDisasm()) {
            return null;
        }
        return this.myMemory.getDisasmDoc().getAddressPosition(address);
    }

    @Nullable
    public XSourcePosition createMemoryPosition(@NotNull Address address) {
        if (!this.driverSupportsDisasm()) {
            return null;
        }
        return this.myMemory.getHexdumpDoc().getAddressPosition(address);
    }

    protected void executeConsoleCommand(@NotNull String text) {
        long threadId = this.getCurrentThreadId();
        int frameIndex = this.getCurrentFrameIndex();
        this.postCommand((DebuggerDriver driver) -> {
            try {
                driver.executeConsoleCommand(threadId, frameIndex, text);
            }
            catch (DebuggerCommandException e) {
                this.printlnToConsole(e.getMessage());
            }
        });
    }

    @NotNull
    public CompletableFuture<Void> postCommand(@NotNull VoidDebuggerCommand command) {
        return this.postCommand((DebuggerCommand)command);
    }

    @NotNull
    public <T> CompletableFuture<T> postCommand(@NotNull DebuggerCommand<T> command) {
        return this.myDebuggerCommandExecutor.executeCommandAsync(command);
    }

    @NotNull
    public CidrDebuggerCommandExecutor getDebuggerCommandExecutor() {
        return this.myDebuggerCommandExecutor;
    }

    public void handleConsoleCompletion(CompletionParameters parameters, CompletionResultSet result) {
        int offset;
        String command = parameters.getOriginalFile().getText();
        Pair key = new Pair((Object)command, (Object)(offset = parameters.getOffset() > 0 ? parameters.getOffset() - 1 : 0));
        Object cachedValue = this.myCompletionCache.get(key);
        if (cachedValue == null) {
            cachedValue = new CachedValueImpl<List<String>>(() -> {
                ArrayList completions = new ArrayList();
                Semaphore completionSemaphore = new Semaphore(0);
                this.postCommand((DebuggerDriver driver) -> driver.handleCompletion(command, offset, completions));
                try {
                    completionSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return new CachedValueProvider.Result(completions, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }){

                public boolean isFromMyProject(Project project2) {
                    return true;
                }
            };
        }
        this.myCompletionCache.put((Pair<String, Integer>)key, (CachedValue<List<String>>)cachedValue);
        List completions = (List)cachedValue.getValue();
        for (String str : completions) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)str));
        }
    }

    @Nullable
    public PsiElement getDebuggerContext() {
        return this.getDebuggerContext(this.getCurrentPosition());
    }

    @Nullable
    public PsiElement getDebuggerContext(@Nullable XSourcePosition position) {
        return position == null ? null : (PsiElement)ReadAction.compute(() -> this.getTypesHelper(position).getContextElement(position));
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebuggerTypesHelper getTypesHelper(@NotNull CidrStackFrame frame) {
        return this.getTypesHelper(CidrDebuggerLanguageSupportManager.getLanguage(frame));
    }

    @NotNull
    public CidrDebuggerTypesHelper getTypesHelper(@NotNull XSourcePosition position) {
        return this.getTypesHelper(CidrDebuggerLanguageSupportManager.getLanguage(position));
    }

    private CidrDebuggerTypesHelper getTypesHelper(@Nullable Language language) {
        Language key = language == null ? Language.ANY : language;
        CidrDebuggerTypesHelper helper = (CidrDebuggerTypesHelper)this.myTypesHelpers.get(key);
        if (helper == null) {
            helper = CidrDebuggerLanguageSupportManager.createTypesHelper(language, this);
            this.myTypesHelpers.put(key, helper);
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSymbolsFile(File dSYM, File module2) {
        CidrDebuggerLog.LOG.assertTrue(this.myState == State.INITIALIZED, (Object)("Session is already started: " + (Object)((Object)this.myState)));
        List<Couple<File>> list = this.mySymbolFiles;
        synchronized (list) {
            this.mySymbolFiles.add((Couple<File>)Couple.of((Object)dSYM, (Object)module2));
        }
    }

    @NotNull
    public RunParameters getRunParameters() {
        return this.myRunParameters;
    }

    protected void handleCommandException(@NotNull DebuggerDriver driver, @NotNull DebuggerCommand<?> command, @NotNull ExecutionException exception) {
        DebuggerIllegalStateException illegalState = (DebuggerIllegalStateException)((Object)ExceptionUtil.findCause((Throwable)exception, DebuggerIllegalStateException.class));
        if (illegalState != null) {
            CidrDebuggerLog.LOG.info((Throwable)exception);
            String message = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)illegalState));
            command.rejected(message);
            if (!(command instanceof DebuggerUIUpdateCommand)) {
                this.getSession().reportMessage(message, MessageType.WARNING);
            }
            return;
        }
        if (ExceptionUtil.causedBy((Throwable)exception, ExecutionFinishedException.class)) {
            if (!ExceptionUtil.causedBy((Throwable)exception, ProcessCanceledException.class)) {
                CidrDebuggerLog.LOG.debug((Throwable)exception);
            }
            this.getSession().stop();
            return;
        }
        boolean isFatalError = ExceptionUtil.causedBy((Throwable)exception, DebuggerFatalException.class);
        if (command instanceof DebuggerStartupCommand || isFatalError) {
            CidrDebuggerLog.LOG.debug((Throwable)exception);
            this.printlnToConsole(exception.getMessage());
            this.reportErrorInRedBalloon(exception);
            if (isFatalError) {
                driver.getProcessHandler().destroyProcess();
            } else {
                this.getSession().stop();
            }
            return;
        }
        if (!(exception instanceof ThrowInTest.TestException)) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                CidrDebuggerLog.LOG.warn((Throwable)exception);
            } else {
                CidrDebuggerLog.LOG.error((Throwable)exception);
            }
        }
    }

    private void reportErrorInRedBalloon(ExecutionException e) {
        String message = e.getMessage();
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            CidrDebuggerLog.LOG.error("Execution errors must have error description", (Throwable)e);
            message = CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e));
        }
        this.getSession().reportMessage(message, MessageType.ERROR, (HyperlinkListener)ExceptionUtil.findCause((Throwable)e, HyperlinkListener.class));
    }

    public void printlnToConsole(@Nullable String message) {
        if (message != null && !this.getProject().isDisposed()) {
            if (!StringUtil.endsWithLineBreak((CharSequence)(message = StringUtil.stripHtml((String)message, (boolean)true)))) {
                message = message + "\n";
            }
            this.getProcessHandler().notifyTextAvailable(message, ProcessOutputTypes.SYSTEM);
        }
    }

    @Nullable
    public XSourcePosition getCurrentPosition() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        return frame != null ? frame.getSourcePosition() : null;
    }

    public long getCurrentThreadId() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getThreadId() : -1L;
    }

    public int getCurrentFrameIndex() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getFrameIndex() : -1;
    }

    @Override
    public void handleRunning() {
        this.getSession().sessionResumed();
    }

    @Override
    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        this.getSession().positionReached((XSuspendContext)new CidrSuspendContext(stopPlace, null));
    }

    @Override
    public void handleSignal(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause("Signal", signal + " (" + meaning + ")"));
    }

    @Override
    public void handleException(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull String description) {
        this.doHandleSignalled(stopPlace, new CidrSuspensionCause("Exception", description));
    }

    private void doHandleSignalled(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull CidrSuspensionCause cause) {
        this.printlnToConsole(cause.getDisplayString());
        ((XDebugSessionImpl)this.getSession()).positionReached((XSuspendContext)new CidrSuspendContext(stopPlace, cause), true);
    }

    @Override
    public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
        Object b = this.myBreakpointHandler.getCodepoint(breakpointNumber);
        if (b == null) {
            b = this.myExceptionBreakpointHandler.getCodepoint(breakpointNumber);
        }
        if (b == null && this.mySymbolicBreakpointHandler != null) {
            b = this.mySymbolicBreakpointHandler.getCodepoint(breakpointNumber);
        }
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleWatchpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int watchpointNumber) {
        Object b = this.myWatchpointHandler.getCodepoint(watchpointNumber);
        this.handleCodepoint(stopPlace, (XBreakpoint<?>)b);
    }

    @Override
    public void handleAttached(int pid) {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.attachedTo", pid));
        this.myAttachedSemaphore.release();
    }

    @Override
    public void handleConnected(@NotNull String connection) {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.connectedTo", connection));
    }

    @Override
    public void handleDetached() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.detached", new Object[0]));
        this.getSession().stop();
    }

    @Override
    public void handleDisconnected() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.disconnected", new Object[0]));
        this.getSession().stop();
    }

    protected void handleCodepoint(@NotNull DebuggerDriver.StopPlace stopPlace, @Nullable XBreakpoint<?> b) {
        XBreakpointProperties props;
        CidrSuspensionCause cause = null;
        XBreakpointProperties xBreakpointProperties = props = b != null ? b.getProperties() : null;
        if (props instanceof CidrExceptionBreakpointType.Properties) {
            cause = new CidrSuspensionCause("Exception", "Exception breakpoint");
        }
        CidrSuspendContext suspendContext = new CidrSuspendContext(stopPlace, cause);
        if (b == null) {
            ((XDebugSessionImpl)this.getSession()).positionReached((XSuspendContext)suspendContext, true);
            return;
        }
        String expression = b.getLogExpression();
        if (expression == null) {
            boolean shouldSuspend = this.getSession().breakpointReached(b, null, (XSuspendContext)suspendContext);
            if (!shouldSuspend) {
                this.postCommand(DebuggerDriver::resume);
            }
            return;
        }
        this.postCommand((DebuggerDriver driver) -> {
            boolean shouldSuspend;
            String evaluatedLogExpression;
            block7: {
                evaluatedLogExpression = null;
                XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
                XStackFrame frame = executionStack != null ? executionStack.getTopFrame() : null;
                XSourcePosition sourcePosition = frame != null ? frame.getSourcePosition() : null;
                CidrEvaluator evaluator = (CidrEvaluator)(frame != null ? frame.getEvaluator() : null);
                try {
                    if (evaluator != null) {
                        try {
                            CidrEvaluatedValue evaluatedValue = evaluator.doEvaluate(driver, sourcePosition, (XExpression)XExpressionImpl.fromText((String)expression));
                            evaluatedLogExpression = expression + " = " + evaluatedValue.getConsoleDescription(evaluatedValue.createEvaluationContext(driver, null));
                        }
                        catch (DebuggerCommandException e) {
                            evaluatedLogExpression = "error evaluating " + expression + ": " + e.getMessage();
                        }
                        break block7;
                    }
                    evaluatedLogExpression = "error evaluating " + expression;
                }
                catch (Throwable throwable) {
                    boolean shouldSuspend2 = this.getSession().breakpointReached(b, evaluatedLogExpression, (XSuspendContext)suspendContext);
                    if (!shouldSuspend2) {
                        driver.resume();
                    }
                    throw throwable;
                }
            }
            if (!(shouldSuspend = this.getSession().breakpointReached(b, evaluatedLogExpression, (XSuspendContext)suspendContext))) {
                driver.resume();
            }
        });
    }

    @Override
    public void handleTargetOutput(@NotNull String text, @NotNull Key type) {
        this.myProcessHandler.notifyTextAvailable(text, type);
    }

    @Override
    public void handleGDBOutput(@NotNull String text) {
        GuiUtils.invokeLaterIfNeeded(() -> this.myBackendConsole.print(text, ConsoleViewContentType.NORMAL_OUTPUT), (ModalityState)ModalityState.any());
    }

    @Override
    public void handlePrompt(@NotNull String prompt) {
        GuiUtils.invokeLaterIfNeeded(() -> {
            LanguageConsoleView backendConsole = this.myBackendConsole;
            if (this.getProject().isDisposed() || backendConsole == null || Disposer.isDisposed((Disposable)backendConsole)) {
                return;
            }
            this.getDebuggerConsole().setPrompt(prompt);
        }, (ModalityState)ModalityState.any());
    }

    @Override
    public void handleTargetFinished(int code, @Nullable String description) {
        this.myProcessHandler.setExitCode(code);
        if (description != null) {
            this.myProcessHandler.notifyTextAvailable(description + "\n", ProcessOutputTypes.SYSTEM);
        }
        this.getSession().stop();
    }

    @Override
    public void handleTargetTerminated() {
        this.getSession().stop();
    }

    @Override
    public void handleExited(int code) {
        this.getSession().stop();
    }

    @Override
    public void handleWatchpointScope(int watchpointNumber) {
        GuiUtils.invokeLaterIfNeeded(() -> this.myWatchpointHandler.handleWatchpointScope(watchpointNumber), (ModalityState)ModalityState.any());
        this.postCommand(DebuggerDriver::resume);
    }

    @Override
    public void handleModulesLoaded(@NotNull List<LLModule> modules) {
    }

    @Override
    public void handleBreakpointChanged(LLBreakPointBroadcast broadcast_change) {
        XLineBreakpoint breakpoint = (XLineBreakpoint)this.myBreakpointHandler.getCodepoint(broadcast_change.getId());
        if (breakpoint == null) {
            return;
        }
        LLBreakpoint lb = new LLBreakpoint(broadcast_change.getId(), breakpoint.getFileUrl(), breakpoint.getLine(), broadcast_change.getNumLocations(), broadcast_change.getNumResolvedLocations(), false, broadcast_change.getIsValid(), "", "");
        if (lb.getBreakpointValidityState() == LLBreakpoint.ValidityState.RESOLVED) {
            this.getSession().updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_verified_breakpoint, null);
        }
    }

    @NotNull
    protected XExecutionStack newExecutionStack(@NotNull LLThread thread, @Nullable LLFrame frame, boolean current, @Nullable CidrSuspensionCause cause) {
        return new CidrExecutionStack(thread, frame, current, cause);
    }

    public static boolean viewsUpdatesDisabledInTests(@NotNull Object container) {
        return ApplicationManager.getApplication().isUnitTestMode() && !container.getClass().getSimpleName().contains("XTest");
    }

    private class CidrExecutionStack
    extends XExecutionStack {
        @NotNull
        private final LLThread myThread;
        @Nullable
        private volatile CidrStackFrame myTopFrame;
        @Nullable
        private final CidrSuspensionCause mySuspensionCause;

        CidrExecutionStack(@Nullable LLThread thread, LLFrame frame, @Nullable boolean current, CidrSuspensionCause suspensionCause) {
            super(thread.getDisplayName(), current ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadSuspended);
            this.myThread = thread;
            this.mySuspensionCause = suspensionCause;
            this.myTopFrame = frame == null ? null : this.newFrame(frame);
        }

        public XStackFrame getTopFrame() {
            return this.myTopFrame;
        }

        public void computeStackFrames(int originalFrom, XExecutionStack.XStackFrameContainer container) {
            if (CidrDebugProcess.viewsUpdatesDisabledInTests(container)) {
                return;
            }
            CidrDebugProcess.this.postCommand(driver -> {
                try {
                    boolean hasMore;
                    boolean repeat;
                    if (container.isObsolete()) {
                        return;
                    }
                    ThrowInTest.doThrow((UserDataHolder)CidrDebugProcess.this, THROW_ON_FRAME_COLLECTION);
                    ArrayList<CidrStackFrame> result = new ArrayList<CidrStackFrame>();
                    CidrStackFrame toSelect = null;
                    int currentFrom = originalFrom;
                    int currentBatchSize = 100;
                    do {
                        if (container.isObsolete()) {
                            return;
                        }
                        repeat = false;
                        DebuggerDriver.ResultList<LLFrame> framesResult = driver.getFrames(this.myThread.getId(), currentFrom, currentBatchSize, currentFrom == 0);
                        CidrStackFrame top = this.myTopFrame;
                        result.ensureCapacity(result.size() + framesResult.list.size());
                        for (int i = 0; i < framesResult.list.size(); ++i) {
                            CidrStackFrame frame;
                            if (container.isObsolete()) {
                                return;
                            }
                            if (currentFrom == 0 && i == 0) {
                                if (top != null) {
                                    frame = top;
                                } else {
                                    top = this.myTopFrame = this.newFrame((LLFrame)framesResult.list.get(i));
                                    frame = this.myTopFrame;
                                }
                            } else {
                                frame = this.newFrame((LLFrame)framesResult.list.get(i));
                            }
                            result.add(frame);
                        }
                        hasMore = framesResult.hasMore;
                        if (originalFrom != 0 || top == null || top.hasSourceFile() || this.shouldSelectDisasmFrame() || (toSelect = (CidrStackFrame)result.stream().filter(CidrStackFrame::hasSourceFile).findFirst().orElse(null)) != null || !hasMore || framesResult.list.size() >= currentBatchSize) continue;
                        currentFrom = framesResult.list.size();
                        currentBatchSize -= currentFrom;
                        repeat = true;
                    } while (repeat);
                    if (container instanceof XStackFrameContainerEx) {
                        ((XStackFrameContainerEx)container).addStackFrames(result, toSelect, !hasMore);
                    } else {
                        CidrDebuggerLog.LOG.error("Expected instanceof XStackFrameContainerEx, got" + container.getClass());
                        container.addStackFrames(result, !hasMore);
                    }
                    if (hasMore && !container.isObsolete()) {
                        this.computeStackFrames(currentFrom + result.size(), container);
                    }
                }
                catch (DebuggerCommandException e) {
                    container.errorOccurred(e.getMessage());
                }
                catch (ExecutionException e) {
                    container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                    throw e;
                }
            });
        }

        private boolean shouldSelectDisasmFrame() {
            if (!CidrDebugProcess.this.driverSupportsDisasm()) {
                return false;
            }
            return this.mySuspensionCause == null;
        }

        @NotNull
        private CidrStackFrame newFrame(@NotNull LLFrame frame) {
            return new CidrStackFrame(CidrDebugProcess.this, this.myThread, frame, this.mySuspensionCause);
        }

        @Nullable
        public GutterIconRenderer getExecutionLineIconRenderer() {
            if (this.mySuspensionCause == null) {
                return super.getExecutionLineIconRenderer();
            }
            return new GutterIconRenderer(){

                @NotNull
                public Icon getIcon() {
                    return ((CidrExecutionStack)CidrExecutionStack.this).mySuspensionCause.icon;
                }

                @Nullable
                public String getTooltipText() {
                    return CidrExecutionStack.this.mySuspensionCause.getDisplayString();
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                        return false;
                    }
                    return Comparing.equal((Object)CidrExecutionStack.this.mySuspensionCause, (Object)((CidrExecutionStack)((Object)o)).mySuspensionCause);
                }

                public int hashCode() {
                    return CidrExecutionStack.this.mySuspensionCause.hashCode();
                }

                public boolean isDumbAware() {
                    return true;
                }
            };
        }

        public String toString() {
            return this.myThread.toString();
        }
    }

    private class CidrSuspendContext
    extends XSuspendContext {
        @NotNull
        private final XExecutionStack myActiveStack;
        private final long myActiveStackFrameId;

        CidrSuspendContext(@Nullable DebuggerDriver.StopPlace stopPlace, CidrSuspensionCause cause) {
            this.myActiveStack = CidrDebugProcess.this.newExecutionStack(stopPlace.thread, stopPlace.frame, true, cause);
            this.myActiveStackFrameId = stopPlace.thread.getId();
        }

        @Nullable
        public XExecutionStack getActiveExecutionStack() {
            return this.myActiveStack;
        }

        public void computeExecutionStacks(XSuspendContext.XExecutionStackContainer container) {
            if (CidrDebugProcess.viewsUpdatesDisabledInTests(container)) {
                return;
            }
            CidrDebugProcess.this.postCommand(driver -> {
                try {
                    ThrowInTest.doThrow((UserDataHolder)CidrDebugProcess.this, THROW_ON_THREAD_COLLECTION);
                    List<LLThread> threads = driver.getThreads();
                    ArrayList<XExecutionStack> stacks = new ArrayList<XExecutionStack>(threads.size());
                    for (LLThread each : threads) {
                        stacks.add(each.getId() == this.myActiveStackFrameId ? this.myActiveStack : CidrDebugProcess.this.newExecutionStack(each, null, false, null));
                    }
                    container.addExecutionStack(stacks, true);
                }
                catch (DebuggerCommandException e) {
                    container.errorOccurred(e.getMessage());
                }
                catch (ExecutionException e) {
                    container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                    throw e;
                }
            });
        }
    }

    private class MyProcessHandler
    extends ProcessHandler {
        private final AtomicReference<Integer> myExitCode = new AtomicReference();
        private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

        private MyProcessHandler() {
        }

        public void setExitCode(int exitCode) {
            this.myExitCode.set(exitCode);
        }

        @NotNull
        public Integer getExitCode() {
            Integer exitCode = this.myExitCode.get();
            return exitCode == null ? 0 : exitCode;
        }

        protected void destroyProcessImpl() {
            this.doDestroyOrDetach(false);
        }

        protected void detachProcessImpl() {
            this.doDestroyOrDetach(true);
        }

        private void doDestroyOrDetach(boolean detach) {
            ProcessIOExecutorService.INSTANCE.submit(() -> {
                if (CidrDebugProcess.this.waitForTermination()) {
                    if (detach) {
                        this.notifyProcessDetached();
                    } else {
                        this.notifyProcessTerminated(this.getExitCode());
                    }
                }
            });
        }

        public boolean detachIsDefault() {
            return CidrDebugProcess.this.isDetachDefault();
        }

        public OutputStream getProcessInput() {
            return CidrDebugProcess.this.myDriverDoNotUse.getProcessInput();
        }

        public final void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
            this.myAnsiEscapeDecoder.escapeText(text, outputType, (x$0, x$1) -> super.notifyTextAvailable(x$0, x$1));
        }
    }

    public static interface DebuggerUIUpdateCommand
    extends VoidDebuggerCommand {
    }

    public static interface DebuggerStartupCommand
    extends VoidDebuggerCommand {
    }

    @FunctionalInterface
    public static interface VoidDebuggerCommand
    extends DebuggerCommand<Void> {
        public void run(@NotNull DebuggerDriver var1) throws ExecutionException, DebuggerCommandException;

        @Override
        default public Void call(@NotNull DebuggerDriver driver) throws ExecutionException, DebuggerCommandException {
            this.run(driver);
            return null;
        }
    }

    @FunctionalInterface
    public static interface DebuggerCommand<R> {
        public R call(@NotNull DebuggerDriver var1) throws ExecutionException, DebuggerCommandException;

        default public void rejected(@NotNull String reason) {
        }
    }

    static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        FINISHED;

    }
}

