/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerEditorsExtension;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerEditorsExtensionPoint;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    private static final CidrDebuggerEditorsExtension DEFAULT_EXTENSION = Arrays.stream(CidrDebuggerEditorsExtensionPoint.EP_NAME.getExtensions()).filter(it -> it.isDefault).findFirst().get().getInstance();
    @NotNull
    private static final FileType DEFAULT_FILE_TYPE = DEFAULT_EXTENSION.getSupportedLanguage().getAssociatedFileType();

    @NotNull
    public final FileType getFileType() {
        return DEFAULT_FILE_TYPE;
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@NotNull Project project2, @Nullable XSourcePosition sourcePosition) {
        return Collections.singleton(CidrDebuggerEditorsProvider.getLanguage(null, sourcePosition));
    }

    @NotNull
    public Document createDocument(@NotNull Project project2, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        String text = expression.getExpression();
        if (sourcePosition != null) {
            Language language = CidrDebuggerEditorsProvider.getLanguage(expression, sourcePosition);
            CidrDebuggerEditorsExtension extension = Arrays.stream(CidrDebuggerEditorsExtensionPoint.EP_NAME.getExtensions()).map(CidrDebuggerEditorsExtensionPoint::getInstance).filter(it -> language == it.getSupportedLanguage()).findFirst().orElse(DEFAULT_EXTENSION);
            PsiElement context = extension.getContext(project2, sourcePosition);
            if (context != null) {
                return (Document)WriteAction.computeAndWait(() -> {
                    PsiFile fragment = extension.createExpressionCodeFragment(project2, text, context, mode);
                    return PsiDocumentManager.getInstance((Project)project2).getDocument(fragment);
                });
            }
        }
        LightVirtualFile plainTextFile = new LightVirtualFile("oc-debug-editor-when-no-source-position-available.txt", (CharSequence)text);
        return FileDocumentManager.getInstance().getDocument((VirtualFile)plainTextFile);
    }

    @NotNull
    private static Language getLanguage(@Nullable XExpression expression, @Nullable XSourcePosition position) {
        FileType type;
        if (expression != null && expression.getLanguage() != null) {
            return expression.getLanguage();
        }
        if (position != null && (type = position.getFile().getFileType()) instanceof LanguageFileType) {
            return ((LanguageFileType)type).getLanguage();
        }
        return DEFAULT_EXTENSION.getSupportedLanguage();
    }

    @NotNull
    public InlineDebuggerHelper getInlineDebuggerHelper() {
        return new InlineDebuggerHelper(){

            public boolean shouldEvaluateChildrenByDefault(@NotNull XNamedTreeNode node) {
                return !CidrDebuggerSettings.getInstance().MUTE_VARIABLES && DEFAULT.shouldEvaluateChildrenByDefault(node);
            }
        };
    }
}

