/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrEvaluator
extends XDebuggerEvaluator {
    public static final Key THROW_ON_EVALUATION = Key.create((String)"THROW_ON_EVALUATION");
    @NotNull
    protected final CidrStackFrame myFrame;

    public CidrEvaluator(@NotNull CidrStackFrame frame) {
        this.myFrame = frame;
    }

    @NotNull
    public CidrEvaluatedValue doEvaluate(@NotNull DebuggerDriver driver, @Nullable XSourcePosition valuePosition, @NotNull XExpression expression) throws ExecutionException, DebuggerCommandException {
        String expr;
        LLValue val;
        ThrowInTest.doThrow((UserDataHolder)this.myFrame.getProcess(), THROW_ON_EVALUATION);
        EvaluationContext context = this.createEvaluationContext(driver);
        if (expression.getMode() == EvaluationMode.EXPRESSION) {
            Pair<LLValue, String> pair2 = CidrEvaluatorHelper.getInstance().convertAndEvaluate(this.myFrame.getProcess(), driver, expression, valuePosition, this.myFrame);
            val = (LLValue)((Object)pair2.first);
            expr = (String)pair2.second;
        } else {
            val = context.evaluate(expression.getExpression());
            expr = expression.getExpression();
        }
        return new CidrEvaluatedValue(val, this.myFrame.getProcess(), valuePosition, this.myFrame, expr);
    }

    public boolean isCodeFragmentEvaluationSupported() {
        return this.myFrame.getProcess().driverSupportsCodeFragmentEvaluation();
    }

    protected EvaluationContext createEvaluationContext(DebuggerDriver driver) {
        return this.myFrame.getProcess().createEvaluationContext(driver, null, this.myFrame);
    }
}

