/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import org.jetbrains.annotations.NotNull;

public class ShowInMemoryViewAction
extends XDebuggerTreeActionBase {
    private static final String HEX_PREFIX = "0x";

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        if (!super.isEnabled(node, e)) {
            return false;
        }
        XValue value = (XValue)node.getValueContainer();
        if (!(value instanceof CidrPhysicalValue)) {
            return false;
        }
        String shownAddress = ((CidrPhysicalValue)value).getShownAddress();
        return shownAddress != null && shownAddress.startsWith(HEX_PREFIX);
    }

    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        CidrPhysicalValue value = (CidrPhysicalValue)node.getValueContainer();
        String shownAddress = value.getShownAddress();
        if (shownAddress != null && shownAddress.startsWith(HEX_PREFIX)) {
            Address address;
            try {
                address = Address.parseHexString(shownAddress);
            }
            catch (NumberFormatException e1) {
                return;
            }
            CidrDebugProcess debugProcess = value.getProcess();
            XSourcePosition memoryPosition = debugProcess.createMemoryPosition(address);
            if (memoryPosition != null) {
                Project project2 = debugProcess.getProject();
                Navigatable memoryPositionNavigatable = memoryPosition.createNavigatable(project2);
                memoryPositionNavigatable.navigate(true);
                ApplicationManager.getApplication().invokeLater(() -> ShowInMemoryViewAction.highlightRange(project2, memoryPosition));
            }
        }
    }

    private static void highlightRange(@NotNull Project project2, @NotNull XSourcePosition memoryPosition) {
        Editor[] editors;
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        int offset = memoryPosition.getOffset();
        TextRange range = TextRange.create((int)offset, (int)(offset + 2));
        VirtualFile virtualFile = memoryPosition.getFile();
        Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document2 == null) {
            return;
        }
        for (Editor editor : editors = EditorFactory.getInstance().getEditors(document2, project2)) {
            highlightManager.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, false, null);
        }
    }
}

